// Author: 
//  Raphael Slinckx <raphael@slinckx.net> 
//
// (C) 2005 Raphael Slinckx <raphael@slinckx.net>
// 
using System;

namespace Imendio.Blam {
    [DBus.Interface ("org.gnome.feed.Reader")]
    abstract class DBusFeedReaderProxy {
	public static string Service = "org.gnome.feed.Reader";
	public static string ObjectPath = "/org/gnome/feed/Reader";
	
	[DBus.Method]
	public abstract bool Subscribe (string uri);
    }

    class DBusFeedReader : DBusFeedReaderProxy {
	private Application app;
		
	public DBusFeedReader (Application app)
	{
	    this.app = app;
	}

	/*
	 * Subscribe to the given new feed url
	 */
	public override bool Subscribe (string url)
	{
	    Channel channel = new Channel ();
	    
	    channel.Url = url;
	    
	    app.CCollection.Add (channel);
	    return true;
	}
    }
}
