# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to Motorola phones"""

from prototypes import *
from prototypes_moto import *
from p_etsi import *

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb

# charset constant
CHARSET_8859_1="8859-1"
CHARSET_8859_A="8859-A"
CHARSET_8859_C="8859-C"
CHARSET_8859_H="8859-H"
CHARSET_ASCII="ASCII"
CHARSET_GSM="GSM"
CHARSET_KSC5601="KSC5601"
CHARSET_UCS2="UCS2"
CHARSET_UTF8="UTF8"

# phone mode constant
MODE_MODEM=0
MODE_PHONEBOOK=2
MODE_OBEX=22

# phonebook constant
PB_DIALED='DC'
PB_MISSED='MC'
PB_MAIN='AD'
PB_INCOMING='RC'
PB_QUICKDIAL='QD'

LOCAL_TYPE_LOCAL=129
LOCAL_TYPE_INTERNATIONAL=145
LOCAL_TYPE_UNKNOWN=128

NUMBER_TYPE_WORK=0
NUMBER_TYPE_HOME=1
NUMBER_TYPE_MAIN=2
NUMBER_TYPE_MOBILE=3
NUMBER_TYPE_FAX=4
NUMBER_TYPE_PAGER=5
NUMBER_TYPE_EMAIL=6
NUMBER_TYPE_MAILING_LIST=7
NUMBER_TYPE_NAME={
    NUMBER_TYPE_WORK: 'office',
    NUMBER_TYPE_HOME: 'home',
    NUMBER_TYPE_MAIN: 'main',
    NUMBER_TYPE_MOBILE: 'cell',
    NUMBER_TYPE_FAX: 'fax',
    NUMBER_TYPE_PAGER: 'pager' }
NUMBER_TYPE_CODE={
    'office': NUMBER_TYPE_WORK,
    'home': NUMBER_TYPE_HOME,
    'main': NUMBER_TYPE_MAIN,
    'cell': NUMBER_TYPE_MOBILE,
    'fax': NUMBER_TYPE_FAX,
    'pager': NUMBER_TYPE_PAGER }

PB_MAX_NUMBER_LEN=32
PB_MAX_NAME_LEN=24
PB_MAX_EMAIL_LEN=48

PB_TOTAL_ENTRIES=500
PB_RANGE=xrange(1,PB_TOTAL_ENTRIES+1)
PB_TOTAL_MISSED_CALLS=60
PB_TOTAL_DIALED_CALLS=60
PB_TOTAL_RECEIVED_CALLS=60

PB_TOTAL_GROUP=30
PB_GROUP_RANGE=xrange(1, PB_TOTAL_GROUP+1)
PB_GROUP_NAME_LEN=24

RT_BUILTIN=0x0C
RT_CUSTOM=0x0D
RT_INDEX_FILE='/MyToneDB.db'

# SMS Stuff
SMS_INBOX="IM"
SMS_OUTBOX="OM"
SMS_INFO="BM"
SMS_DRAFTS="DM"
SMS_COMBINE="MT"

SMS_REC_UNREAD="REC UNREAD"
SMS_REC_READ="REC READ"
SMS_STO_UNSENT="STO UNSENT"
SMS_STO_SENT="STO SENT"
SMS_ALL="ALL"
SMS_HEADER_ONLY="HEADER ONLY"

SMS_INDEX_RANGE=xrange(1, 353)

class esnrequest(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(esnrequest,self).__init__(**dict)
        if self.__class__ is esnrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(esnrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(esnrequest,kwargs)
        if len(args):
            dict2={ 'quotechar': None, 'terminator': None,                  'default': '+CGSN' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CGSN' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CGSN' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CGSN' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+CGSN' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class esnresponse(BaseProtogenClass):
    __fields=['command', 'esnlabel', 'esn']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(esnresponse,self).__init__(**dict)
        if self.__class__ is esnresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(esnresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(esnresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_esnlabel.writetobuffer(buf)
        self.__field_esn.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+CGSN:' })
        self.__field_command.readfrombuffer(buf)
        self.__field_esnlabel=DATA(**{'sizeinbytes': 3})
        self.__field_esnlabel.readfrombuffer(buf)
        self.__field_esn=CSVSTRING(**{ 'quotechar': None, 'terminator': None })
        self.__field_esn.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+CGSN:' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_esnlabel(self):
        return self.__field_esnlabel.getvalue()

    def __setfield_esnlabel(self, value):
        if isinstance(value,DATA):
            self.__field_esnlabel=value
        else:
            self.__field_esnlabel=DATA(value,**{'sizeinbytes': 3})

    def __delfield_esnlabel(self): del self.__field_esnlabel

    esnlabel=property(__getfield_esnlabel, __setfield_esnlabel, __delfield_esnlabel, None)

    def __getfield_esn(self):
        return self.__field_esn.getvalue()

    def __setfield_esn(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_esn=value
        else:
            self.__field_esn=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None })

    def __delfield_esn(self): del self.__field_esn

    esn=property(__getfield_esn, __setfield_esn, __delfield_esn, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('esnlabel', self.__field_esnlabel, None)
        yield ('esn', self.__field_esn, None)




class string_resp(BaseProtogenClass):
    __fields=['command', 'value']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(string_resp,self).__init__(**dict)
        if self.__class__ is string_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(string_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(string_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_value.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': ord(' ') })
        self.__field_command.readfrombuffer(buf)
        self.__field_value=CSVSTRING(**{ 'quotechar': None,                  'terminator': None })
        self.__field_value.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': ord(' ') })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_value(self):
        return self.__field_value.getvalue()

    def __setfield_value(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_value=value
        else:
            self.__field_value=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None })

    def __delfield_value(self): del self.__field_value

    value=property(__getfield_value, __setfield_value, __delfield_value, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('value', self.__field_value, None)




class manufacturer_req(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(manufacturer_req,self).__init__(**dict)
        if self.__class__ is manufacturer_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(manufacturer_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(manufacturer_req,kwargs)
        if len(args):
            dict2={ 'quotechar': None, 'terminator': None,                  'default': '+GMI' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMI' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMI' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMI' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+GMI' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class model_req(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(model_req,self).__init__(**dict)
        if self.__class__ is model_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(model_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(model_req,kwargs)
        if len(args):
            dict2={ 'quotechar': None, 'terminator': None,                  'default': '+GMM' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMM' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMM' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMM' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+GMM' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class number_req(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(number_req,self).__init__(**dict)
        if self.__class__ is number_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(number_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(number_req,kwargs)
        if len(args):
            dict2={ 'quotechar': None, 'terminator': None,                  'default': '+CNUM' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CNUM' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CNUM' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CNUM' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+CNUM' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class firmware_req(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(firmware_req,self).__init__(**dict)
        if self.__class__ is firmware_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(firmware_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(firmware_req,kwargs)
        if len(args):
            dict2={ 'quotechar': None, 'terminator': None,                  'default': '+GMR' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMR' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMR' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+GMR' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+GMR' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class signal_req(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(signal_req,self).__init__(**dict)
        if self.__class__ is signal_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(signal_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(signal_req,kwargs)
        if len(args):
            dict2={ 'quotechar': None, 'terminator': None,                  'default': '+CSQ?' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CSQ?' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CSQ?' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CSQ?' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+CSQ?' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class signal_resp(BaseProtogenClass):
    __fields=['command', 'rssi', 'ber']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(signal_resp,self).__init__(**dict)
        if self.__class__ is signal_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(signal_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(signal_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_rssi.writetobuffer(buf)
        self.__field_ber.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': ord(' ') })
        self.__field_command.readfrombuffer(buf)
        self.__field_rssi=CSVINT()
        self.__field_rssi.readfrombuffer(buf)
        self.__field_ber=CSVINT(**{ 'terminator': None })
        self.__field_ber.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': ord(' ') })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_rssi(self):
        return self.__field_rssi.getvalue()

    def __setfield_rssi(self, value):
        if isinstance(value,CSVINT):
            self.__field_rssi=value
        else:
            self.__field_rssi=CSVINT(value,)

    def __delfield_rssi(self): del self.__field_rssi

    rssi=property(__getfield_rssi, __setfield_rssi, __delfield_rssi, None)

    def __getfield_ber(self):
        return self.__field_ber.getvalue()

    def __setfield_ber(self, value):
        if isinstance(value,CSVINT):
            self.__field_ber=value
        else:
            self.__field_ber=CSVINT(value,**{ 'terminator': None })

    def __delfield_ber(self): del self.__field_ber

    ber=property(__getfield_ber, __setfield_ber, __delfield_ber, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('rssi', self.__field_rssi, None)
        yield ('ber', self.__field_ber, None)




class battery_req(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(battery_req,self).__init__(**dict)
        if self.__class__ is battery_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(battery_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(battery_req,kwargs)
        if len(args):
            dict2={ 'quotechar': None, 'terminator': None,                  'default': '+CBC' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CBC' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CBC' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CBC' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+CBC' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class battery_resp(BaseProtogenClass):
    __fields=['command', 'status', 'level']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(battery_resp,self).__init__(**dict)
        if self.__class__ is battery_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(battery_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(battery_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_status.writetobuffer(buf)
        self.__field_level.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': ord(' ') })
        self.__field_command.readfrombuffer(buf)
        self.__field_status=CSVINT()
        self.__field_status.readfrombuffer(buf)
        self.__field_level=CSVINT(**{ 'terminator': None })
        self.__field_level.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': ord(' ') })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_status(self):
        return self.__field_status.getvalue()

    def __setfield_status(self, value):
        if isinstance(value,CSVINT):
            self.__field_status=value
        else:
            self.__field_status=CSVINT(value,)

    def __delfield_status(self): del self.__field_status

    status=property(__getfield_status, __setfield_status, __delfield_status, None)

    def __getfield_level(self):
        return self.__field_level.getvalue()

    def __setfield_level(self, value):
        if isinstance(value,CSVINT):
            self.__field_level=value
        else:
            self.__field_level=CSVINT(value,**{ 'terminator': None })

    def __delfield_level(self): del self.__field_level

    level=property(__getfield_level, __setfield_level, __delfield_level, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('status', self.__field_status, None)
        yield ('level', self.__field_level, None)




class modereq(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(modereq,self).__init__(**dict)
        if self.__class__ is modereq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(modereq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(modereq,kwargs)
        if len(args):
            dict2={ 'quotechar': None,                  'terminator': None, 'default': '+MODE?' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MODE?' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MODE?' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MODE?' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None, 'default': '+MODE?' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class moderesp(BaseProtogenClass):
    __fields=['command', 'mode']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(moderesp,self).__init__(**dict)
        if self.__class__ is moderesp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(moderesp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(moderesp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_mode.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+MODE:' })
        self.__field_command.readfrombuffer(buf)
        self.__field_mode=CSVINT(**{ 'terminator': None })
        self.__field_mode.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+MODE:' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_mode(self):
        return self.__field_mode.getvalue()

    def __setfield_mode(self, value):
        if isinstance(value,CSVINT):
            self.__field_mode=value
        else:
            self.__field_mode=CSVINT(value,**{ 'terminator': None })

    def __delfield_mode(self): del self.__field_mode

    mode=property(__getfield_mode, __setfield_mode, __delfield_mode, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('mode', self.__field_mode, None)




class modeset(BaseProtogenClass):
    __fields=['command', 'mode']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(modeset,self).__init__(**dict)
        if self.__class__ is modeset:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(modeset,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(modeset,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MODE=' })
        self.__field_command.writetobuffer(buf)
        try: self.__field_mode
        except:
            self.__field_mode=CSVINT(**{ 'terminator': None, 'default': 0 })
        self.__field_mode.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MODE=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_mode=CSVINT(**{ 'terminator': None, 'default': 0 })
        self.__field_mode.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MODE=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None, 'default': '+MODE=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_mode(self):
        try: self.__field_mode
        except:
            self.__field_mode=CSVINT(**{ 'terminator': None, 'default': 0 })
        return self.__field_mode.getvalue()

    def __setfield_mode(self, value):
        if isinstance(value,CSVINT):
            self.__field_mode=value
        else:
            self.__field_mode=CSVINT(value,**{ 'terminator': None, 'default': 0 })

    def __delfield_mode(self): del self.__field_mode

    mode=property(__getfield_mode, __setfield_mode, __delfield_mode, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('mode', self.__field_mode, None)




class charset_set_req(BaseProtogenClass):
    __fields=['command', 'charset']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(charset_set_req,self).__init__(**dict)
        if self.__class__ is charset_set_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(charset_set_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(charset_set_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CSCS=' })
        self.__field_command.writetobuffer(buf)
        try: self.__field_charset
        except:
            self.__field_charset=CSVSTRING(**{ 'terminator': None })
        self.__field_charset.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CSCS=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_charset=CSVSTRING(**{ 'terminator': None })
        self.__field_charset.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CSCS=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None, 'default': '+CSCS=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_charset(self):
        try: self.__field_charset
        except:
            self.__field_charset=CSVSTRING(**{ 'terminator': None })
        return self.__field_charset.getvalue()

    def __setfield_charset(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_charset=value
        else:
            self.__field_charset=CSVSTRING(value,**{ 'terminator': None })

    def __delfield_charset(self): del self.__field_charset

    charset=property(__getfield_charset, __setfield_charset, __delfield_charset, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('charset', self.__field_charset, None)




class featurereq(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(featurereq,self).__init__(**dict)
        if self.__class__ is featurereq:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(featurereq,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(featurereq,kwargs)
        if len(args):
            dict2={ 'quotechar': None,                  'terminator': None, 'default': '+MAID?' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=CSVSTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MAID?' })
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MAID?' })
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MAID?' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None, 'default': '+MAID?' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class featureresp(BaseProtogenClass):
    __fields=['command', 'has_phonebook', 'has_datebook', 'has_sms', 'has_mo_sms', 'has_email', 'has_multi_phonebooks', 'has_sim', 'has_shared_phonebook', 'has_multi_dest_addr', 'has_ringtone_id', 'has_voicetag', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(featureresp,self).__init__(**dict)
        if self.__class__ is featureresp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(featureresp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(featureresp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_has_phonebook.writetobuffer(buf)
        self.__field_has_datebook.writetobuffer(buf)
        self.__field_has_sms.writetobuffer(buf)
        self.__field_has_mo_sms.writetobuffer(buf)
        self.__field_has_email.writetobuffer(buf)
        self.__field_has_multi_phonebooks.writetobuffer(buf)
        self.__field_has_sim.writetobuffer(buf)
        self.__field_has_shared_phonebook.writetobuffer(buf)
        self.__field_has_multi_dest_addr.writetobuffer(buf)
        self.__field_has_ringtone_id.writetobuffer(buf)
        self.__field_has_voicetag.writetobuffer(buf)
        try: self.__field_dunno
        except:
            self.__field_dunno=CSVSTRING(**{ 'quotechar': None,                  'terminator': None })
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+MAID:' })
        self.__field_command.readfrombuffer(buf)
        self.__field_has_phonebook=CSVINT()
        self.__field_has_phonebook.readfrombuffer(buf)
        self.__field_has_datebook=CSVINT()
        self.__field_has_datebook.readfrombuffer(buf)
        self.__field_has_sms=CSVINT()
        self.__field_has_sms.readfrombuffer(buf)
        self.__field_has_mo_sms=CSVINT()
        self.__field_has_mo_sms.readfrombuffer(buf)
        self.__field_has_email=CSVINT()
        self.__field_has_email.readfrombuffer(buf)
        self.__field_has_multi_phonebooks=CSVINT()
        self.__field_has_multi_phonebooks.readfrombuffer(buf)
        self.__field_has_sim=CSVINT()
        self.__field_has_sim.readfrombuffer(buf)
        self.__field_has_shared_phonebook=CSVINT()
        self.__field_has_shared_phonebook.readfrombuffer(buf)
        self.__field_has_multi_dest_addr=CSVINT()
        self.__field_has_multi_dest_addr.readfrombuffer(buf)
        self.__field_has_ringtone_id=CSVINT()
        self.__field_has_ringtone_id.readfrombuffer(buf)
        self.__field_has_voicetag=CSVINT()
        self.__field_has_voicetag.readfrombuffer(buf)
        self.__field_dunno=CSVSTRING(**{ 'quotechar': None,                  'terminator': None })
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+MAID:' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_has_phonebook(self):
        return self.__field_has_phonebook.getvalue()

    def __setfield_has_phonebook(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_phonebook=value
        else:
            self.__field_has_phonebook=CSVINT(value,)

    def __delfield_has_phonebook(self): del self.__field_has_phonebook

    has_phonebook=property(__getfield_has_phonebook, __setfield_has_phonebook, __delfield_has_phonebook, None)

    def __getfield_has_datebook(self):
        return self.__field_has_datebook.getvalue()

    def __setfield_has_datebook(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_datebook=value
        else:
            self.__field_has_datebook=CSVINT(value,)

    def __delfield_has_datebook(self): del self.__field_has_datebook

    has_datebook=property(__getfield_has_datebook, __setfield_has_datebook, __delfield_has_datebook, None)

    def __getfield_has_sms(self):
        return self.__field_has_sms.getvalue()

    def __setfield_has_sms(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_sms=value
        else:
            self.__field_has_sms=CSVINT(value,)

    def __delfield_has_sms(self): del self.__field_has_sms

    has_sms=property(__getfield_has_sms, __setfield_has_sms, __delfield_has_sms, None)

    def __getfield_has_mo_sms(self):
        return self.__field_has_mo_sms.getvalue()

    def __setfield_has_mo_sms(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_mo_sms=value
        else:
            self.__field_has_mo_sms=CSVINT(value,)

    def __delfield_has_mo_sms(self): del self.__field_has_mo_sms

    has_mo_sms=property(__getfield_has_mo_sms, __setfield_has_mo_sms, __delfield_has_mo_sms, None)

    def __getfield_has_email(self):
        return self.__field_has_email.getvalue()

    def __setfield_has_email(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_email=value
        else:
            self.__field_has_email=CSVINT(value,)

    def __delfield_has_email(self): del self.__field_has_email

    has_email=property(__getfield_has_email, __setfield_has_email, __delfield_has_email, None)

    def __getfield_has_multi_phonebooks(self):
        return self.__field_has_multi_phonebooks.getvalue()

    def __setfield_has_multi_phonebooks(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_multi_phonebooks=value
        else:
            self.__field_has_multi_phonebooks=CSVINT(value,)

    def __delfield_has_multi_phonebooks(self): del self.__field_has_multi_phonebooks

    has_multi_phonebooks=property(__getfield_has_multi_phonebooks, __setfield_has_multi_phonebooks, __delfield_has_multi_phonebooks, None)

    def __getfield_has_sim(self):
        return self.__field_has_sim.getvalue()

    def __setfield_has_sim(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_sim=value
        else:
            self.__field_has_sim=CSVINT(value,)

    def __delfield_has_sim(self): del self.__field_has_sim

    has_sim=property(__getfield_has_sim, __setfield_has_sim, __delfield_has_sim, None)

    def __getfield_has_shared_phonebook(self):
        return self.__field_has_shared_phonebook.getvalue()

    def __setfield_has_shared_phonebook(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_shared_phonebook=value
        else:
            self.__field_has_shared_phonebook=CSVINT(value,)

    def __delfield_has_shared_phonebook(self): del self.__field_has_shared_phonebook

    has_shared_phonebook=property(__getfield_has_shared_phonebook, __setfield_has_shared_phonebook, __delfield_has_shared_phonebook, None)

    def __getfield_has_multi_dest_addr(self):
        return self.__field_has_multi_dest_addr.getvalue()

    def __setfield_has_multi_dest_addr(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_multi_dest_addr=value
        else:
            self.__field_has_multi_dest_addr=CSVINT(value,)

    def __delfield_has_multi_dest_addr(self): del self.__field_has_multi_dest_addr

    has_multi_dest_addr=property(__getfield_has_multi_dest_addr, __setfield_has_multi_dest_addr, __delfield_has_multi_dest_addr, None)

    def __getfield_has_ringtone_id(self):
        return self.__field_has_ringtone_id.getvalue()

    def __setfield_has_ringtone_id(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_ringtone_id=value
        else:
            self.__field_has_ringtone_id=CSVINT(value,)

    def __delfield_has_ringtone_id(self): del self.__field_has_ringtone_id

    has_ringtone_id=property(__getfield_has_ringtone_id, __setfield_has_ringtone_id, __delfield_has_ringtone_id, None)

    def __getfield_has_voicetag(self):
        return self.__field_has_voicetag.getvalue()

    def __setfield_has_voicetag(self, value):
        if isinstance(value,CSVINT):
            self.__field_has_voicetag=value
        else:
            self.__field_has_voicetag=CSVINT(value,)

    def __delfield_has_voicetag(self): del self.__field_has_voicetag

    has_voicetag=property(__getfield_has_voicetag, __setfield_has_voicetag, __delfield_has_voicetag, None)

    def __getfield_dunno(self):
        try: self.__field_dunno
        except:
            self.__field_dunno=CSVSTRING(**{ 'quotechar': None,                  'terminator': None })
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_dunno=value
        else:
            self.__field_dunno=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None })

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('has_phonebook', self.__field_has_phonebook, None)
        yield ('has_datebook', self.__field_has_datebook, None)
        yield ('has_sms', self.__field_has_sms, None)
        yield ('has_mo_sms', self.__field_has_mo_sms, None)
        yield ('has_email', self.__field_has_email, None)
        yield ('has_multi_phonebooks', self.__field_has_multi_phonebooks, None)
        yield ('has_sim', self.__field_has_sim, None)
        yield ('has_shared_phonebook', self.__field_has_shared_phonebook, None)
        yield ('has_multi_dest_addr', self.__field_has_multi_dest_addr, None)
        yield ('has_ringtone_id', self.__field_has_ringtone_id, None)
        yield ('has_voicetag', self.__field_has_voicetag, None)
        yield ('dunno', self.__field_dunno, None)




class select_phonebook_req(BaseProtogenClass):
    __fields=['command', 'pb_type']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(select_phonebook_req,self).__init__(**dict)
        if self.__class__ is select_phonebook_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(select_phonebook_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(select_phonebook_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CPBS=' })
        self.__field_command.writetobuffer(buf)
        try: self.__field_pb_type
        except:
            self.__field_pb_type=CSVSTRING(**{ 'terminator': None,                  'default': PB_MAIN })
        self.__field_pb_type.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CPBS=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_pb_type=CSVSTRING(**{ 'terminator': None,                  'default': PB_MAIN })
        self.__field_pb_type.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CPBS=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None, 'default': '+CPBS=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_pb_type(self):
        try: self.__field_pb_type
        except:
            self.__field_pb_type=CSVSTRING(**{ 'terminator': None,                  'default': PB_MAIN })
        return self.__field_pb_type.getvalue()

    def __setfield_pb_type(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_pb_type=value
        else:
            self.__field_pb_type=CSVSTRING(value,**{ 'terminator': None,                  'default': PB_MAIN })

    def __delfield_pb_type(self): del self.__field_pb_type

    pb_type=property(__getfield_pb_type, __setfield_pb_type, __delfield_pb_type, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('pb_type', self.__field_pb_type, None)




class read_pb_simple_req(BaseProtogenClass):
    __fields=['command', 'start_index', 'end_index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(read_pb_simple_req,self).__init__(**dict)
        if self.__class__ is read_pb_simple_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(read_pb_simple_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(read_pb_simple_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CPBR=' })
        self.__field_command.writetobuffer(buf)
        try: self.__field_start_index
        except:
            self.__field_start_index=CSVINT(**{ 'default': 1 })
        self.__field_start_index.writetobuffer(buf)
        try: self.__field_end_index
        except:
            self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': self.start_index })
        self.__field_end_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CPBR=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_start_index=CSVINT(**{ 'default': 1 })
        self.__field_start_index.readfrombuffer(buf)
        self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': self.start_index })
        self.__field_end_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+CPBR=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None, 'default': '+CPBR=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_start_index(self):
        try: self.__field_start_index
        except:
            self.__field_start_index=CSVINT(**{ 'default': 1 })
        return self.__field_start_index.getvalue()

    def __setfield_start_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_start_index=value
        else:
            self.__field_start_index=CSVINT(value,**{ 'default': 1 })

    def __delfield_start_index(self): del self.__field_start_index

    start_index=property(__getfield_start_index, __setfield_start_index, __delfield_start_index, None)

    def __getfield_end_index(self):
        try: self.__field_end_index
        except:
            self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': self.start_index })
        return self.__field_end_index.getvalue()

    def __setfield_end_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_end_index=value
        else:
            self.__field_end_index=CSVINT(value,**{ 'terminator': None,               'default': self.start_index })

    def __delfield_end_index(self): del self.__field_end_index

    end_index=property(__getfield_end_index, __setfield_end_index, __delfield_end_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('start_index', self.__field_start_index, None)
        yield ('end_index', self.__field_end_index, None)




class read_pb_simple_resp(BaseProtogenClass):
    __fields=['command', 'index', 'number', 'local_type', 'name']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(read_pb_simple_resp,self).__init__(**dict)
        if self.__class__ is read_pb_simple_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(read_pb_simple_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(read_pb_simple_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+CPBR:' })
        self.__field_command.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        self.__field_local_type.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+CPBR:' })
        self.__field_command.readfrombuffer(buf)
        self.__field_index=CSVINT()
        self.__field_index.readfrombuffer(buf)
        self.__field_number=CSVSTRING()
        self.__field_number.readfrombuffer(buf)
        self.__field_local_type=CSVINT()
        self.__field_local_type.readfrombuffer(buf)
        self.__field_name=CSVSTRING(**{ 'terminator': None })
        self.__field_name.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+CPBR:' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+CPBR:' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_index=value
        else:
            self.__field_index=CSVINT(value,)

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_number=value
        else:
            self.__field_number=CSVSTRING(value,)

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_local_type(self):
        return self.__field_local_type.getvalue()

    def __setfield_local_type(self, value):
        if isinstance(value,CSVINT):
            self.__field_local_type=value
        else:
            self.__field_local_type=CSVINT(value,)

    def __delfield_local_type(self): del self.__field_local_type

    local_type=property(__getfield_local_type, __setfield_local_type, __delfield_local_type, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_name=value
        else:
            self.__field_name=CSVSTRING(value,**{ 'terminator': None })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('index', self.__field_index, None)
        yield ('number', self.__field_number, None)
        yield ('local_type', self.__field_local_type, None)
        yield ('name', self.__field_name, None)




class read_pb_req(BaseProtogenClass):
    __fields=['command', 'start_index', 'end_index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(read_pb_req,self).__init__(**dict)
        if self.__class__ is read_pb_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(read_pb_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(read_pb_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MPBR=' })
        self.__field_command.writetobuffer(buf)
        try: self.__field_start_index
        except:
            self.__field_start_index=CSVINT(**{ 'default': 1 })
        self.__field_start_index.writetobuffer(buf)
        try: self.__field_end_index
        except:
            self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': self.start_index })
        self.__field_end_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MPBR=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_start_index=CSVINT(**{ 'default': 1 })
        self.__field_start_index.readfrombuffer(buf)
        self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': self.start_index })
        self.__field_end_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None, 'default': '+MPBR=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None, 'default': '+MPBR=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_start_index(self):
        try: self.__field_start_index
        except:
            self.__field_start_index=CSVINT(**{ 'default': 1 })
        return self.__field_start_index.getvalue()

    def __setfield_start_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_start_index=value
        else:
            self.__field_start_index=CSVINT(value,**{ 'default': 1 })

    def __delfield_start_index(self): del self.__field_start_index

    start_index=property(__getfield_start_index, __setfield_start_index, __delfield_start_index, None)

    def __getfield_end_index(self):
        try: self.__field_end_index
        except:
            self.__field_end_index=CSVINT(**{ 'terminator': None,               'default': self.start_index })
        return self.__field_end_index.getvalue()

    def __setfield_end_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_end_index=value
        else:
            self.__field_end_index=CSVINT(value,**{ 'terminator': None,               'default': self.start_index })

    def __delfield_end_index(self): del self.__field_end_index

    end_index=property(__getfield_end_index, __setfield_end_index, __delfield_end_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('start_index', self.__field_start_index, None)
        yield ('end_index', self.__field_end_index, None)




class read_pb_resp(BaseProtogenClass):
    __fields=['command', 'index', 'number', 'local_type', 'name', 'number_type', 'voice_tag', 'ringtone', 'backlight', 'is_primary', 'group', 'icon', 'first_last_enabled', 'subfield_index', 'picture_name', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(read_pb_resp,self).__init__(**dict)
        if self.__class__ is read_pb_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(read_pb_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(read_pb_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        self.__field_local_type.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        self.__field_number_type.writetobuffer(buf)
        self.__field_voice_tag.writetobuffer(buf)
        self.__field_ringtone.writetobuffer(buf)
        self.__field_backlight.writetobuffer(buf)
        self.__field_is_primary.writetobuffer(buf)
        self.__field_group.writetobuffer(buf)
        self.__field_icon.writetobuffer(buf)
        self.__field_first_last_enabled.writetobuffer(buf)
        self.__field_subfield_index.writetobuffer(buf)
        self.__field_picture_name.writetobuffer(buf)
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+MPBR:' })
        self.__field_command.readfrombuffer(buf)
        self.__field_index=CSVINT()
        self.__field_index.readfrombuffer(buf)
        self.__field_number=CSVSTRING()
        self.__field_number.readfrombuffer(buf)
        self.__field_local_type=CSVINT()
        self.__field_local_type.readfrombuffer(buf)
        self.__field_name=CSVSTRING()
        self.__field_name.readfrombuffer(buf)
        self.__field_number_type=CSVINT()
        self.__field_number_type.readfrombuffer(buf)
        self.__field_voice_tag=CSVINT()
        self.__field_voice_tag.readfrombuffer(buf)
        self.__field_ringtone=CSVINT()
        self.__field_ringtone.readfrombuffer(buf)
        self.__field_backlight=CSVINT()
        self.__field_backlight.readfrombuffer(buf)
        self.__field_is_primary=CSVINT()
        self.__field_is_primary.readfrombuffer(buf)
        self.__field_group=CSVINT()
        self.__field_group.readfrombuffer(buf)
        self.__field_icon=CSVINT()
        self.__field_icon.readfrombuffer(buf)
        self.__field_first_last_enabled=CSVINT()
        self.__field_first_last_enabled.readfrombuffer(buf)
        self.__field_subfield_index=CSVINT()
        self.__field_subfield_index.readfrombuffer(buf)
        self.__field_picture_name=CSVSTRING()
        self.__field_picture_name.readfrombuffer(buf)
        self.__field_dunno=CSVSTRING(**{ 'quotechar': None, 'terminator': None })
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': ord(' '),                  'default': '+MPBR:' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_index=value
        else:
            self.__field_index=CSVINT(value,)

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_number=value
        else:
            self.__field_number=CSVSTRING(value,)

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_local_type(self):
        return self.__field_local_type.getvalue()

    def __setfield_local_type(self, value):
        if isinstance(value,CSVINT):
            self.__field_local_type=value
        else:
            self.__field_local_type=CSVINT(value,)

    def __delfield_local_type(self): del self.__field_local_type

    local_type=property(__getfield_local_type, __setfield_local_type, __delfield_local_type, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_name=value
        else:
            self.__field_name=CSVSTRING(value,)

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_number_type(self):
        return self.__field_number_type.getvalue()

    def __setfield_number_type(self, value):
        if isinstance(value,CSVINT):
            self.__field_number_type=value
        else:
            self.__field_number_type=CSVINT(value,)

    def __delfield_number_type(self): del self.__field_number_type

    number_type=property(__getfield_number_type, __setfield_number_type, __delfield_number_type, None)

    def __getfield_voice_tag(self):
        return self.__field_voice_tag.getvalue()

    def __setfield_voice_tag(self, value):
        if isinstance(value,CSVINT):
            self.__field_voice_tag=value
        else:
            self.__field_voice_tag=CSVINT(value,)

    def __delfield_voice_tag(self): del self.__field_voice_tag

    voice_tag=property(__getfield_voice_tag, __setfield_voice_tag, __delfield_voice_tag, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,CSVINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=CSVINT(value,)

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_backlight(self):
        return self.__field_backlight.getvalue()

    def __setfield_backlight(self, value):
        if isinstance(value,CSVINT):
            self.__field_backlight=value
        else:
            self.__field_backlight=CSVINT(value,)

    def __delfield_backlight(self): del self.__field_backlight

    backlight=property(__getfield_backlight, __setfield_backlight, __delfield_backlight, None)

    def __getfield_is_primary(self):
        return self.__field_is_primary.getvalue()

    def __setfield_is_primary(self, value):
        if isinstance(value,CSVINT):
            self.__field_is_primary=value
        else:
            self.__field_is_primary=CSVINT(value,)

    def __delfield_is_primary(self): del self.__field_is_primary

    is_primary=property(__getfield_is_primary, __setfield_is_primary, __delfield_is_primary, None)

    def __getfield_group(self):
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,CSVINT):
            self.__field_group=value
        else:
            self.__field_group=CSVINT(value,)

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_icon(self):
        return self.__field_icon.getvalue()

    def __setfield_icon(self, value):
        if isinstance(value,CSVINT):
            self.__field_icon=value
        else:
            self.__field_icon=CSVINT(value,)

    def __delfield_icon(self): del self.__field_icon

    icon=property(__getfield_icon, __setfield_icon, __delfield_icon, None)

    def __getfield_first_last_enabled(self):
        return self.__field_first_last_enabled.getvalue()

    def __setfield_first_last_enabled(self, value):
        if isinstance(value,CSVINT):
            self.__field_first_last_enabled=value
        else:
            self.__field_first_last_enabled=CSVINT(value,)

    def __delfield_first_last_enabled(self): del self.__field_first_last_enabled

    first_last_enabled=property(__getfield_first_last_enabled, __setfield_first_last_enabled, __delfield_first_last_enabled, None)

    def __getfield_subfield_index(self):
        return self.__field_subfield_index.getvalue()

    def __setfield_subfield_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_subfield_index=value
        else:
            self.__field_subfield_index=CSVINT(value,)

    def __delfield_subfield_index(self): del self.__field_subfield_index

    subfield_index=property(__getfield_subfield_index, __setfield_subfield_index, __delfield_subfield_index, None)

    def __getfield_picture_name(self):
        return self.__field_picture_name.getvalue()

    def __setfield_picture_name(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_picture_name=value
        else:
            self.__field_picture_name=CSVSTRING(value,)

    def __delfield_picture_name(self): del self.__field_picture_name

    picture_name=property(__getfield_picture_name, __setfield_picture_name, __delfield_picture_name, None)

    def __getfield_dunno(self):
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_dunno=value
        else:
            self.__field_dunno=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None })

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('index', self.__field_index, None)
        yield ('number', self.__field_number, None)
        yield ('local_type', self.__field_local_type, None)
        yield ('name', self.__field_name, None)
        yield ('number_type', self.__field_number_type, None)
        yield ('voice_tag', self.__field_voice_tag, None)
        yield ('ringtone', self.__field_ringtone, None)
        yield ('backlight', self.__field_backlight, None)
        yield ('is_primary', self.__field_is_primary, None)
        yield ('group', self.__field_group, None)
        yield ('icon', self.__field_icon, None)
        yield ('first_last_enabled', self.__field_first_last_enabled, None)
        yield ('subfield_index', self.__field_subfield_index, None)
        yield ('picture_name', self.__field_picture_name, None)
        yield ('dunno', self.__field_dunno, None)




class write_pb_req(BaseProtogenClass):
    __fields=['command', 'index', 'number', 'local_type', 'name', 'number_type', 'voice_tag', 'ringtone', 'backlight', 'is_primary', 'group', 'icon', 'first_last_enabled', 'subfield_index', 'picture_name']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(write_pb_req,self).__init__(**dict)
        if self.__class__ is write_pb_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(write_pb_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(write_pb_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+MPBW=' })
        self.__field_command.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        try: self.__field_local_type
        except:
            self.__field_local_type=CSVINT(**{ 'default': LOCAL_TYPE_LOCAL })
        self.__field_local_type.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        self.__field_number_type.writetobuffer(buf)
        try: self.__field_voice_tag
        except:
            self.__field_voice_tag=CSVINT(**{ 'default': 0 })
        self.__field_voice_tag.writetobuffer(buf)
        try: self.__field_ringtone
        except:
            self.__field_ringtone=CSVINT(**{ 'default': 255 })
        self.__field_ringtone.writetobuffer(buf)
        try: self.__field_backlight
        except:
            self.__field_backlight=CSVINT(**{ 'default': 0 })
        self.__field_backlight.writetobuffer(buf)
        try: self.__field_is_primary
        except:
            self.__field_is_primary=CSVINT(**{ 'default': 0 })
        self.__field_is_primary.writetobuffer(buf)
        try: self.__field_group
        except:
            self.__field_group=CSVINT(**{ 'default': 1 })
        self.__field_group.writetobuffer(buf)
        try: self.__field_icon
        except:
            self.__field_icon=CSVINT(**{ 'default': 255 })
        self.__field_icon.writetobuffer(buf)
        try: self.__field_first_last_enabled
        except:
            self.__field_first_last_enabled=CSVINT(**{ 'default': 255 })
        self.__field_first_last_enabled.writetobuffer(buf)
        try: self.__field_subfield_index
        except:
            self.__field_subfield_index=CSVINT(**{ 'default': 0 })
        self.__field_subfield_index.writetobuffer(buf)
        try: self.__field_picture_name
        except:
            self.__field_picture_name=CSVSTRING(**{ 'terminator': None,                  'default': "" })
        self.__field_picture_name.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+MPBW=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_index=CSVINT()
        self.__field_index.readfrombuffer(buf)
        self.__field_number=CSVSTRING(**{ 'maxsizeinbytes': PB_MAX_NUMBER_LEN,                  'raiseontruncate': False })
        self.__field_number.readfrombuffer(buf)
        self.__field_local_type=CSVINT(**{ 'default': LOCAL_TYPE_LOCAL })
        self.__field_local_type.readfrombuffer(buf)
        self.__field_name=CSVSTRING(**{ 'maxsizeinbytes': PB_MAX_NAME_LEN,                  'raiseontruncate': False })
        self.__field_name.readfrombuffer(buf)
        self.__field_number_type=CSVINT()
        self.__field_number_type.readfrombuffer(buf)
        self.__field_voice_tag=CSVINT(**{ 'default': 0 })
        self.__field_voice_tag.readfrombuffer(buf)
        self.__field_ringtone=CSVINT(**{ 'default': 255 })
        self.__field_ringtone.readfrombuffer(buf)
        self.__field_backlight=CSVINT(**{ 'default': 0 })
        self.__field_backlight.readfrombuffer(buf)
        self.__field_is_primary=CSVINT(**{ 'default': 0 })
        self.__field_is_primary.readfrombuffer(buf)
        self.__field_group=CSVINT(**{ 'default': 1 })
        self.__field_group.readfrombuffer(buf)
        self.__field_icon=CSVINT(**{ 'default': 255 })
        self.__field_icon.readfrombuffer(buf)
        self.__field_first_last_enabled=CSVINT(**{ 'default': 255 })
        self.__field_first_last_enabled.readfrombuffer(buf)
        self.__field_subfield_index=CSVINT(**{ 'default': 0 })
        self.__field_subfield_index.readfrombuffer(buf)
        self.__field_picture_name=CSVSTRING(**{ 'terminator': None,                  'default': "" })
        self.__field_picture_name.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+MPBW=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+MPBW=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_index=value
        else:
            self.__field_index=CSVINT(value,)

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_number=value
        else:
            self.__field_number=CSVSTRING(value,**{ 'maxsizeinbytes': PB_MAX_NUMBER_LEN,                  'raiseontruncate': False })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_local_type(self):
        try: self.__field_local_type
        except:
            self.__field_local_type=CSVINT(**{ 'default': LOCAL_TYPE_LOCAL })
        return self.__field_local_type.getvalue()

    def __setfield_local_type(self, value):
        if isinstance(value,CSVINT):
            self.__field_local_type=value
        else:
            self.__field_local_type=CSVINT(value,**{ 'default': LOCAL_TYPE_LOCAL })

    def __delfield_local_type(self): del self.__field_local_type

    local_type=property(__getfield_local_type, __setfield_local_type, __delfield_local_type, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_name=value
        else:
            self.__field_name=CSVSTRING(value,**{ 'maxsizeinbytes': PB_MAX_NAME_LEN,                  'raiseontruncate': False })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_number_type(self):
        return self.__field_number_type.getvalue()

    def __setfield_number_type(self, value):
        if isinstance(value,CSVINT):
            self.__field_number_type=value
        else:
            self.__field_number_type=CSVINT(value,)

    def __delfield_number_type(self): del self.__field_number_type

    number_type=property(__getfield_number_type, __setfield_number_type, __delfield_number_type, None)

    def __getfield_voice_tag(self):
        try: self.__field_voice_tag
        except:
            self.__field_voice_tag=CSVINT(**{ 'default': 0 })
        return self.__field_voice_tag.getvalue()

    def __setfield_voice_tag(self, value):
        if isinstance(value,CSVINT):
            self.__field_voice_tag=value
        else:
            self.__field_voice_tag=CSVINT(value,**{ 'default': 0 })

    def __delfield_voice_tag(self): del self.__field_voice_tag

    voice_tag=property(__getfield_voice_tag, __setfield_voice_tag, __delfield_voice_tag, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=CSVINT(**{ 'default': 255 })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,CSVINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=CSVINT(value,**{ 'default': 255 })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_backlight(self):
        try: self.__field_backlight
        except:
            self.__field_backlight=CSVINT(**{ 'default': 0 })
        return self.__field_backlight.getvalue()

    def __setfield_backlight(self, value):
        if isinstance(value,CSVINT):
            self.__field_backlight=value
        else:
            self.__field_backlight=CSVINT(value,**{ 'default': 0 })

    def __delfield_backlight(self): del self.__field_backlight

    backlight=property(__getfield_backlight, __setfield_backlight, __delfield_backlight, None)

    def __getfield_is_primary(self):
        try: self.__field_is_primary
        except:
            self.__field_is_primary=CSVINT(**{ 'default': 0 })
        return self.__field_is_primary.getvalue()

    def __setfield_is_primary(self, value):
        if isinstance(value,CSVINT):
            self.__field_is_primary=value
        else:
            self.__field_is_primary=CSVINT(value,**{ 'default': 0 })

    def __delfield_is_primary(self): del self.__field_is_primary

    is_primary=property(__getfield_is_primary, __setfield_is_primary, __delfield_is_primary, None)

    def __getfield_group(self):
        try: self.__field_group
        except:
            self.__field_group=CSVINT(**{ 'default': 1 })
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,CSVINT):
            self.__field_group=value
        else:
            self.__field_group=CSVINT(value,**{ 'default': 1 })

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_icon(self):
        try: self.__field_icon
        except:
            self.__field_icon=CSVINT(**{ 'default': 255 })
        return self.__field_icon.getvalue()

    def __setfield_icon(self, value):
        if isinstance(value,CSVINT):
            self.__field_icon=value
        else:
            self.__field_icon=CSVINT(value,**{ 'default': 255 })

    def __delfield_icon(self): del self.__field_icon

    icon=property(__getfield_icon, __setfield_icon, __delfield_icon, None)

    def __getfield_first_last_enabled(self):
        try: self.__field_first_last_enabled
        except:
            self.__field_first_last_enabled=CSVINT(**{ 'default': 255 })
        return self.__field_first_last_enabled.getvalue()

    def __setfield_first_last_enabled(self, value):
        if isinstance(value,CSVINT):
            self.__field_first_last_enabled=value
        else:
            self.__field_first_last_enabled=CSVINT(value,**{ 'default': 255 })

    def __delfield_first_last_enabled(self): del self.__field_first_last_enabled

    first_last_enabled=property(__getfield_first_last_enabled, __setfield_first_last_enabled, __delfield_first_last_enabled, None)

    def __getfield_subfield_index(self):
        try: self.__field_subfield_index
        except:
            self.__field_subfield_index=CSVINT(**{ 'default': 0 })
        return self.__field_subfield_index.getvalue()

    def __setfield_subfield_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_subfield_index=value
        else:
            self.__field_subfield_index=CSVINT(value,**{ 'default': 0 })

    def __delfield_subfield_index(self): del self.__field_subfield_index

    subfield_index=property(__getfield_subfield_index, __setfield_subfield_index, __delfield_subfield_index, None)

    def __getfield_picture_name(self):
        try: self.__field_picture_name
        except:
            self.__field_picture_name=CSVSTRING(**{ 'terminator': None,                  'default': "" })
        return self.__field_picture_name.getvalue()

    def __setfield_picture_name(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_picture_name=value
        else:
            self.__field_picture_name=CSVSTRING(value,**{ 'terminator': None,                  'default': "" })

    def __delfield_picture_name(self): del self.__field_picture_name

    picture_name=property(__getfield_picture_name, __setfield_picture_name, __delfield_picture_name, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('index', self.__field_index, None)
        yield ('number', self.__field_number, None)
        yield ('local_type', self.__field_local_type, None)
        yield ('name', self.__field_name, None)
        yield ('number_type', self.__field_number_type, None)
        yield ('voice_tag', self.__field_voice_tag, None)
        yield ('ringtone', self.__field_ringtone, None)
        yield ('backlight', self.__field_backlight, None)
        yield ('is_primary', self.__field_is_primary, None)
        yield ('group', self.__field_group, None)
        yield ('icon', self.__field_icon, None)
        yield ('first_last_enabled', self.__field_first_last_enabled, None)
        yield ('subfield_index', self.__field_subfield_index, None)
        yield ('picture_name', self.__field_picture_name, None)




class del_pb_req(BaseProtogenClass):
    __fields=['command', 'index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(del_pb_req,self).__init__(**dict)
        if self.__class__ is del_pb_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(del_pb_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(del_pb_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+MPBW=' })
        self.__field_command.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+MPBW=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_index=CSVINT(**{ 'terminator': None })
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+MPBW=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+MPBW=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_index=value
        else:
            self.__field_index=CSVINT(value,**{ 'terminator': None })

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('index', self.__field_index, None)




class sms_sel_req(BaseProtogenClass):
    __fields=['command', 'mem1', 'mem2', 'mem3']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_sel_req,self).__init__(**dict)
        if self.__class__ is sms_sel_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_sel_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_sel_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CPMS=' })
        self.__field_command.writetobuffer(buf)
        try: self.__field_mem1
        except:
            self.__field_mem1=CSVSTRING(**{ 'default': SMS_COMBINE })
        self.__field_mem1.writetobuffer(buf)
        try: self.__field_mem2
        except:
            self.__field_mem2=CSVSTRING(**{ 'default': SMS_OUTBOX })
        self.__field_mem2.writetobuffer(buf)
        try: self.__field_mem3
        except:
            self.__field_mem3=CSVSTRING(**{ 'terminator': None,                  'default': SMS_INBOX })
        self.__field_mem3.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CPMS=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_mem1=CSVSTRING(**{ 'default': SMS_COMBINE })
        self.__field_mem1.readfrombuffer(buf)
        self.__field_mem2=CSVSTRING(**{ 'default': SMS_OUTBOX })
        self.__field_mem2.readfrombuffer(buf)
        self.__field_mem3=CSVSTRING(**{ 'terminator': None,                  'default': SMS_INBOX })
        self.__field_mem3.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None, 'terminator': None,                  'default': '+CPMS=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None, 'terminator': None,                  'default': '+CPMS=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_mem1(self):
        try: self.__field_mem1
        except:
            self.__field_mem1=CSVSTRING(**{ 'default': SMS_COMBINE })
        return self.__field_mem1.getvalue()

    def __setfield_mem1(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_mem1=value
        else:
            self.__field_mem1=CSVSTRING(value,**{ 'default': SMS_COMBINE })

    def __delfield_mem1(self): del self.__field_mem1

    mem1=property(__getfield_mem1, __setfield_mem1, __delfield_mem1, None)

    def __getfield_mem2(self):
        try: self.__field_mem2
        except:
            self.__field_mem2=CSVSTRING(**{ 'default': SMS_OUTBOX })
        return self.__field_mem2.getvalue()

    def __setfield_mem2(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_mem2=value
        else:
            self.__field_mem2=CSVSTRING(value,**{ 'default': SMS_OUTBOX })

    def __delfield_mem2(self): del self.__field_mem2

    mem2=property(__getfield_mem2, __setfield_mem2, __delfield_mem2, None)

    def __getfield_mem3(self):
        try: self.__field_mem3
        except:
            self.__field_mem3=CSVSTRING(**{ 'terminator': None,                  'default': SMS_INBOX })
        return self.__field_mem3.getvalue()

    def __setfield_mem3(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_mem3=value
        else:
            self.__field_mem3=CSVSTRING(value,**{ 'terminator': None,                  'default': SMS_INBOX })

    def __delfield_mem3(self): del self.__field_mem3

    mem3=property(__getfield_mem3, __setfield_mem3, __delfield_mem3, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('mem1', self.__field_mem1, None)
        yield ('mem2', self.__field_mem2, None)
        yield ('mem3', self.__field_mem3, None)




class sms_m_read_resp(BaseProtogenClass):
    __fields=['command', 'has_date', 'date_terminated', 'sms_type', 'sms_addr', 'sms_date', 'sms_date', 'sms_addr']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_m_read_resp,self).__init__(**dict)
        if self.__class__ is sms_m_read_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_m_read_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_m_read_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_has_date
        except:
            self.__field_has_date=BOOL(**{ 'default': True })
        try: self.__field_date_terminated
        except:
            self.__field_date_terminated=BOOL(**{ 'default': False })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_sms_type.writetobuffer(buf)
        if self.has_date:
            self.__field_sms_addr.writetobuffer(buf)
            if self.date_terminated:
                self.__field_sms_date.writetobuffer(buf)
            else:
                self.__field_sms_date.writetobuffer(buf)
        else:
            self.__field_sms_addr.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': ord(' '),                  'default': '+MMGR:' })
        self.__field_command.readfrombuffer(buf)
        self.__field_sms_type=CSVSTRING()
        self.__field_sms_type.readfrombuffer(buf)
        if self.has_date:
            self.__field_sms_addr=CSVSTRING(**{ 'quotechar': None })
            self.__field_sms_addr.readfrombuffer(buf)
            if self.date_terminated:
                self.__field_sms_date=M_SMSDATETIME()
                self.__field_sms_date.readfrombuffer(buf)
            else:
                self.__field_sms_date=M_SMSDATETIME(**{ 'quotechar': None,                              'terminator': None })
                self.__field_sms_date.readfrombuffer(buf)
        else:
            self.__field_sms_addr=CSVSTRING(**{ 'terminator': None,                      'quotechar': None })
            self.__field_sms_addr.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': ord(' '),                  'default': '+MMGR:' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_has_date(self):
        try: self.__field_has_date
        except:
            self.__field_has_date=BOOL(**{ 'default': True })
        return self.__field_has_date.getvalue()

    def __setfield_has_date(self, value):
        if isinstance(value,BOOL):
            self.__field_has_date=value
        else:
            self.__field_has_date=BOOL(value,**{ 'default': True })

    def __delfield_has_date(self): del self.__field_has_date

    has_date=property(__getfield_has_date, __setfield_has_date, __delfield_has_date, None)

    def __getfield_date_terminated(self):
        try: self.__field_date_terminated
        except:
            self.__field_date_terminated=BOOL(**{ 'default': False })
        return self.__field_date_terminated.getvalue()

    def __setfield_date_terminated(self, value):
        if isinstance(value,BOOL):
            self.__field_date_terminated=value
        else:
            self.__field_date_terminated=BOOL(value,**{ 'default': False })

    def __delfield_date_terminated(self): del self.__field_date_terminated

    date_terminated=property(__getfield_date_terminated, __setfield_date_terminated, __delfield_date_terminated, None)

    def __getfield_sms_type(self):
        return self.__field_sms_type.getvalue()

    def __setfield_sms_type(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_sms_type=value
        else:
            self.__field_sms_type=CSVSTRING(value,)

    def __delfield_sms_type(self): del self.__field_sms_type

    sms_type=property(__getfield_sms_type, __setfield_sms_type, __delfield_sms_type, None)

    def __getfield_sms_addr(self):
        return self.__field_sms_addr.getvalue()

    def __setfield_sms_addr(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_sms_addr=value
        else:
            self.__field_sms_addr=CSVSTRING(value,**{ 'quotechar': None })

    def __delfield_sms_addr(self): del self.__field_sms_addr

    sms_addr=property(__getfield_sms_addr, __setfield_sms_addr, __delfield_sms_addr, None)

    def __getfield_sms_date(self):
        return self.__field_sms_date.getvalue()

    def __setfield_sms_date(self, value):
        if isinstance(value,M_SMSDATETIME):
            self.__field_sms_date=value
        else:
            self.__field_sms_date=M_SMSDATETIME(value,)

    def __delfield_sms_date(self): del self.__field_sms_date

    sms_date=property(__getfield_sms_date, __setfield_sms_date, __delfield_sms_date, None)

    def __getfield_sms_date(self):
        return self.__field_sms_date.getvalue()

    def __setfield_sms_date(self, value):
        if isinstance(value,M_SMSDATETIME):
            self.__field_sms_date=value
        else:
            self.__field_sms_date=M_SMSDATETIME(value,**{ 'quotechar': None,                              'terminator': None })

    def __delfield_sms_date(self): del self.__field_sms_date

    sms_date=property(__getfield_sms_date, __setfield_sms_date, __delfield_sms_date, None)

    def __getfield_sms_addr(self):
        return self.__field_sms_addr.getvalue()

    def __setfield_sms_addr(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_sms_addr=value
        else:
            self.__field_sms_addr=CSVSTRING(value,**{ 'terminator': None,                      'quotechar': None })

    def __delfield_sms_addr(self): del self.__field_sms_addr

    sms_addr=property(__getfield_sms_addr, __setfield_sms_addr, __delfield_sms_addr, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('has_date', self.__field_has_date, None)
        yield ('date_terminated', self.__field_date_terminated, None)
        yield ('sms_type', self.__field_sms_type, None)
        if self.has_date:
            yield ('sms_addr', self.__field_sms_addr, None)
            if self.date_terminated:
                yield ('sms_date', self.__field_sms_date, None)
            else:
                yield ('sms_date', self.__field_sms_date, None)
        else:
            yield ('sms_addr', self.__field_sms_addr, None)




class sms_list_req(BaseProtogenClass):
    __fields=['command', 'listtype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_list_req,self).__init__(**dict)
        if self.__class__ is sms_list_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_list_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_list_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None,                  'default': '+MMGL=' })
        self.__field_command.writetobuffer(buf)
        try: self.__field_listtype
        except:
            self.__field_listtype=CSVSTRING(**{ 'terminator': None,                  'default': SMS_HEADER_ONLY })
        self.__field_listtype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None,                  'default': '+MMGL=' })
        self.__field_command.readfrombuffer(buf)
        self.__field_listtype=CSVSTRING(**{ 'terminator': None,                  'default': SMS_HEADER_ONLY })
        self.__field_listtype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': None,                  'default': '+MMGL=' })
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': None,                  'default': '+MMGL=' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_listtype(self):
        try: self.__field_listtype
        except:
            self.__field_listtype=CSVSTRING(**{ 'terminator': None,                  'default': SMS_HEADER_ONLY })
        return self.__field_listtype.getvalue()

    def __setfield_listtype(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_listtype=value
        else:
            self.__field_listtype=CSVSTRING(value,**{ 'terminator': None,                  'default': SMS_HEADER_ONLY })

    def __delfield_listtype(self): del self.__field_listtype

    listtype=property(__getfield_listtype, __setfield_listtype, __delfield_listtype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('listtype', self.__field_listtype, None)




class sms_list_resp(BaseProtogenClass):
    __fields=['command', 'index', 'dontcare']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_list_resp,self).__init__(**dict)
        if self.__class__ is sms_list_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_list_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_list_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self.__field_dontcare.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=CSVSTRING(**{ 'quotechar': None,                  'terminator': ord(' '),                  'default': '+MMGL:' })
        self.__field_command.readfrombuffer(buf)
        self.__field_index=CSVINT()
        self.__field_index.readfrombuffer(buf)
        self.__field_dontcare=DATA()
        self.__field_dontcare.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,CSVSTRING):
            self.__field_command=value
        else:
            self.__field_command=CSVSTRING(value,**{ 'quotechar': None,                  'terminator': ord(' '),                  'default': '+MMGL:' })

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,CSVINT):
            self.__field_index=value
        else:
            self.__field_index=CSVINT(value,)

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_dontcare(self):
        return self.__field_dontcare.getvalue()

    def __setfield_dontcare(self, value):
        if isinstance(value,DATA):
            self.__field_dontcare=value
        else:
            self.__field_dontcare=DATA(value,)

    def __delfield_dontcare(self): del self.__field_dontcare

    dontcare=property(__getfield_dontcare, __setfield_dontcare, __delfield_dontcare, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('index', self.__field_index, None)
        yield ('dontcare', self.__field_dontcare, None)




