var environment = arguments[0];
var dbname = arguments[1];

var env_array = environment.split(':');
var port = env_array[0];
var consumer_key = env_array[1];
var consumer_secret = env_array[2];
var token = env_array[3];
var token_secret = env_array[4];

if (XMLHttpRequest === undefined) {
    var XMLHttpRequest = function () {
        return Components.classes["@mozilla.org/xmlextras/xmlhttprequest;1"]
            .getService(Components.interfaces.nsIXMLHttpRequest);
    };
}

print("Assigning environment variables to CouchDB");
CouchDB.port = port;
CouchDB.accessor = {
    consumerSecret: consumer_secret,
    tokenSecret: token_secret
};
CouchDB.message = {
    parameters: {
        oauth_callback: "None",
        oauth_consumer_key: consumer_key,
        oauth_signature_method: "PLAINTEXT",
        oauth_token: token,
        oauth_verifier: "None",
        oauth_version: "1.0"
    }
};

print("Creating a CouchDB instance for " + dbname);
var couch = new CouchDB(dbname);
try {
    couch.createDb();
} catch (e) {
    if (e.error == 'file_exists') {
        print("Database already exists. We're okay.");
    } else {
        print("Error when creating database in pushBookmarks: " + JSON.stringify(e));
    }
}

var views = [{ id: "_design/all_bookmarks",
               map: "function(doc) { " +
               "var scheme = doc.uri.split(':',1)[0]; " +
               "var uri; " +
               "if (scheme == 'http' || scheme == 'https') {" +
               "uri = doc.uri.split('/')[2];" +
               "if (uri.length < 30) {" +
               " uri += '/' + " +
               "doc.uri.split('/',4)[3].substr(0,30-uri.length) + '...';" +
               "}" +
               "} else {" +
               "uri = scheme + ' URL';" +
               "}" +
               "if (!doc.deleted) {" +
               "emit(doc.title, uri);" +
               "}" +
               "}" },
             { id: "_design/deleted_bookmarks",
               map: "function(doc) { if (doc.deleted) { emit (doc.title, doc.uri); } }" },
             { id: "_design/default",
               map: "function(doc) { var scheme = doc.uri.split(':',1)[0]; var uri; if (scheme == 'http' || scheme == 'https') {uri = doc.uri.split('/')[2];if (uri.length < 30) { uri += '/' + doc.uri.split('/',4)[3].substr(0,30-uri.length) + '...';}} else {uri = scheme + ' URL';}if ((!doc.deleted) && (doc.application_annotations.Firefox.profile == 'default')) {emit(doc.title, uri);}}" }];
for (var i = 0; i < views.length; i++) {
    var view_info = views[i];
    var dirty = false;
    try {
        var new_doc;
        var current_doc;
        try {
            print("Looking up " + view_info.id);
            current_doc = couch.open(view_info.id);
        } catch(e) {
            print("Problem fetching " + view_info.id + " because of: " + JSON.stringify(e));
            current_doc = null;
        }
        if (current_doc !== null) {
            print("We've got an existing doc");
            new_doc = current_doc;
            var old_map = current_doc.views.display.map;
            if (old_map != view_info.map) { // Ours is definitive
                print("Existing map is different, clobbering.");
                new_doc.views.display.map = view_info.map;
                dirty = true;
            }
        } else {
            print("Doc doesn't exist, making it from scratch");
            new_doc = {
                _id: view_info.id,
                views: {
                    display: {
                        map: view_info.map
                    }
                }
            };
            dirty = true;
        }
        if (dirty) {
            print("Something changed with the doc, we're saving it back");
            try {
                couch.save(new_doc);
                print("Successfully save view " + new_doc._id);
            } catch(e) {
                print("Problem saving view: " + JSON.stringify(e));
            }
        }
    } catch(e) {
        // some kind of error fetching the existing design doc
        print("Problem checking for view: " + JSON.stringify(e));
    }
}

try {
    var current_profile = 'default';
    var rows = couch.query(function (doc) {
                               if (doc.record_type == "http://www.freedesktop.org/wiki/Specifications/desktopcouch/bookmark" &&
                                   doc.application_annotations &&
                                   doc.application_annotations.Firefox &&
                                   doc.application_annotations.Firefox.profile &&
                                   doc.application_annotations.Firefox.profile == current_profile) {
                                   emit(doc._id,doc);
                               }
                           });
} catch(e) {
    Bindwood.writeError("Problem fetching all bookmarks from Couch: ", e);
}
for (var i = 0; i < rows.rows.length; i++) {
    var recordid = rows.rows[i].id;
    print("Pulling record: " + recordid);
}

