#include <kozo.h>

enum {
    FIELD_1,
    FIELD_2,
    FIELD_3,
    N_FIELDS
};

int fields[N_FIELDS] = {0, };
char *fieldnames[N_FIELDS] = {
    "field 1", "field 2", "field 3"
};

KozoDB *db;

int
main (int    argc,
      char **argv)
{
    GError *error = NULL;
    GSList *l = NULL;
    int i;

    g_thread_init (NULL);
    g_type_init ();

    kozo_init ();

    db = kozo_db_get ("kozo-crash", 1, &error);
    if (!db) {
        g_printerr ("Could not get music database: %s\n", error->message);
        g_error_free (error);
        return 0;
    }

    for (i = 0; i < N_FIELDS; i++) {
        fields[i] = kozo_db_register_field (db, fieldnames[i], &error);
        if (fields[i] < 0) {
            g_printerr ("Could not register field %s: %s\n", fieldnames[i],
                        error->message);
        }
    }

    l = g_slist_append (l, kozo_field_new_string (FIELD_1, "test1"));
    l = g_slist_append (l, kozo_field_new_string (FIELD_2, "test2"));
    l = g_slist_append (l, kozo_field_new_string (FIELD_3, "test3"));

    if (!kozo_db_add (db, "test-key", l, &error)) {
        g_print ("Error adding entry: %s\n", error->message);
        g_error_free (error);
        return;
    }

    return 0;
}
