/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ITEM_VIDEO_H__
#define __BKL_ITEM_VIDEO_H__

#include <bickley/bkl-item-extended.h>

G_BEGIN_DECLS

#define BKL_TYPE_ITEM_VIDEO                                             \
   (bkl_item_video_get_type())
#define BKL_ITEM_VIDEO(obj)                                             \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_ITEM_VIDEO,                    \
                                BklItemVideo))
#define BKL_ITEM_VIDEO_CLASS(klass)                                     \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_ITEM_VIDEO,                       \
                             BklItemVideoClass))
#define IS_BKL_ITEM_VIDEO(obj)                                          \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_ITEM_VIDEO))
#define IS_BKL_ITEM_VIDEO_CLASS(klass)                                  \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_ITEM_VIDEO))
#define BKL_ITEM_VIDEO_GET_CLASS(obj)                                   \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_ITEM_VIDEO,                     \
                               BklItemVideoClass))

typedef struct _BklItemVideoPrivate BklItemVideoPrivate;
typedef struct _BklItemVideo      BklItemVideo;
typedef struct _BklItemVideoClass BklItemVideoClass;

struct _BklItemVideo
{
    BklItemExtended parent;

    BklItemVideoPrivate *priv;
};

struct _BklItemVideoClass
{
    BklItemExtendedClass parent_class;
};

GType bkl_item_video_get_type (void) G_GNUC_CONST;

BklItemVideo *bkl_item_video_new (void);
BklItemVideo *bkl_item_video_new_from_field (KozoField *field);

GSList *bkl_item_video_get_fields (BklItemVideo *item);

void bkl_item_video_set_title (BklItemVideo *video,
                               const char   *title);
const char *bkl_item_video_get_title (BklItemVideo *video);

void bkl_item_video_set_director (BklItemVideo *video,
                                  const char   *director);
const char *bkl_item_video_get_director (BklItemVideo *video);

void bkl_item_video_set_series_name (BklItemVideo *video,
                                     const char   *series_name);
const char *bkl_item_video_get_series_name (BklItemVideo *video);

void bkl_item_video_set_season (BklItemVideo *video,
                                guint         season);
guint bkl_item_video_get_season (BklItemVideo *video);

void bkl_item_video_set_episode (BklItemVideo *video,
                                 guint         episode);
guint bkl_item_video_get_episode (BklItemVideo *video);

void bkl_item_video_set_year (BklItemVideo *video,
                              guint         year);
guint bkl_item_video_get_year (BklItemVideo *video);

void bkl_item_video_set_duration (BklItemVideo *video,
                                  guint         duration);
guint bkl_item_video_get_duration (BklItemVideo *video);

void bkl_item_video_set_width (BklItemVideo *video,
                               guint         width);
guint bkl_item_video_get_width (BklItemVideo *video);

void bkl_item_video_set_height (BklItemVideo *video,
                                guint         height);
guint bkl_item_video_get_height (BklItemVideo *video);
void bkl_item_video_set_series_image (BklItemVideo *video,
                                      const char   *series_image);
const char *bkl_item_video_get_series_image (BklItemVideo *video);
void bkl_item_video_set_disc (BklItemVideo *video,
                              guint         disc);
guint bkl_item_video_get_disc (BklItemVideo *video);

char *bkl_item_video_to_string (BklItemVideo *video);

G_END_DECLS

#endif /* __BKL_ITEM_VIDEO_H__ */
