#!/usr/bin/env python
#file test_statistics.py
"""Test lyx-remote function from the LyX.lyxserver module

Revision History:

2005-02-23 G. Milde first version with the unittest framework
"""

import os, time
from unittest import TestCase, main 

from LyX.lyxclient import *
from LyX import lyxclient, lyxserver

lyxserver.logger.setLevel(logging.DEBUG)
logger.setLevel(logging.DEBUG) 

# an absolute and a relative filename
filenames = [os.path.join(os.path.dirname(__file__), "test.lyx"),
             "test2.lyx"]


class LyXClientTests(TestCase):
    """Test LyXClient class in case there is no running LyX"""
    def setUp(self):
        self.client = LyXClient()  # lyxclient object with defaults
        # self.client.write_lfun("file-open", filenames[0])
    def tearDown(self):
        # self.client.write_lfun("buffer-close")
        del(self.client)
    def test__init__(self):
        """LyXClient initialization must not start a LyX process"""
        ps_grep = os.system('ps -u "$USER" | grep -w %s'%LYXCMD.split()[0])
        # self.failIfEqual(0, ps_grep)
        

class lyx_remoteTests(TestCase):
    """Test function lyx_remote() in lyxclient"""
    #
    def test_lyx_remote(self):
        """lyxserver.lyx_remote should open given files"""
        # test without running LyX
        client = lyx_remote(LYXCMD, filenames[:])
        time.sleep(0.5) # give lyx some response time (adjust to your system)
        for i in range(2):
            name = client("server-get-name")
            self.assert_(os.path.samefile(name, filenames[0])
                         or os.path.samefile(name, filenames[1]))
            client("buffer-close")
        client.write_lfun("lyx-quit")
    # # 
    # def test_lyx_remote_with_args(self):
    #     """lyx_remote(options=["-help"]) should display help and exit with 0"""
    #     pid = os.system('lyx-remote -help')
    #     (pid, rv) = os.waitpid(pid, 0)
    #     self.assertEqual(0, rv)



if __name__ == '__main__':    #run tests if called from command-line
    main()
