/*
 * Decompiled with CFR 0.152.
 */
package jolon.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Stack;
import jolon.xml.CDATA;
import jolon.xml.XMLAttribute;
import jolon.xml.XMLCompatible;
import jolon.xml.XMLObject;

public class XMLParser {
    LineNumberReader inputStream;
    Stack tagStack;
    char currentChar;
    boolean EOF = false;

    public static XMLObject parse(String fileName) throws IOException {
        XMLParser parser = new XMLParser();
        return parser.parse(new File(fileName));
    }

    public static XMLObject parseFile(File file) throws IOException {
        XMLParser parser = new XMLParser();
        return parser.parse(file);
    }

    public XMLParser(Reader inputStream) {
        this.inputStream = new LineNumberReader(inputStream);
    }

    public XMLParser() {
    }

    public int getLineNumber() {
        int lineNumber = -1;
        if (this.inputStream != null) {
            lineNumber = this.inputStream.getLineNumber();
        }
        return lineNumber;
    }

    public XMLObject parse(File file) throws IOException {
        return this.parse(file, null);
    }

    public XMLObject parse(File file, Hashtable knownTags) throws IOException {
        String fileName = file.getName();
        XMLObject xml = null;
        if (fileName.endsWith(".wbxml")) {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            xml = this.parseWBXML(inputStream);
            ((InputStream)inputStream).close();
        } else {
            this.inputStream = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            xml = this.parse(knownTags);
        }
        return xml;
    }

    public XMLObject parse() {
        return this.parse((Hashtable)null);
    }

    public XMLObject parse(Hashtable knownTags) {
        this.tagStack = new Stack();
        XMLCompatible parent = new XMLObject("root");
        this.currentChar = (char)32;
        this.EOF = false;
        while (!this.EOF) {
            String currentTag = this.readTag(parent);
            if (currentTag.length() <= 0 || this.isXMLTag(currentTag)) continue;
            if (this.isEndTag(currentTag)) {
                String tagString = parent.getTag();
                if (currentTag.regionMatches(1, tagString, 0, tagString.length())) {
                    parent = (XMLCompatible)this.tagStack.pop();
                    continue;
                }
                System.out.println("Error: Line: " + (this.inputStream.getLineNumber() + 1) + ": End tag <" + currentTag + "> does not have a matching start tag (found <" + tagString + "> instead), ignoring.");
                continue;
            }
            if (!currentTag.endsWith("/")) {
                this.tagStack.push(parent);
            }
            XMLCompatible tempObject = this.createXMLObject(currentTag);
            if (knownTags != null && knownTags.containsKey(tempObject.getTag())) {
                try {
                    XMLCompatible realObject = (XMLCompatible)((Class)knownTags.get(tempObject.getTag())).newInstance();
                    realObject.fromXML((XMLObject)tempObject);
                    tempObject = realObject;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            tempObject = parent.addXMLChild(tempObject);
            if (currentTag.endsWith("/")) continue;
            parent = tempObject;
        }
        return parent;
    }

    public String readTag(XMLCompatible parent) {
        StringBuffer tag = new StringBuffer();
        try {
            boolean inquote;
            char currentChar;
            int current = 0;
            String cdata = "";
            do {
                current = this.inputStream.read();
                currentChar = (char)current;
                if (current == -1 || currentChar == '<') continue;
                cdata = cdata + currentChar;
            } while (current != -1 && currentChar != '<');
            if (!cdata.trim().equals("")) {
                parent.addXMLChild(new CDATA(cdata));
            }
            boolean bl = inquote = currentChar == '\"';
            while (current != -1 && (currentChar != '>' || inquote)) {
                current = this.inputStream.read();
                currentChar = (char)current;
                if (currentChar == '\"') {
                    boolean bl2 = inquote = !inquote;
                }
                if (currentChar == '>' && !inquote || current == -1) continue;
                tag.append(currentChar);
            }
            if (current == -1) {
                this.EOF = true;
            }
        }
        catch (IOException e) {
            System.out.println("An IO error has occurred in XMLParser.readTag().");
        }
        return tag.toString();
    }

    protected XMLObject createXMLObject(String tag) {
        int index = this.findEndOfTagName(tag);
        String tagName = tag.substring(0, index);
        XMLObject xmlObject = new XMLObject(tagName);
        this.getAttributes(xmlObject, tag, index);
        return xmlObject;
    }

    protected int findEndOfTagName(String tag) {
        int length;
        int index = length = tag.length();
        for (int currentIndex = 0; currentIndex < length && index == length; ++currentIndex) {
            char currentChar = tag.charAt(currentIndex);
            if (!this.isWhiteSpace(currentChar) && currentChar != '>' && currentChar != '/') continue;
            index = currentIndex;
        }
        return index;
    }

    public boolean isWhiteSpace(char inChar) {
        return inChar == ' ' || inChar == '\t' || inChar == '\n' || inChar == '\r';
    }

    protected void getAttributes(XMLObject xmlObject, String tag, int index) {
        do {
            XMLAttribute xmlAttribute;
            if ((index = this.getAttribute(tag, index + 1, xmlAttribute = new XMLAttribute())) == -1) continue;
            xmlObject.add(xmlAttribute);
        } while (index != -1);
    }

    protected int getAttribute(String tag, int index, XMLAttribute xmlAttribute) {
        int currentIndex = index;
        int currentChar = 47;
        int length = tag.length();
        boolean whitespace = true;
        if (index >= length) {
            return -1;
        }
        currentChar = tag.charAt(index);
        if (index < length && currentChar != 47 && currentChar != 62) {
            int nameIndex = tag.indexOf(61, index);
            if (nameIndex == -1) {
                return -1;
            }
            xmlAttribute.setName(tag.substring(index, nameIndex).trim());
            int valueStart = tag.indexOf(34, nameIndex);
            if (valueStart == -1 || valueStart + 1 >= length) {
                return -1;
            }
            int valueEnd = tag.indexOf(34, valueStart + 1);
            if (valueEnd == -1) {
                return -1;
            }
            xmlAttribute.setData(tag.substring(valueStart + 1, valueEnd));
            index = valueEnd;
        } else {
            index = -1;
        }
        return index;
    }

    public boolean isXMLTag(String inTag) {
        return inTag.startsWith("?") && inTag.endsWith("?");
    }

    public boolean isEndTag(String tag) {
        return tag.charAt(0) == '/';
    }

    public XMLObject parseWBXML(InputStream inputStream) throws IOException {
        XMLObject xml = new XMLObject("root");
        Hashtable stringTable = this.readStart(inputStream);
        this.parseWBXML(xml, inputStream, stringTable);
        return xml;
    }

    public boolean parseWBXML(XMLObject parent, InputStream inputStream, Hashtable stringTable) throws IOException {
        int tokenCode = inputStream.read();
        if (tokenCode != 1) {
            String tag = this.readIndexedString(inputStream, stringTable);
            XMLObject xml = new XMLObject(tag);
            if ((tokenCode & 0x80) != 0) {
                int attributeCode = inputStream.read();
                do {
                    String attributeName = null;
                    if (attributeCode != 4) {
                        throw new IOException("attributeName is null");
                    }
                    attributeName = this.readIndexedString(inputStream, stringTable);
                    attributeCode = inputStream.read();
                    String data = null;
                    if (attributeCode == 83) {
                        data = this.readIndexedString(inputStream, stringTable);
                        xml.addAttribute(attributeName, data);
                        continue;
                    }
                    if (attributeCode != 81) continue;
                    int value = this.readMultibyteInteger(inputStream);
                    xml.addAttribute(attributeName, Float.intBitsToFloat(value));
                } while ((attributeCode = inputStream.read()) != 1);
            }
            if ((tokenCode & 0x40) != 0) {
                boolean i = false;
                while (this.parseWBXML(xml, inputStream, stringTable)) {
                }
            }
            parent.add(xml);
            return true;
        }
        return false;
    }

    public String readIndexedString(InputStream inputStream, Hashtable stringTable) throws IOException {
        int index = this.readMultibyteInteger(inputStream);
        return (String)stringTable.get(new Integer(index));
    }

    public Hashtable readStart(InputStream inputStream) throws IOException {
        System.out.println("readStart");
        this.readVersion(inputStream);
        this.readPublicID(inputStream);
        this.readCharSet(inputStream);
        System.out.println("readStringTable");
        return this.readStringTable(inputStream);
    }

    public void readVersion(InputStream inputStream) throws IOException {
        inputStream.read();
    }

    public void readPublicID(InputStream inputStream) throws IOException {
        inputStream.read();
    }

    public void readCharSet(InputStream inputStream) throws IOException {
        inputStream.read();
    }

    public Hashtable readStringTable(InputStream inputStream) throws IOException {
        String string;
        Hashtable<Integer, String> stringTable = new Hashtable<Integer, String>();
        int length = this.readMultibyteInteger(inputStream);
        System.out.println("length = " + length);
        for (int offset = 0; offset < length; offset += string.length() + 1) {
            string = this.readNullTerminatedString(inputStream);
            stringTable.put(new Integer(offset), string);
        }
        return stringTable;
    }

    public int readMultibyteInteger(InputStream inputStream) throws IOException {
        int currentByte = inputStream.read();
        if (currentByte == -1) {
            throw new IOException("End of file");
        }
        int value = currentByte & 0x7F;
        while ((currentByte & 0x80) != 0) {
            currentByte = inputStream.read();
            if (currentByte == -1) {
                throw new IOException("End of file");
            }
            value <<= 7;
            value |= currentByte & 0x7F;
        }
        return value;
    }

    public String readNullTerminatedString(InputStream inputStream) throws IOException {
        String result = "";
        int currentByte = inputStream.read();
        while (currentByte != 0) {
            result = result + (char)currentByte;
            currentByte = inputStream.read();
        }
        return result;
    }
}

