/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SHA1.h"
#include <boost/test/auto_unit_test.hpp>
#include <string>
#include <stdlib.h>
#include <stddef.h>

static std::string sha1(std::string const& str)
{
	SHA1 sha1;
	sha1.feed((unsigned char const*)str.c_str(), str.size());
	SHA1::Value value;
	sha1.finalize(value);
	return value.hexEncode();
}

BOOST_AUTO_UNIT_TEST(test)
{
	srand(0);
	BOOST_CHECK(sha1("") == "da39a3ee5e6b4b0d3255bfef95601890afd80709");
	BOOST_CHECK(sha1("abc") == "a9993e364706816aba3e25717850c26c9cd0d89d");
	BOOST_CHECK(sha1("The quick brown fox jumps over the lazy cog") == "de9f2c7fd25e1b3afad3e85a0bd17d9b100db4b3");
	
	SHA1 dg;
	for (int i = 0; i < 2; ++i, dg.reset()) {
		size_t todo = 1000000;
		while (todo) {
			size_t const chunk_len = std::min<size_t>((rand() % 10000) + 1, todo);
			std::string const chunk(chunk_len, 'a');
			dg.feed((unsigned char const*)chunk.c_str(), chunk.size());
			todo -= chunk_len;
		}
		SHA1::Value value;
		dg.finalize(value);
		BOOST_CHECK(value.hexEncode() == "34aa973cd4c4daa4f61eeb2bdbad27316534016f");
	}
}
