#!/bin/bash

LIBSIGC_VERSION="2.0.17"
LIBSIGC_URL="ftp://ftp.gnome.org/pub/gnome/sources/libsigc++/2.0/libsigc++-$LIBSIGC_VERSION.tar.bz2"

ACE_VERSION="5.5.1"
ACE_URL="http://deuce.doc.wustl.edu/old_distribution/ACE-$ACE_VERSION.tar.bz2"

#unpack 'filename'
function unpack
{
  fname="$1"
  case "$fname" in
    *.gz)
      flag="-z"
      ;;
    *.bz2)
      flag="-j"
      ;;
    *)
      echo "Don't know how to unpack $fname"
      return 1
      ;;
  esac
  echo "Unpacking $fname"
  tar "$flag" -xf "$fname"
}

# fetch 'URL'
function fetch
{
  url="$1"
  if which wget > /dev/null; then
    wget "$url"
  elif which curl > /dev/null; then
    curl -O --retry 5 "$url"
  else
    echo "Neither wget nor curl is installed."
    return 1
  fi
}

# fetch_and_unpack 'URL'
function fetch_and_unpack
{
  url="$1"
  fname=`basename $url`
  if [ -f "$fname" ]; then
    unpack "$fname"
  else
    echo "Fetching $url"
    if fetch "$url"; then
      unpack "$fname"
    else
      rm -f "$fname"
      return 1
    fi
  fi
}

# remove_subdirs 'file' 'subdir1|subdir2|...'
function remove_subdirs
{
  file="$1"
  pattern="$2"
  script='
  BEGIN { continuation = 0; }
  $1 == "SUBDIRS" || continuation {
    continuation = /\\$/;
    for (i = 1; i <= NF; i++) {
      if ($i ~ "^('$pattern')$") {
        $i = "";
      }
    }
  }
  { print }
  '
  awk "$script" "$file" > "$file.temp"
  mv -f "$file.temp" "$file"
}


(
mkdir -p build || exit 1
cd build || exit 1

rm -rf "libsigc++-$LIBSIGC_VERSION" || exit 1
fetch_and_unpack "$LIBSIGC_URL" || exit 1

rm -rf "ACE_wrappers" || exit 1
fetch_and_unpack "$ACE_URL" || exit 1

rm -rf ./install-prefix || exit 1
mkdir ./install-prefix || exit 1
PREFIX=`readlink -f ./install-prefix`
export LDFLAGS="-arch i386 -arch ppc"
export CFLAGS="-arch i386 -arch ppc -isysroot /Developer/SDKs/MacOSX10.4u.sdk -Wall -Os -fvisibility=hidden"
export CXXFLAGS="$CFLAGS -fvisibility-inlines-hidden"

(
cd "libsigc++-$LIBSIGC_VERSION" || exit 1
remove_subdirs "Makefile.in" "docs|tests|examples" || exit 1
./configure --prefix="$PREFIX" --enable-static --disable-shared  \
--disable-dependency-tracking || exit 1
make all install || exit 1
cd .. || exit 1
rm -rf "libsigc++-$LIBSIGC_VERSION"
) || exit 1

(
cd "ACE_wrappers" || exit 1
export ACE_ROOT=`pwd`
echo "Configuring ACE"

cat > include/makeinclude/platform_macros.GNU <<END
static_libs_only = 1
debug = 0
optimize = 0
ace_other = 0
ace_codecs = 0
ace_svcconf = 0
ace_uuid = 0
ace_filecache = 0
acexml = 0

include \$(ACE_ROOT)/include/makeinclude/platform_macosx_panther.GNU
END

cat > ace/config.h <<END
#define ACE_NLOGGING
#define ACE_LACKS_ACE_SVCCONF
#define ACE_HAS_SOCKLEN_T
#include "config-macosx-panther.h"
#undef ACE_LACKS_SUSECONDS_T
END

cd ace || exit 1
make || exit 1
mkdir -p "$PREFIX/include/ace" || exit 1
mkdir -p "$PREFIX/lib" || exit 1
cp -frp os_include "$PREFIX/include/ace/" || exit 1
cp -fp *.h *.inl *.cpp "$PREFIX/include/ace/" || exit 1
cp -fp libACE.a "$PREFIX/lib/" || exit 1
cd ../.. || exit 1
rm -rf "ACE_wrappers"
) || exit 1

)
