/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef WXGUI_URLSFILE_H_
#define WXGUI_URLSFILE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include <ace/config-lite.h>
#include <wx/filename.h>
#include <wx/string.h>
#include <string>

class UrlPatterns;
class FileVersion;

namespace wxGUI
{

/**
 * \brief Provides high-level load-apply-save operations on "urls" and "urls.local" files.
 */
class UrlsFile
{
	DECLARE_NON_COPYABLE(UrlsFile) // can be easily made copyable if necessary
public:
	enum Which { URLS, URLS_LOCAL };
	
	UrlsFile(Which which, wxFileName const& file_path);
	
	~UrlsFile();
	
	/**
	 * \brief Loads file from disk, parses and applies it.
	 *
	 * Returns true on success and false on failure.  Note that success
	 * doesn't imply the absence of errors or warnings.  This function
	 * ignores parsing errors.  Progress and errors / warnings will be
	 * reported through OperationLog.
	 */
	bool loadAndForceApply();
	
	/**
	 * \brief Parses, applies and saves the new file.
	 *
	 * Returns true on success and false on failure.  Note that success
	 * doesn't imply the absence of errors or warnings.  Only serious
	 * errors will cause failure.  Progress and errors / warnings will be
	 * reported through OperationLog.  In case of a failure, it tries
	 * to rollback changes previously made.  Unfortunately, in some cases
	 * in can't be done.
	 */
	bool applyAndSave(std::string const& text);
	
	/**
	 * \brief Reads file's modification time.
	 *
	 * On failure, returns FileVersion::undefined().
	 */
	FileVersion readFileVersion() const;
private:
	wxString getFileName() const;
	
	void apply(UrlPatterns& new_patterns, FileVersion const& version);
	
	wxFileName m_filePath;
	Which m_which;
};

} // namespace wxGUI

#endif
