/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILTERCONFIGWINDOW_H_
#define FILTERCONFIGWINDOW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractLogView.h"
#include <ace/config-lite.h>
#include <wx/frame.h>
#include <memory>

class FilterGroupTag;
class wxMenuBar;
class wxCommandEvent;
class wxActivateEvent;
class wxCloseEvent;
class wxTreeEvent;
class wxTreeItemId;
class wxString;

namespace wxGUI
{

class LogWidget;

class FilterConfigWindow : public wxFrame, private AbstractLogView
{
public:
	FilterConfigWindow();
	
	virtual ~FilterConfigWindow();
	
	static void show();
	
	static bool isFilterGroupBeingEdited(FilterGroupTag const& group_tag);
private:
	struct EditState;
	class FilterTree;
	class TreeItemData;
	class FileNode;
	class FilterNode;
	class FilterPanel;
	friend class FilterConfigWindow::FilterTree;
	friend class FilterConfigWindow::FilterPanel;
	
	enum Operation { CREATING, EDITING };
	
	std::auto_ptr<wxMenuBar> createMenuBar();
	
	void onWindowActivate(wxActivateEvent& evt);
	
	void onWindowClose(wxCloseEvent& evt);
	
	bool prepareForWindowDestruction();
	
	void onClearLog(wxCommandEvent& evt);
	
	void onNewFile(wxCommandEvent& evt);
	
	void onReload(wxCommandEvent& evt);
	
	void onSelChanged(wxTreeEvent& evt);
	
	void onItemUnselected(wxTreeItemId const& item);
	
	void onItemSelected(wxTreeItemId const& item);
	
	void onReset(wxCommandEvent& evt);
	
	void onSave(wxCommandEvent& evt);
	
	void onFileDelete(wxCommandEvent& evt);
	
	void onFilterDelete(wxCommandEvent& evt);
	
	void onFilterCreated(wxTreeItemId const& item, FilterNode& node);
	
	void markCurrentFilterAsModified();
	
	static FilterConfigWindow* m_spInstance;
	FilterTree* m_pFilterTree;
	FilterPanel* m_pFilterPanel;
	LogWidget* m_pLogWidget;
	
	DECLARE_EVENT_TABLE()
};

} // namespace wxGUI

#endif
