/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AboutDialog.h"
#include "Application.h"
#include <ace/config-lite.h>
#include <wx/string.h>
#include <wx/filename.h>
#include <wx/sizer.h>
#include <wx/event.h>
#include <wx/button.h>
#include <wx/bmpbuttn.h>
#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/stattext.h>
#include <wx/hyperlink.h>

namespace wxGUI
{

BEGIN_EVENT_TABLE(AboutDialog, wxDialog)
	EVT_CLOSE(onWindowClose)
END_EVENT_TABLE()

AboutDialog* AboutDialog::m_spInstance = 0;

AboutDialog::AboutDialog()
:	wxDialog(wxGetApp().GetTopWindow(), -1, _T("About"), wxDefaultPosition)
{
	wxBoxSizer *topsizer = new wxBoxSizer(wxVERTICAL);
	SetSizer(topsizer);
	
	wxFileName logo_fname(wxGetApp().getResourcesDir());
	logo_fname.SetName(_T("logo.png"));
	wxBitmap logo_bitmap;
	logo_bitmap.LoadFile(logo_fname.GetFullPath(), wxBITMAP_TYPE_PNG);
	wxBitmapButton* logo = new wxBitmapButton(
		this, -1, logo_bitmap, wxDefaultPosition, wxDefaultSize, 0
	);
	topsizer->Add(logo, 0, wxALIGN_CENTER|wxALL, 5);
	logo->Disable();

	wxStaticText* caption = new wxStaticText(
		this, -1, _T("BFilter ") _T(BFILTER_VERSION)
	);
	topsizer->Add(caption, 0, wxALIGN_CENTER);
	
	topsizer->AddSpacer(5);

	wxFont font(caption->GetFont());
	font.SetPointSize(17);
	caption->SetFont(font);

	wxStaticText* subcaption = new wxStaticText(
		this, -1, _T("A web proxy aimed at removing banner ads.")
	);
	topsizer->Add(subcaption, 0, wxALIGN_CENTER|wxLEFT|wxRIGHT, 5);
	
	topsizer->AddSpacer(5);
	
	font = subcaption->GetFont();
	font.SetPointSize(12);
	subcaption->SetFont(font);

	wxString const url(_T("http://bfilter.sourceforge.net"));
	wxHyperlinkCtrl* link = new wxHyperlinkCtrl(this, -1, url, url);
	topsizer->Add(link, 0, wxALIGN_CENTER);
	
	font = link->GetFont();
	font.SetPointSize(10);
	link->SetFont(font);
	
	topsizer->AddSpacer(10);

	wxButton* close_btn = new wxButton(this, wxID_OK, _T("Close"));
	topsizer->Add(close_btn, 0, wxALIGN_CENTER);

	topsizer->AddSpacer(10);

	topsizer->SetSizeHints(this);
}

AboutDialog::~AboutDialog()
{
}

void
AboutDialog::show()
{
	if (!m_spInstance) {
		m_spInstance = new AboutDialog;
		m_spInstance->Show();
	} else {
		m_spInstance->Show();
		m_spInstance->Raise();
	}
}

void
AboutDialog::onWindowClose(wxCloseEvent& evt)
{
	if (m_spInstance == this) {
		m_spInstance = 0;
	}
	Destroy();
}

} // namespace wxGUI
