/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GTKGUI_STYLEDTEXT_H_
#define GTKGUI_STYLEDTEXT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glibmm/ustring.h>
#include <glibmm/refptr.h>
#include <gtkmm/texttag.h>

namespace GtkGUI
{

class StyledText
{
public:
	// Member-wise copying is OK.

	StyledText(Glib::ustring const& text,
		Glib::RefPtr<Gtk::TextTag> const& style);

	Glib::ustring& text() { return m_text; }

	Glib::ustring const& text() const { return m_text; }

	Glib::RefPtr<Gtk::TextTag> const& style() const { return m_ptrStyle; }
private:
	Glib::ustring m_text;
	Glib::RefPtr<Gtk::TextTag> m_ptrStyle;
};


inline
StyledText::StyledText(Glib::ustring const& text,
	Glib::RefPtr<Gtk::TextTag> const& style)
:	m_text(text),
	m_ptrStyle(style)
{
}

} // namespace GtkGUI

#endif
