/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Link.h"
#include "ArraySize.h"
#include <gtkmm/label.h>
#include <gdkmm/color.h>
#include <gdkmm/cursor.h>
#include <gdkmm/window.h>
#include <glibmm/markup.h>

namespace GtkGUI
{

Link::Link(Glib::ustring const& text)
:	m_pLabel(0)
{
	add_events(Gdk::BUTTON_RELEASE_MASK);
	
#if 0
	m_pLabel = manage(new Gtk::Label(text));
	add(*m_pLabel);
	
	// This doesn't work with gtk-qt engine.
	Gdk::Color const color("#0000ee");
	m_pLabel->modify_fg(Gtk::STATE_NORMAL, color);
#else
	Glib::ustring const markup(
		"<span color=\"#0000ee\">"
		+Glib::Markup::escape_text(text)
		+"</span>"
	);
	m_pLabel = manage(new Gtk::Label(markup));
	add(*m_pLabel);
	m_pLabel->set_use_markup(true);
#endif
	
	m_pLabel->show();
}

Link::~Link()
{
}

void
Link::on_map()
{
	Gtk::EventBox::on_map();
	get_window()->set_cursor(Gdk::Cursor(Gdk::HAND2));
}

bool
Link::on_button_release_event(GdkEventButton* evt)
{
	Gtk::EventBox::on_button_release_event(evt);
	m_signalClicked.emit();
	return false; // propagate event further
}

} // namespace GtkGUI
