/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ForwardingConfigFile.h"
#include "Conf.h"
#include "ConfigErrorHandler.h"
#include "OperationLog.h"
#include "Log.h"
#include "FileOps.h"
#include "GlobalState.h"
#include "TwoPhaseLogRecord.h"
#include <glibmm/miscutils.h>
#include <sstream>
#include <stddef.h>

namespace GtkGUI
{

ForwardingConfigFile::ForwardingConfigFile(std::string const& file_path)
:	m_filePath(file_path)
{
}

ForwardingConfigFile::~ForwardingConfigFile()
{
}

bool
ForwardingConfigFile::loadAndApply(ObsoleteForwardingInfo const& fallback)
{
	Log* log = OperationLog::instance();
	TwoPhaseLogRecord log_record(
		log,
		StyledText("Loading forwarding configuration ... ", log->getDefaultStyle()),
		StyledText("done", log->getSuccessStyle())
	);
	
	if (!Glib::file_test(m_filePath, Glib::FILE_TEST_EXISTS)) {
		applyFallback(fallback);
		return true;
	}
	
	std::string text;
	if (!FileOps::readFile(m_filePath, text)) {
		return false;
	}
	
	std::istringstream strm(text);
	ConfigErrorHandler eh("forwarding.xml");
	
	Forwarding::Config config;
	if (!config.fromStream(strm, eh)) {
		return false;
	}
	
	if (config.options().empty()) {
		applyFallback(fallback);
		return true;
	}
	
	Forwarding::Resolver resolver(config);
	GlobalState::WriteAccessor()->swapForwardingResolver(resolver);
	m_forwardingConfig.swap(config);
	return true;
}

bool
ForwardingConfigFile::applyAndSave(Forwarding::Config const& config)
{
	Forwarding::Config new_config(config);
	Forwarding::Resolver resolver(new_config);
	
	std::ostringstream strm;
	config.toStream(strm);
	if (!FileOps::writeFile(m_filePath, strm.str())) {
		return false;
	}
	
	GlobalState::WriteAccessor()->swapForwardingResolver(resolver);
	m_forwardingConfig.swap(new_config);
	return true;
}

void
ForwardingConfigFile::applyFallback(ObsoleteForwardingInfo const& fallback)
{
	Forwarding::Config config(fallback.toNewFormat());
	Forwarding::Resolver resolver(config);
	GlobalState::WriteAccessor()->swapForwardingResolver(resolver);
	m_forwardingConfig.swap(config);
}

} // namespace GtkGUI
