/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SOCKS5AUTHENTICATOR_H_
#define SOCKS5AUTHENTICATOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Observer.h"
#include "AsyncReaderWriter.h"
#include "SocksError.h"
#include <ace/config-lite.h>
#include <string>
#include <vector>

class Reactor;

class Socks5Authenticator : private AsyncReaderWriter::Listener
{
	DECLARE_NON_COPYABLE(Socks5Authenticator)
public:
	class Listener;
	
	Socks5Authenticator();
	
	virtual ~Socks5Authenticator();
	
	void startAuthentication(
		Listener& listener, Reactor& reactor, ACE_HANDLE handle,
		std::string const& username, std::string const& password);
	
	void abort();
	
	bool isInProgress() const { return m_state != ST_INACTIVE; }
private:
	enum State {
		ST_INACTIVE,
		ST_SENDING_METHODS,
		ST_RECEIVING_METHOD,
		ST_SENDING_AUTH,
		ST_RECEIVING_STATUS
	};
	
	virtual void onReadDone();
	
	virtual void onReadError();
	
	virtual void onWriteDone();
	
	virtual void onWriteError();
	
	virtual void onGenericError();
	
	void onMethodReceived();
	
	void onStatusReceived();
	
	void handleAuthFailure(SocksError::Code code);
	
	void handleAuthSuccess();
	
	static std::vector<unsigned char> createAuthMsg(
		std::string const& username, std::string const& password);
	
	State m_state;
	SingleObserverLink<Listener> m_observerLink;
	AsyncReaderWriter m_readerWriter;
	std::vector<unsigned char> m_msgAuth;
	unsigned char m_recvBuf[2];
	char m_isAuthProvided;
	static unsigned char const m_sMsgMethods1[];
	static unsigned char const m_sMsgMethods2[];
};


class Socks5Authenticator::Listener : public ObserverBase
{
public:
	virtual ~Listener() {}
	
	virtual void onAuthSuccess() = 0;
	
	virtual void onAuthFailure(SocksError const& err) = 0;
};

#endif
