/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "JpegContentIdentifier.h"
#include "JpegImageInspector.h"
#include "SplittableBuffer.h"
#include "ImageResponseFilter.h"

using namespace std;

char const JpegContentIdentifier::SIGNATURE[] = { 0xff, 0xd8, 0xff };

JpegContentIdentifier::Status
JpegContentIdentifier::identify(SplittableBuffer const& data) const
{
	return checkSignature(data, SIGNATURE, SIGNATURE+sizeof(SIGNATURE));
}

std::auto_ptr<AbstractResponseFilter>
JpegContentIdentifier::getFilter(ResponseFilterChain& chain, bool ignore_size) const
{
	return std::auto_ptr<AbstractResponseFilter>(
		new ImageResponseFilter(
			chain, ignore_size,
			std::auto_ptr<AbstractImageInspector>(new JpegImageInspector)
		)
	);
}
