/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HTTPSTATEHEADERS_H_
#define HTTPSTATEHEADERS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpState.h"
#include "BString.h"
#include "SBOutStream.h"
#include "SplittableBuffer.h"

class HttpParserBase;
class HttpHeadersCollection;
class HttpVersion;

class HttpStateHeaders : public HttpState
{
public:
	HttpStateHeaders(HttpParserBase& parser);
	
	virtual ~HttpStateHeaders();
	
	virtual HttpState* processNewData(
		SplittableBuffer& input, bool eof,
		SplittableBuffer& body_data, bool& body_eof);
protected:
	void reset();
	
	static bool isPersistentConnection(
		HttpHeadersCollection const& headers,
		HttpVersion const& http_version);
	
	static bool isSingularHeader(BString const& header);
private:
	enum State {
		ST_CHECKING_FOR_END,
		ST_CHECKING_FOR_END_2,
		ST_LOOKING_FOR_COLON,
		ST_LOOKING_FOR_NEWLINE
	};
	
	HttpState* processData(
		SplittableBuffer::ByteIterator& begin,
		SplittableBuffer::ByteIterator const& end, bool& body_eof);
	
	BString trim(
		SplittableBuffer::ByteIterator begin,
		SplittableBuffer::ByteIterator end);
	
	virtual void addHeader(BString const& name, BString const& value) = 0;
	
	virtual HttpState* headersReceived(bool& body_eof) = 0;
	
	HttpParserBase& m_rParser;
	State m_state;
	BString m_headerName;
	SBOutStream m_headerValueStream;
};

#endif
