/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpStateChunkBody.h"
#include "HttpParserBase.h"
#include "SplittableBuffer.h"
#include <string>

using namespace std;

HttpStateChunkBody::HttpStateChunkBody(HttpParserBase& parser)
:	m_rParser(parser)
{
}

HttpStateChunkBody::~HttpStateChunkBody()
{
}

void
HttpStateChunkBody::activate(uintmax_t size)
{
	m_remainingSize = size;
}

HttpState*
HttpStateChunkBody::processNewData(SplittableBuffer& input, bool eof,
                                   SplittableBuffer& body_data, bool& body_eof)
{
	size_t input_size = input.size();
	if (m_remainingSize <= input_size) {
		input.splitFrontAppendBack(m_remainingSize, body_data);
		return m_rParser.activateStateChunkHeader();
		// there is \r\n after the chunk body, but we handle it
		// as whitespace preceding the next chunk header
	}
	m_remainingSize -= input_size;
	body_data.appendDestructive(input);
	if (eof) {
		return m_rParser.activateStateError("unexpected end of data (in HttpStateChunkBody)");
	}
	return this;
}
