/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONNACCEPTOR_H_
#define CONNACCEPTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "IntrusivePtr.h"
#include "RefCountableSAP.h"
#include "Reactor.h"
#include <memory>

class ACE_SOCK_Acceptor;
class ACE_SOCK_Stream;
class ACE_INET_Addr;

class ConnAcceptor
{
	DECLARE_NON_COPYABLE(ConnAcceptor)
public:
	enum StopOnSignals { STOP_ON_SIGNALS, DONT_STOP_ON_SIGNALS };
	enum Status { ACCEPTED, FAILED, ABORTED, STOPPED_BY_SIGNAL };
	
	typedef IntrusivePtr<RefCountableSAP<ACE_SOCK_Acceptor> > AcceptorPtr;
	
	ConnAcceptor(StopOnSignals stop_on_signals);
	
	~ConnAcceptor();
	
	bool add(AcceptorPtr const& acceptor);
	
	void remove(AcceptorPtr const& acceptor);
	
	void removeAll();
	
	Status accept(ACE_SOCK_Stream& peer, ACE_INET_Addr& peer_addr);
	
	void abort();
private:
	class EvtHandler;
	class AcceptorReadyException;
	
	static Status acceptConnection(AcceptorPtr const& acceptor,
		ACE_SOCK_Stream& peer, ACE_INET_Addr& peer_addr);
	
	std::auto_ptr<Reactor> m_ptrReactor;
};

#endif
