/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NfaClosure.h"

NfaClosure::NfaClosure(Nfa const& object)
:	m_startPos(object.getStartPos()),
	m_finishPos(object.getFinishPos())
{
	m_states.assign(object.statesBegin(), object.statesEnd());
	m_states[m_startPos].addEpsilonTransition(m_finishPos - m_startPos);
	m_states[m_finishPos].addEpsilonTransition(m_startPos - m_finishPos);
}

NfaClosure::~NfaClosure()
{
}

int
NfaClosure::length() const
{
	return -1;
}

NfaState const*
NfaClosure::statesBegin() const
{
	return &m_states[0];
}

NfaState const*
NfaClosure::statesEnd() const
{
	return &m_states[m_states.size()];
}

int
NfaClosure::getStartPos() const
{
	return m_startPos;
}

int
NfaClosure::getFinishPos() const
{
	return m_finishPos;
}
