/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef MTGUARD_H_
#define MTGUARD_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cassert>

template<typename LOCK>
class MtGuard
{
public:
	MtGuard(LOCK& lock);
	
	~MtGuard();
private:
	LOCK& m_rLock;
};


template<typename LOCK>
class MtAntiGuard
{
public:
	MtAntiGuard(LOCK& lock);
	
	~MtAntiGuard();
private:
	LOCK& m_rLock;
};


template<typename LOCK>
MtGuard<LOCK>::MtGuard(LOCK& lock)
:	m_rLock(lock)
{
	if (m_rLock.acquire() != 0) {
		assert("failed to acquire lock");
	}
}

template<typename LOCK>
MtGuard<LOCK>::~MtGuard()
{
	if (m_rLock.release() != 0) {
		assert("failed to acquire lock");
	}
}


template<typename LOCK>
MtAntiGuard<LOCK>::MtAntiGuard(LOCK& lock)
:	m_rLock(lock)
{
	if (m_rLock.release() != 0) {
		assert("failed to acquire lock");
	}
}

template<typename LOCK>
MtAntiGuard<LOCK>::~MtAntiGuard()
{
	if (m_rLock.acquire() != 0) {
		assert("failed to acquire lock");
	}
}

#endif
