/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILEHANDLE_H_
#define FILEHANDLE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ace/config-lite.h> // for ACE_HANDLE

/**
 * \brief Holds a file handle and provides auto_ptr-like semantics.
 */
class FileHandle
{
private:
	struct CopyHelper
	{
		ACE_HANDLE handle;
		
		CopyHelper(ACE_HANDLE h) : handle(h) {}
	};
public:
	FileHandle(ACE_HANDLE h = ACE_INVALID_HANDLE) : m_handle(h) {}
	
	FileHandle(FileHandle& other) : m_handle(other.release()) {}
	
	FileHandle(CopyHelper helper) : m_handle(helper.handle) {}
	
	~FileHandle();
	
	FileHandle& operator=(FileHandle& other);
	
	FileHandle& operator=(CopyHelper helper);
	
	operator CopyHelper() { return CopyHelper(release()); }
	
	void swap(FileHandle& other);
	
	ACE_HANDLE get() const { return m_handle; }
	
	bool isValid() const { return m_handle != ACE_INVALID_HANDLE; }
	
	void reset(ACE_HANDLE h = ACE_INVALID_HANDLE);
	
	ACE_HANDLE release();
private:
	ACE_HANDLE m_handle;
};


inline void swap(FileHandle& o1, FileHandle& o2)
{
	o1.swap(o2);
}

#endif
