/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DATACHUNK_H_
#define DATACHUNK_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "AtomicCounter.h"
#include <ace/config-lite.h>
#include <ace/Synch_Traits.h>
#include <stddef.h>
#include <memory>

class DataChunk
{
	DECLARE_NON_COPYABLE(DataChunk)
private:
	DataChunk(size_t data_size) : m_dataSize(data_size) {}
public:
	static std::auto_ptr<DataChunk> create(size_t size) {
		return std::auto_ptr<DataChunk>(new(size) DataChunk(size));
	}
	
	static std::auto_ptr<DataChunk> resize(std::auto_ptr<DataChunk> chunk, size_t size);
	
	char* getDataAddr() { return (char*)this + sizeof(*this); }
	
	char const* getDataAddr() const { return (char const*)this + sizeof(*this); }
	
	size_t getDataSize() const { return m_dataSize; }
	
	void ref() const { ++m_refCounter; }
	
	void unref() const { if (--m_refCounter == 0) delete this; }
	
	static void* operator new(size_t size, size_t data_size);
	
	static void operator delete(void* addr);
	
	static void operator delete(void* addr, size_t) {
		operator delete(addr);
	}
private:
	size_t m_dataSize;
	mutable AtomicCounter<ACE_SYNCH> m_refCounter;
};

#endif
