/* ****************************************************************************

 * eID Middleware Project.
 * Copyright (C) 2008-2009 FedICT.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.

**************************************************************************** */
#include "UnitTest++/src/UnitTest++.h"
#include "ByteArray.h"
#include "../applayer/cryptoFwkBeid.h"

using namespace eIDMW;

static const unsigned char _rootOk[] = 
{
        0X30,0x82,0x03,0x94,0x30,0x82,0x02,0x7C,0xA0,0x03,0x02,0x01,0x02,0x02,0x10,0x58,
		0x0B,0x05,0x6C,0x53,0x24,0xDB,0xB2,0x50,0x57,0x18,0x5F,0xF9,0xE5,0xA6,0x50,0x30,
		0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,0x27,
		0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,
		0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0F,0x42,0x65,0x6C,0x67,0x69,0x75,0x6D,0x20,
		0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,0x30,0x1E,0x17,0x0D,0x30,0x33,0x30,0x31,0x32,
		0x36,0x32,0x33,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x31,0x34,0x30,0x31,0x32,0x36,
		0x32,0x33,0x30,0x30,0x30,0x30,0x5A,0x30,0x27,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,
		0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x03,0x13,
        0x0F,0x42,0x65,0x6C,0x67,0x69,0x75,0x6D,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,
		0x30,0x82,0x01,0x22,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,
		0x01,0x05,0x00,0x03,0x82,0x01,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,
		0x00,0xC8,0xA1,0x71,0xE9,0x1C,0x46,0x42,0x79,0x78,0x71,0x6F,0x9D,0xAE,0xA9,0xA8,
		0xAB,0x28,0xB7,0x4D,0xC7,0x20,0xEB,0x30,0x91,0x5A,0x75,0xF5,0xE2,0xD2,0xCF,0xC8,
		0x4C,0x14,0x98,0x42,0x58,0xAD,0xC7,0x11,0xC5,0x40,0x40,0x6A,0x5A,0xF9,0x74,0x12,
		0x27,0x87,0xE9,0x9C,0xE5,0x71,0x4E,0x22,0x2C,0xD1,0x12,0x18,0xAA,0x30,0x5E,0xA2,

		0x21,0xB9,0xD9,0xBB,0xFF,0xF6,0x74,0xEB,0x31,0x01,0xE7,0x3B,0x7E,0x58,0x0F,0x91,
		0x16,0x4D,0x76,0x89,0xA8,0x01,0x4F,0xAD,0x22,0x66,0x70,0xFA,0x4B,0x1D,0x95,0xC1,
        0x30,0x58,0xEA,0xBC,0xD9,0x65,0xD8,0x9A,0xB4,0x88,0xEB,0x49,0x46,0x52,0xDF,0xD2,
		0x53,0x15,0x76,0xCB,0x14,0x5D,0x19,0x49,0xB1,0x6F,0x6A,0xD3,0xD3,0xFD,0xBC,0xC2,
		0x2D,0xEC,0x45,0x3F,0x09,0x3F,0x58,0xBE,0xFC,0xD4,0xEF,0x00,0x8C,0x81,0x35,0x72,
		0xBF,0xF7,0x18,0xEA,0x96,0x62,0x7D,0x2B,0x28,0x7F,0x15,0x6C,0x63,0xD2,0xCA,0xCA,
		0x7D,0x05,0xAC,0xC8,0x6D,0x07,0x6D,0x32,0xBE,0x68,0xB8,0x05,0x40,0xAE,0x54,0x98,
		0x56,0x3E,0x66,0xF1,0x30,0xE8,0xEF,0xC4,0xAB,0x93,0x5E,0x07,0xDE,0x32,0x8F,0x12,
		0x74,0xAA,0x5B,0x34,0x23,0x54,0xC0,0xEA,0x6C,0xCE,0xFE,0x36,0x92,0xA8,0x09,0x17,
		0xEA,0xA1,0x2D,0xCF,0x6C,0xE3,0x84,0x1D,0xDE,0x87,0x2E,0x33,0x0B,0x3C,0x74,0xE2,
		0x21,0x50,0x38,0x95,0x2E,0x5C,0xE0,0xE5,0xC6,0x31,0xF9,0xDB,0x40,0xFA,0x6A,0xA1,
		0xA4,0x8A,0x93,0x9B,0xA7,0x21,0x06,0x87,0x1D,0x27,0xD3,0xC4,0xA1,0xC9,0x4C,0xB0,
		0x6F,0x02,0x03,0x01,0x00,0x01,0xA3,0x81,0xBB,0x30,0x81,0xB8,0x30,0x0E,0x06,0x03,
		0x55,0x1D,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0F,0x06,0x03,
		0x55,0x1D,0x13,0x01,0x01,0xFF,0x04,0x05,0x30,0x03,0x01,0x01,0xFF,0x30,0x42,0x06,
		0x03,0x55,0x1D,0x20,0x04,0x3B,0x30,0x39,0x30,0x37,0x06,0x05,0x60,0x38,0x01,0x01,

		0x01,0x30,0x2E,0x30,0x2C,0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,
		0x20,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x72,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,
		0x72,0x79,0x2E,0x65,0x69,0x64,0x2E,0x62,0x65,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,
		0x65,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0x10,0xF0,0x0C,0x56,
		0x9B,0x61,0xEA,0x57,0x3A,0xB6,0x35,0x97,0x6D,0x9F,0xDD,0xB9,0x14,0x8E,0xDB,0xE6,
		0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8,0x42,0x01,0x01,0x04,0x04,0x03,
		0x02,0x00,0x07,0x30,0x1F,0x06,0x03,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
		0x10,0xF0,0x0C,0x56,0x9B,0x61,0xEA,0x57,0x3A,0xB6,0x35,0x97,0x6D,0x9F,0xDD,0xB9,
		0x14,0x8E,0xDB,0xE6,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,
		0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xC8,0x6D,0x22,0x51,0x8A,0x61,0xF8,0x0F,
		0x96,0x6E,0xD5,0x20,0xB2,0x81,0xF8,0xC6,0xDC,0xA3,0x16,0x00,0xDA,0xCD,0x6A,0xE7,
		0x6B,0x2A,0xFA,0x59,0x48,0xA7,0x4C,0x49,0x37,0xD7,0x73,0xA1,0x6A,0x01,0x65,0x5E,
		0x32,0xBD,0xE7,0x97,0xD3,0xD0,0x2E,0x3C,0x73,0xD3,0x8C,0x7B,0x83,0xEF,0xD6,0x42,
		0xC1,0x3F,0xA8,0xA9,0x5D,0x0F,0x37,0xBA,0x76,0xD2,0x40,0xBD,0xCC,0x2D,0x3F,0xD3,
		0x44,0x41,0x49,0x9C,0xFD,0x5B,0x29,0xF4,0x02,0x23,0x22,0x5B,0x71,0x1B,0xBF,0x58,
		0xD9,0x28,0x4E,0x2D,0x45,0xF4,0xDA,0xE7,0xB5,0x63,0x45,0x44,0x11,0x0D,0x2A,0x7F,

		0x33,0x7F,0x36,0x49,0xB4,0xCE,0x6E,0xA9,0x02,0x31,0xAE,0x5C,0xFD,0xC8,0x89,0xBF,
		0x42,0x7B,0xD7,0xF1,0x60,0xF2,0xD7,0x87,0xF6,0x57,0x2E,0x7A,0x7E,0x6A,0x13,0x80,
		0x1D,0xDC,0xE3,0xD0,0x63,0x1E,0x3D,0x71,0x31,0xB1,0x60,0xD4,0x9E,0x08,0xCA,0xAB,
		0xF0,0x94,0xC7,0x48,0x75,0x54,0x81,0xF3,0x1B,0xAD,0x77,0x9C,0xE8,0xB2,0x8F,0xDB,
		0x83,0xAC,0x8F,0x34,0x6B,0xE8,0xBF,0xC3,0xD9,0xF5,0x43,0xC3,0x64,0x55,0xEB,0x1A,
		0xBD,0x36,0x86,0x36,0xBA,0x21,0x8C,0x97,0x1A,0x21,0xD4,0xEA,0x2D,0x3B,0xAC,0xBA,
		0xEC,0xA7,0x1D,0xAB,0xBE,0xB9,0x4A,0x9B,0x35,0x2F,0x1C,0x5C,0x1D,0x51,0xA7,0x1F,
		0x54,0xED,0x12,0x97,0xFF,0xF2,0x6E,0x87,0x7D,0x46,0xC9,0x74,0xD6,0xEF,0xEB,0x3D,
		0x7D,0xE6,0x59,0x6E,0x06,0x94,0x04,0xE4,0xA2,0x55,0x87,0x38,0x28,0x6A,0x22,0x5E,
		0xE2,0xBE,0x74,0x12,0xB0,0x04,0x43,0x2A
};

static const unsigned char _rootKo[] = 
{
        0X30,0x82,0x03,0x94,0x30,0x82,0x02,0x7C,0xA0,0x03,0x02,0x01,0x02,0x02,0x10,0x58,
		0x0B,0x05,0x6C,0x53,0x24,0xDB,0xB2,0x50,0x57,0x18,0x5F,0xF9,0xE5,0xA6,0x50,0x30,
		0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,0x27,
		0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,
		0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0F,0x42,0x65,0x6C,0x67,0x69,0x75,0x6D,0x20,
		0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,0x30,0x1E,0x17,0x0D,0x30,0x33,0x30,0x31,0x32,
		0x36,0x32,0x33,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x31,0x34,0x30,0x31,0x32,0x36,
		0x32,0x33,0x30,0x30,0x30,0x30,0x5A,0x30,0x27,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,
		0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x03,0x13,
        0x0F,0x42,0x65,0x6C,0x67,0x69,0x75,0x6D,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,
		0x30,0x82,0x01,0x22,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,
		0x01,0x05,0x00,0x03,0x82,0x01,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,
		0x00,0xC8,0xA1,0x71,0xE9,0x1C,0x46,0x42,0x79,0x78,0x71,0x6F,0x9D,0xAE,0xA9,0xA8,
		0xAB,0x28,0xB7,0x4D,0xC7,0x20,0xEB,0x30,0x91,0x5A,0x75,0xF5,0xE2,0xD2,0xCF,0xC8,
		0x4C,0x14,0x98,0x42,0x58,0xAD,0xC7,0x11,0xC5,0x40,0x40,0x6A,0x5A,0xF9,0x74,0x12,
		0x27,0x87,0xE9,0x9C,0xE5,0x71,0x4E,0x22,0x2C,0xD1,0x12,0x18,0xAA,0x30,0x5E,0xA2,

		0x21,0xB9,0xD9,0xBB,0xFF,0xF6,0x74,0xEB,0x31,0x01,0xE7,0x3B,0x7E,0x58,0x0F,0x91,
		0x16,0x4D,0x76,0x89,0xA8,0x01,0x4F,0xAD,0x22,0x66,0x70,0xFA,0x4B,0x1D,0x95,0xC1,
        0x30,0x58,0xEA,0xBC,0xD9,0x65,0xD8,0x9A,0xB4,0x88,0xEB,0x49,0x46,0x52,0xDF,0xD2,
		0x53,0x15,0x76,0xCB,0x14,0x5D,0x19,0x49,0xB1,0x6F,0x6A,0xD3,0xD3,0xFD,0xBC,0xC2,
		0x2D,0xEC,0x45,0x3F,0x09,0x3F,0x58,0xBE,0xFC,0xD4,0xEF,0x00,0x8C,0x81,0x35,0x72,
		0xBF,0xF7,0x18,0xEA,0x96,0x62,0x7D,0x2B,0x28,0x7F,0x15,0x6C,0x63,0xD2,0xCA,0xCA,
		0x7D,0x05,0xAC,0xC8,0x6D,0x07,0x6D,0x32,0xBE,0x68,0xB8,0x05,0x40,0xAE,0x54,0x98,
		0x56,0x3E,0x66,0xF1,0x30,0xE8,0xEF,0xC4,0xAB,0x93,0x5E,0x07,0xDE,0x32,0x8F,0x12,
		0x74,0xAA,0x5B,0x34,0x23,0x54,0xC0,0xEA,0x6C,0xCE,0xFE,0x36,0x92,0xA8,0x09,0x17,
		0xEA,0xA1,0x2D,0xCF,0x6C,0xE3,0x84,0x1D,0xDE,0x87,0x2E,0x33,0x0B,0x3C,0x74,0xE2,
		0x21,0x50,0x38,0x95,0x2E,0x5C,0xE0,0xE5,0xC6,0x31,0xF9,0xDB,0x40,0xFA,0x6A,0xA1,
		0xA4,0x8A,0x93,0x9B,0xA7,0x21,0x06,0x87,0x1D,0x27,0xD3,0xC4,0xA1,0xC9,0x4C,0xB0,
		0x6F,0x02,0x03,0x01,0x00,0x01,0xA3,0x81,0xBB,0x30,0x81,0xB8,0x30,0x0E,0x06,0x03,
		0x55,0x1D,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0F,0x06,0x03,
		0x55,0x1D,0x13,0x01,0x01,0xFF,0x04,0x05,0x30,0x03,0x01,0x01,0xFF,0x30,0x42,0x06,
		0x03,0x55,0x1D,0x20,0x04,0x3B,0x30,0x39,0x30,0x37,0x06,0x05,0x60,0x38,0x01,0x01,

		0x01,0x30,0x2E,0x30,0x2C,0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,
		0x20,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x72,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,
		0x72,0x79,0x2E,0x65,0x69,0x64,0x2E,0x62,0x65,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,
		0x65,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0x10,0xF0,0x0C,0x56,
		0x9B,0x61,0xEA,0x57,0x3A,0xB6,0x35,0x97,0x6D,0x9F,0xDD,0xB9,0x14,0x8E,0xDB,0xE6,
		0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8,0x42,0x01,0x01,0x04,0x04,0x03,
		0x02,0x00,0x07,0x30,0x1F,0x06,0x03,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
		0x10,0xF0,0x0C,0x56,0x9B,0x61,0xEA,0x57,0x3A,0xB6,0x35,0x97,0x6D,0x9F,0xDD,0xB9,
		0x14,0x8E,0xDB,0xE6,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,
		0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xC8,0x6D,0x22,0x51,0x8A,0x61,0xF8,0x0F,
		0x96,0x6E,0xD5,0x20,0xB2,0x81,0xF8,0xC6,0xDC,0xA3,0x16,0x00,0xDA,0xCD,0x6A,0xE7,
		0x6B,0x2A,0xFA,0x59,0x48,0xA7,0x4C,0x49,0x37,0xD7,0x73,0xA1,0x6A,0x01,0x65,0x5E,
		0x32,0xBD,0xE7,0x97,0xD3,0xD0,0x2E,0x3C,0x73,0xD3,0x8C,0x7B,0x83,0xEF,0xD6,0x42,
		0xC1,0x3F,0xA8,0xA9,0x5D,0x0F,0x37,0xBA,0x76,0xD2,0x40,0xBD,0xCC,0x2D,0x3F,0xD3,
		0x44,0x41,0x49,0x9C,0xFD,0x5B,0x29,0xF4,0x02,0x23,0x22,0x5B,0x71,0x1B,0xBF,0x58,
		0xD9,0x28,0x4E,0x2D,0x45,0xF4,0xDA,0xE7,0xB5,0x63,0x45,0x44,0x11,0x0D,0x2A,0x7F,

		0x33,0x7F,0x36,0x49,0xB4,0xCE,0x6E,0xA9,0x02,0x31,0xAE,0x5C,0xFD,0xC8,0x89,0xBF,
		0x42,0x7B,0xD7,0xF1,0x60,0xF2,0xD7,0x87,0xF6,0x57,0x2E,0x7A,0x7E,0x6A,0x13,0x80,
		0x1D,0xDC,0xE3,0xD0,0x63,0x1E,0x3D,0x71,0x31,0xB1,0x60,0xD4,0x9E,0x08,0xCA,0xAB,
		0xF0,0x94,0xC7,0x48,0x75,0x54,0x81,0xF3,0x1B,0xAD,0x77,0x9C,0xE8,0xB2,0x8F,0xDB,
		0x83,0xAC,0x8F,0x34,0x6B,0xE8,0xBF,0xC3,0xD9,0xF5,0x43,0xC3,0x64,0x55,0xEB,0x1A,
		0xBD,0x36,0x86,0x36,0xBA,0x21,0x8C,0x97,0x1A,0x21,0xD4,0xEA,0x2D,0x3B,0xAC,0xBA,
		0xEC,0xA7,0x1D,0xAB,0xBE,0xB9,0x4A,0x9B,0x35,0x2F,0x1C,0x5C,0x1D,0x51,0xA7,0x1F,
		0x54,0xED,0x12,0x97,0xFF,0xF2,0x6E,0x87,0x7D,0x46,0xC9,0x74,0xD6,0xEF,0xEB,0x3D,
		0x7D,0xE6,0x59,0x6E,0x06,0x94,0x04,0xE4,0xA2,0x55,0x87,0x38,0x28,0x6A,0x22,0x5E,
		0xE2,0xBE,0x74,0x12,0xB0,0x04,0x43,0x2B
};

static unsigned char _cert[] = {
        0x30,0x82,0x03,0xf6,0x30,0x82,0x02,0xde,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x10,
        0x00,0x00,0x00,0x00,0x00,0x30,0xef,0xb4,0x1b,0x4f,0xf6,0xd6,0x60,0xe4,0x63,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x33,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x13,0x30,
        0x11,0x06,0x03,0x55,0x04,0x03,0x13,0x0a,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,
        0x43,0x41,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,0x04,0x05,0x13,0x06,0x32,0x30,0x30,
        0x36,0x32,0x30,0x30,0x1e,0x17,0x0d,0x30,0x36,0x31,0x30,0x32,0x35,0x31,0x39,0x32,
        0x33,0x30,0x38,0x5a,0x17,0x0d,0x31,0x31,0x31,0x30,0x32,0x34,0x32,0x33,0x35,0x39,
        0x35,0x39,0x5a,0x30,0x69,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,
        0x42,0x45,0x31,0x22,0x30,0x20,0x06,0x03,0x55,0x04,0x03,0x13,0x19,0x53,0x74,0x65,
        0x66,0x61,0x6e,0x20,0x48,0x6f,0x65,0x62,0x65,0x6e,0x20,0x28,0x53,0x69,0x67,0x6e,
        0x61,0x74,0x75,0x72,0x65,0x29,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,0x04,0x04,0x13,
        0x06,0x48,0x6f,0x65,0x62,0x65,0x6e,0x31,0x0f,0x30,0x0d,0x06,0x03,0x55,0x04,0x2a,
        0x13,0x06,0x53,0x74,0x65,0x66,0x61,0x6e,0x31,0x14,0x30,0x12,0x06,0x03,0x55,0x04,
        0x05,0x13,0x0b,0x37,0x33,0x30,0x34,0x30,0x31,0x30,0x32,0x37,0x34,0x39,0x30,0x81,
        0x9f,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,
        0x03,0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0x8c,0x4c,0x0f,0x82,0xac,
        0x6c,0x92,0xc7,0x60,0xc9,0xe0,0x8a,0x14,0x85,0x32,0xc1,0x8f,0xf0,0x8b,0xec,0x22,
        0x67,0x06,0x2c,0x1c,0x85,0xd8,0xf6,0xa9,0x25,0xee,0x8c,0xa9,0xfb,0x5e,0xc0,0x30,
        0x03,0x51,0x62,0x3a,0xce,0x62,0x39,0x27,0x8d,0x1d,0x85,0xcf,0xd4,0x1c,0x97,0xca,
        0xc9,0xb4,0x30,0xaf,0xb3,0x39,0xea,0x67,0xee,0x34,0x8e,0xae,0x51,0xa8,0xbf,0x41,
        0x4c,0x46,0xbd,0x1a,0x77,0x14,0x48,0x30,0x34,0x1d,0x47,0x52,0x26,0xa8,0x7a,0xc8,
        0x7b,0xf0,0x78,0x3f,0x21,0x1e,0x34,0xe4,0x91,0x93,0x67,0x94,0x84,0x59,0xd6,0xe2,
        0x19,0x04,0xbe,0x33,0xc0,0x66,0xcd,0xf7,0x22,0xf1,0xd1,0x41,0x11,0xa1,0x59,0x0a,
        0x2a,0x05,0x6c,0x5b,0x4b,0xc8,0x7f,0x1e,0xf1,0xb2,0xab,0x02,0x03,0x01,0x00,0x01,
        0xa3,0x82,0x01,0x52,0x30,0x82,0x01,0x4e,0x30,0x44,0x06,0x03,0x55,0x1d,0x20,0x04,
        0x3d,0x30,0x3b,0x30,0x39,0x06,0x07,0x60,0x38,0x01,0x01,0x01,0x02,0x01,0x30,0x2e,
        0x30,0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,
        0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,
        0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x0e,
        0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,0x04,0x03,0x02,0x06,0x40,0x30,0x1f,
        0x06,0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x07,0x93,0x19,0x45,0x26,
        0xaf,0x58,0x85,0x94,0xbf,0xb1,0xb4,0xb4,0x5e,0x9e,0xc2,0x7b,0x86,0xda,0x70,0x30,
        0x39,0x06,0x03,0x55,0x1d,0x1f,0x04,0x32,0x30,0x30,0x30,0x2e,0xa0,0x2c,0xa0,0x2a,
        0x86,0x28,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,
        0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x65,0x69,0x64,0x63,
        0x32,0x30,0x30,0x36,0x32,0x30,0x2e,0x63,0x72,0x6c,0x30,0x11,0x06,0x09,0x60,0x86,
        0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x05,0x20,0x30,0x6d,0x06,
        0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x01,0x04,0x61,0x30,0x5f,0x30,0x35,0x06,
        0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x02,0x86,0x29,0x68,0x74,0x74,0x70,0x3a,
        0x2f,0x2f,0x63,0x65,0x72,0x74,0x73,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,
        0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x72,0x73,
        0x2e,0x63,0x72,0x74,0x30,0x26,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x30,0x01,
        0x86,0x1a,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x6f,0x63,0x73,0x70,0x2e,0x65,0x69,
        0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x18,0x06,0x08,
        0x2b,0x06,0x01,0x05,0x05,0x07,0x01,0x03,0x04,0x0c,0x30,0x0a,0x30,0x08,0x06,0x06,
        0x04,0x00,0x8e,0x46,0x01,0x01,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,
        0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x51,0xac,0x8e,0x4b,0x6a,0x2d,
        0xd8,0x6a,0x85,0x9a,0x09,0x92,0xc4,0x1c,0x34,0x9c,0xe0,0x4c,0x91,0x5e,0x36,0x18,
        0x1a,0x0d,0x0a,0x9e,0x08,0xeb,0xc9,0xd8,0xf4,0x08,0x90,0x05,0x4f,0xa9,0x2d,0xef,
        0xef,0x32,0xf4,0xd3,0x50,0x36,0x1b,0x3f,0x93,0xe1,0xba,0xa5,0x94,0x62,0x26,0x63,
        0xbd,0x2e,0x81,0x3e,0xc8,0x5a,0x88,0x8a,0x84,0x9f,0x01,0x66,0xbe,0x5f,0x03,0x53,
        0xd7,0x40,0x68,0xce,0x13,0xeb,0x42,0x67,0x09,0x11,0xe2,0xc0,0xde,0x64,0x7f,0xf9,
        0x2b,0x72,0x8d,0x9c,0xdb,0x1d,0x1f,0xf9,0xbf,0x63,0x36,0xbc,0xc2,0xc9,0xed,0x2d,
        0xad,0xc2,0xac,0x42,0x38,0xb3,0x5a,0xe1,0x3c,0x34,0x06,0x93,0x4b,0xc0,0x9e,0x4c,
        0xc6,0xb8,0xc7,0x71,0x55,0x37,0x8f,0x8d,0xf8,0x74,0x31,0x09,0x1a,0x77,0x24,0x50,
        0x28,0xc2,0xd6,0x62,0x73,0x63,0xb9,0xc5,0x96,0xdc,0xa9,0x25,0xe9,0xdb,0x69,0xef,
        0xbb,0xaa,0x57,0x12,0xa9,0x01,0x31,0x38,0xbd,0x58,0xa4,0x24,0xfa,0x6d,0xad,0x7f,
        0x0d,0xbd,0x5d,0x14,0xba,0x64,0x14,0xbb,0x0a,0x9d,0x98,0x2a,0x00,0x07,0x11,0x17,
        0xdf,0x24,0x21,0x3f,0x05,0xb5,0xfa,0x0a,0xc7,0x73,0x89,0xd4,0x53,0x69,0x11,0x91,
        0xc0,0x7c,0x2c,0x17,0x78,0x10,0x2c,0xa5,0xfd,0x00,0xbf,0x6a,0x19,0xe5,0xbb,0xda,
        0x89,0xf1,0xb1,0x16,0xc4,0x60,0xd0,0x58,0x62,0xf1,0x8b,0xfd,0x0b,0xf6,0x07,0x59,
        0x1b,0x45,0xc8,0xca,0x57,0x8c,0x59,0x11,0xc7,0xa5,0xf3,0xa6,0x09,0x54,0xb7,0x06,
        0xd3,0xfe,0xc8,0x2b,0x7a,0x9e,0xf3,0xba,0x71,0xaa,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

static unsigned char _ca[] = {
        0x30,0x82,0x03,0xdc,0x30,0x82,0x02,0xc4,0xa0,0x03,0x02,0x01,0x02,0x02,0x10,0x37,
        0x7a,0x2a,0x69,0x18,0x27,0xc6,0xbb,0x56,0x8a,0x3b,0x53,0xb4,0xca,0x09,0x00,0x30,
        0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x27,
        0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,
        0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,
        0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x35,0x31,0x32,0x30,
        0x31,0x31,0x31,0x30,0x30,0x30,0x30,0x5a,0x17,0x0d,0x31,0x32,0x30,0x38,0x30,0x31,
        0x31,0x30,0x30,0x30,0x30,0x30,0x5a,0x30,0x33,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,
        0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x13,0x30,0x11,0x06,0x03,0x55,0x04,0x03,0x13,
        0x0a,0x43,0x69,0x74,0x69,0x7a,0x65,0x6e,0x20,0x43,0x41,0x31,0x0f,0x30,0x0d,0x06,
        0x03,0x55,0x04,0x05,0x13,0x06,0x32,0x30,0x30,0x36,0x32,0x30,0x30,0x82,0x01,0x22,
        0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,
        0x82,0x01,0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,0x01,0x00,0xaf,0x29,0xad,
        0xf8,0x97,0x18,0xbc,0xea,0x93,0xe4,0xcc,0x8e,0xf3,0xb6,0xfc,0xf5,0x2b,0x36,0x60,
        0x47,0x86,0xa4,0x78,0x93,0x1c,0xac,0xc7,0xcc,0x34,0xbe,0xb1,0xa2,0x95,0x85,0xeb,
        0xfa,0xf9,0x8d,0x4a,0xad,0x4f,0x70,0xeb,0x32,0x1f,0x61,0x34,0x87,0xc8,0xa6,0x03,
        0xf9,0x61,0x62,0xd0,0x80,0x83,0x8b,0xbd,0x62,0x86,0x24,0x49,0x37,0xf3,0x24,0x92,
        0x0e,0xca,0xd5,0x66,0xbc,0x9f,0xb6,0x24,0xf0,0xd9,0x91,0xae,0xfa,0x24,0x74,0xc7,
        0xfd,0xa1,0x71,0x60,0xe0,0xb0,0xfe,0xad,0xaf,0x1d,0xc9,0x10,0x87,0xdb,0x50,0xb8,
        0xaf,0xe5,0x26,0xf5,0x05,0x50,0xaa,0x5c,0xe8,0xf5,0x03,0xa1,0x7b,0x5f,0x96,0xa5,
        0x66,0x91,0xf4,0x73,0x0e,0xe8,0xa6,0x5a,0xb4,0x0b,0xf0,0xf0,0xf9,0xe3,0x60,0xe9,
        0x53,0xc7,0x14,0x95,0xec,0x1b,0xcb,0x22,0xdf,0x75,0x16,0x65,0x7b,0x52,0xf4,0xf0,
        0xa4,0x1d,0x18,0x25,0x17,0xa0,0xd5,0x18,0xf5,0xc8,0x14,0x25,0xe1,0x23,0xa8,0xb0,
        0xe5,0x08,0xf1,0x38,0xd6,0x97,0x2e,0xec,0x1e,0xff,0x5a,0x19,0x23,0xc0,0x53,0xba,
        0xb8,0xdc,0xcf,0x08,0xed,0xe5,0x70,0x56,0x79,0xa7,0x96,0x3e,0x3a,0x8a,0x19,0xf9,
        0x20,0x5f,0x62,0x44,0x1d,0x88,0xf3,0xa4,0xd2,0x88,0x4f,0x48,0xe5,0x1a,0x73,0xcd,
        0x36,0xe0,0x5a,0xb3,0x12,0xc8,0xfd,0xd6,0x4b,0x95,0xac,0x3e,0x85,0x5c,0x15,0x31,
        0x60,0x52,0xa2,0x8f,0xa0,0x28,0x1a,0x6e,0x2c,0x32,0x8f,0x21,0x5c,0xc3,0xa6,0xf6,
        0x55,0xd2,0xaa,0x1d,0xa4,0x98,0xdd,0x2f,0xcd,0xd4,0x76,0x5f,0x91,0x02,0x03,0x01,
        0x00,0x01,0xa3,0x81,0xf7,0x30,0x81,0xf4,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,
        0x01,0xff,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,0x03,0x55,0x1d,0x13,0x01,
        0x01,0xff,0x04,0x08,0x30,0x06,0x01,0x01,0xff,0x02,0x01,0x00,0x30,0x43,0x06,0x03,
        0x55,0x1d,0x20,0x04,0x3c,0x30,0x3a,0x30,0x38,0x06,0x06,0x60,0x38,0x01,0x01,0x01,
        0x02,0x30,0x2e,0x30,0x2c,0x06,0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,
        0x20,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,
        0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,
        0x65,0x30,0x1d,0x06,0x03,0x55,0x1d,0x0e,0x04,0x16,0x04,0x14,0x07,0x93,0x19,0x45,
        0x26,0xaf,0x58,0x85,0x94,0xbf,0xb1,0xb4,0xb4,0x5e,0x9e,0xc2,0x7b,0x86,0xda,0x70,
        0x30,0x36,0x06,0x03,0x55,0x1d,0x1f,0x04,0x2f,0x30,0x2d,0x30,0x2b,0xa0,0x29,0xa0,
        0x27,0x86,0x25,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,
        0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,
        0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,0x6c,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,
        0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x00,0x07,0x30,0x1f,0x06,0x03,0x55,
        0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x10,0xf0,0x0c,0x56,0x9b,0x61,0xea,0x57,
        0x3a,0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,0x14,0x8e,0xdb,0xe6,0x30,0x0d,0x06,0x09,
        0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,
        0x0f,0x20,0x18,0xcc,0x94,0x9d,0xb3,0xf9,0xd5,0xb8,0x28,0xcd,0x64,0xc2,0x8b,0x61,
        0xbc,0x8a,0x34,0xe3,0xac,0x9c,0x4c,0x61,0x42,0x1f,0x23,0x0d,0x12,0x6e,0xcd,0xce,
        0x97,0xa5,0x9a,0xbc,0x3d,0x51,0xbf,0x93,0xb2,0xbe,0x35,0x9a,0x20,0xe1,0x66,0x93,
        0x58,0xac,0x3f,0xa4,0x90,0xd1,0x81,0xfa,0xed,0x63,0x3a,0xc4,0xc4,0x0b,0x81,0x4d,
        0xb0,0xec,0x37,0xb4,0x51,0xc2,0xf9,0xd3,0x96,0x66,0xb4,0x61,0x15,0xee,0x9b,0x34,
        0x4b,0xae,0x3d,0xaa,0x63,0x47,0x83,0xa0,0x7a,0xd4,0x03,0x8e,0x6a,0x56,0x9e,0xb3,
        0x27,0xf9,0x56,0x77,0xb6,0x56,0x3b,0x5d,0x21,0xb8,0x59,0x64,0xef,0x2e,0x38,0xaf,
        0x63,0xce,0xcd,0x00,0xe2,0x92,0x19,0x33,0x86,0x74,0x1e,0x9e,0xf2,0x1c,0x52,0x92,
        0xa5,0xd3,0x52,0x70,0xb1,0x8d,0x65,0x5e,0xe8,0x6f,0x39,0xf7,0xfc,0x86,0x58,0x06,
        0xdd,0xfb,0xcc,0x95,0x2a,0xa0,0x01,0x7b,0xba,0x06,0xc8,0xed,0x6f,0x8a,0x09,0xff,
        0x5d,0x90,0x2d,0x0e,0x52,0xaa,0xc8,0x37,0xc0,0xe8,0x36,0x19,0xcd,0x14,0x98,0xaf,
        0x94,0x22,0xf5,0xa7,0xe7,0x9e,0x07,0xea,0xf0,0x3c,0xfc,0x7f,0x3a,0xcf,0x5e,0x9a,
        0x2c,0x5f,0xd1,0x2c,0x97,0xa5,0x88,0xf7,0xbb,0xa4,0x1f,0xd8,0x8c,0x43,0x48,0x09,
        0x45,0xeb,0xb2,0xdc,0x6b,0x9a,0x2f,0x66,0xc7,0x99,0x7b,0x63,0x5c,0x17,0x3b,0x28,
        0x97,0xab,0x76,0x3d,0x9e,0x4e,0xba,0xd3,0x38,0x15,0x79,0x2f,0x64,0x2e,0x46,0xb9,
        0x25,0xdf,0xd4,0x98,0x79,0x69,0xd1,0x49,0xc7,0x06,0x89,0x72,0x8f,0x0b,0xfc,0xf1,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,
};

static const unsigned char _rrnOk[] = {
        0x30,0x82,0x03,0x2d,0x30,0x82,0x02,0x15,0xa0,0x03,0x02,0x01,0x02,0x02,0x0b,0x04,
        0x00,0x00,0x00,0x00,0x01,0x07,0xe6,0x0b,0xfc,0xdc,0x30,0x0d,0x06,0x09,0x2a,0x86,
        0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x27,0x31,0x0b,0x30,0x09,0x06,
        0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,
        0x03,0x13,0x0f,0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,0x52,0x6f,0x6f,0x74,0x20,
        0x43,0x41,0x30,0x1e,0x17,0x0d,0x30,0x35,0x31,0x32,0x30,0x31,0x31,0x31,0x30,0x30,
        0x30,0x30,0x5a,0x17,0x0d,0x31,0x32,0x30,0x38,0x30,0x31,0x31,0x30,0x30,0x30,0x30,
        0x30,0x5a,0x30,0x29,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,
        0x45,0x31,0x0c,0x30,0x0a,0x06,0x03,0x55,0x04,0x0a,0x13,0x03,0x52,0x52,0x4e,0x31,
        0x0c,0x30,0x0a,0x06,0x03,0x55,0x04,0x03,0x13,0x03,0x52,0x52,0x4e,0x30,0x81,0x9f,
        0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,
        0x81,0x8d,0x00,0x30,0x81,0x89,0x02,0x81,0x81,0x00,0xe5,0xdc,0x8b,0xbb,0x67,0xfc,
        0xf7,0x73,0x96,0x28,0x23,0xb3,0x42,0x13,0xdf,0x9d,0x31,0x28,0x8b,0x7d,0xed,0x60,
        0xd9,0x11,0xba,0x0c,0x43,0x9c,0xcc,0xe0,0xe6,0x51,0x7d,0xb4,0x71,0xd9,0x00,0xea,
        0x1b,0x5f,0x6f,0x2d,0x17,0xd7,0xb2,0x5a,0x58,0x80,0x3c,0x93,0x70,0x9c,0xa9,0x40,
        0x4b,0x97,0xab,0xd2,0x34,0x17,0xee,0x79,0xcb,0x08,0xdd,0xde,0x12,0x50,0x82,0x24,
        0x73,0xd1,0xf9,0xcb,0x2e,0x4a,0x57,0xc4,0x3a,0x52,0x77,0x97,0x73,0xcc,0x37,0x55,
        0xf0,0x8b,0x8e,0x59,0xaa,0xb7,0x2b,0x11,0xa5,0x06,0x07,0x02,0x32,0xfa,0x42,0x40,
        0x67,0xe0,0x85,0xf1,0xf6,0xed,0xbe,0x62,0xf9,0x24,0x09,0x90,0x90,0x90,0xec,0x3a,
        0x55,0x97,0xbe,0x20,0x8f,0x04,0x87,0x93,0x81,0xcf,0x02,0x03,0x01,0x00,0x01,0xa3,
        0x81,0xdb,0x30,0x81,0xd8,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,0x04,
        0x04,0x03,0x02,0x06,0xc0,0x30,0x43,0x06,0x03,0x55,0x1d,0x20,0x04,0x3c,0x30,0x3a,
        0x30,0x38,0x06,0x06,0x60,0x38,0x01,0x01,0x01,0x04,0x30,0x2e,0x30,0x2c,0x06,0x08,
        0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3a,0x2f,
        0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,0x2e,
        0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x1d,0x06,0x03,0x55,0x1d,
        0x0e,0x04,0x16,0x04,0x14,0x4f,0xa9,0x6f,0xbc,0xd1,0xe4,0x3f,0xb8,0xc4,0x0e,0x7a,
        0xc2,0x00,0x14,0xcc,0x85,0xf2,0x93,0xb2,0x41,0x30,0x36,0x06,0x03,0x55,0x1d,0x1f,
        0x04,0x2f,0x30,0x2d,0x30,0x2b,0xa0,0x29,0xa0,0x27,0x86,0x25,0x68,0x74,0x74,0x70,
        0x3a,0x2f,0x2f,0x63,0x72,0x6c,0x2e,0x65,0x69,0x64,0x2e,0x62,0x65,0x6c,0x67,0x69,
        0x75,0x6d,0x2e,0x62,0x65,0x2f,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x63,0x72,
        0x6c,0x30,0x09,0x06,0x03,0x55,0x1d,0x13,0x04,0x02,0x30,0x00,0x30,0x1f,0x06,0x03,
        0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x10,0xf0,0x0c,0x56,0x9b,0x61,0xea,
        0x57,0x3a,0xb6,0x35,0x97,0x6d,0x9f,0xdd,0xb9,0x14,0x8e,0xdb,0xe6,0x30,0x0d,0x06,
        0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,
        0x00,0xa9,0x38,0xb3,0x32,0xf2,0x4d,0xb0,0x13,0x55,0x6c,0x08,0x1b,0x06,0xf4,0xbb,
        0x97,0x4d,0xd0,0xbb,0xe1,0xb1,0x43,0x49,0xf8,0x4f,0x62,0x4f,0xdb,0x25,0x06,0x86,
        0x2c,0x31,0xa3,0x27,0xb4,0x61,0xd0,0x9f,0xd2,0x9a,0x30,0x23,0x28,0x5d,0x5c,0x47,
        0xbe,0xe6,0x3b,0xd4,0x7d,0x3b,0x68,0x35,0xde,0x1a,0xcd,0xd0,0xe0,0x54,0x50,0x61,
        0x42,0xf1,0xc7,0x23,0x29,0x49,0x63,0xb5,0x8b,0x09,0x25,0x87,0x4b,0x3a,0xb3,0x56,
        0xd6,0xb6,0xa2,0xe0,0x47,0xbd,0xc5,0x51,0x68,0xef,0x79,0x65,0x62,0x9b,0x95,0xf2,
        0xf3,0x20,0xdd,0xbc,0x27,0x86,0xf8,0x93,0xda,0x01,0xd1,0x7e,0x7f,0x76,0x5e,0xa1,
        0x10,0x7d,0x07,0xfd,0x27,0x98,0x72,0x79,0x32,0x8b,0xbc,0xe4,0xc9,0x1a,0xfd,0x85,
        0x83,0xf7,0x91,0x09,0xc8,0x74,0xff,0xfa,0x0f,0x2a,0x28,0xbb,0xbc,0x1e,0x85,0x86,
        0xc0,0x4f,0x91,0x16,0xfa,0x1b,0x18,0x84,0xae,0xd5,0x24,0x1a,0x00,0xb9,0x0b,0xae,
        0xe2,0x20,0x1f,0xa7,0x30,0xaf,0xb5,0x85,0x51,0xc9,0x8e,0x07,0x21,0x78,0x31,0x7d,
        0x51,0x97,0x6c,0xcc,0x8d,0xab,0xab,0xfa,0x0a,0x94,0x69,0xfc,0x76,0x56,0x0e,0xd2,
        0xa2,0x14,0x64,0x17,0x01,0x6e,0xbe,0x43,0x2d,0x57,0x0f,0x53,0xc5,0x48,0x52,0x54,
        0x65,0x3b,0x05,0x23,0xaa,0x91,0x58,0x15,0x86,0xdc,0x0f,0x0d,0x8f,0x1b,0x47,0xd0,
        0xe3,0x58,0xb1,0x70,0xcf,0x31,0x7d,0x2c,0x92,0xdd,0xc0,0xda,0xff,0x1e,0xb6,0xa7,
        0xda,0xce,0x86,0xad,0xc4,0x01,0x8b,0x32,0x97,0x81,0xe0,0x40,0x7f,0x3a,0xd5,0x72,
        0x1f,
};

static const unsigned char _photo[] = {
        0xff,0xd8,0xff,0xe0,0x00,0x10,0x4a,0x46,0x49,0x46,0x00,0x01,0x02,0x01,0x01,0x2c,
        0x01,0x2c,0x00,0x00,0xff,0xdb,0x00,0x43,0x00,0x0f,0x0a,0x0b,0x0d,0x0b,0x09,0x0f,
        0x0d,0x0c,0x0d,0x11,0x10,0x0f,0x11,0x16,0x25,0x18,0x16,0x14,0x14,0x16,0x2d,0x20,
        0x22,0x1b,0x25,0x35,0x2f,0x38,0x37,0x34,0x2f,0x34,0x33,0x3b,0x42,0x55,0x48,0x3b,
        0x3f,0x50,0x3f,0x33,0x34,0x4a,0x64,0x4b,0x50,0x57,0x5a,0x5f,0x60,0x5f,0x39,0x47,
        0x68,0x6f,0x67,0x5c,0x6e,0x55,0x5d,0x5f,0x5b,0xff,0xc0,0x00,0x0b,0x08,0x00,0xc8,
        0x00,0x8c,0x01,0x01,0x11,0x00,0xff,0xc4,0x00,0xd2,0x00,0x00,0x01,0x05,0x01,0x01,
        0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x03,0x04,
        0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x10,0x00,0x02,0x01,0x03,0x03,0x02,0x04,0x03,
        0x05,0x05,0x04,0x04,0x00,0x00,0x01,0x7d,0x01,0x02,0x03,0x00,0x04,0x11,0x05,0x12,
        0x21,0x31,0x41,0x06,0x13,0x51,0x61,0x07,0x22,0x71,0x14,0x32,0x81,0x91,0xa1,0x08,
        0x23,0x42,0xb1,0xc1,0x15,0x52,0xd1,0xf0,0x24,0x33,0x62,0x72,0x82,0x09,0x0a,0x16,
        0x17,0x18,0x19,0x1a,0x25,0x26,0x27,0x28,0x29,0x2a,0x34,0x35,0x36,0x37,0x38,0x39,
        0x3a,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
        0x5a,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
        0x7a,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x92,0x93,0x94,0x95,0x96,0x97,0x98,
        0x99,0x9a,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xb2,0xb3,0xb4,0xb5,0xb6,
        0xb7,0xb8,0xb9,0xba,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xd2,0xd3,0xd4,
        0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,
        0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xff,0xda,0x00,0x08,0x01,0x01,
        0x00,0x00,0x3f,0x00,0xef,0xb7,0x1f,0x53,0x40,0x27,0x1d,0x4d,0x21,0x63,0xea,0x68,
        0xdc,0x7d,0x4d,0x1b,0x8e,0x3a,0x9f,0xce,0x97,0x27,0xd4,0xd1,0x96,0x1d,0xcd,0x1b,
        0x8f,0xf7,0x8f,0xe7,0x4d,0x33,0x28,0x20,0x17,0xe4,0xf4,0xe7,0xad,0x29,0x93,0x03,
        0x3b,0xbf,0x5a,0x6a,0x4e,0xaf,0xc2,0x3e,0x48,0xeb,0xcd,0x3b,0x71,0xf5,0x34,0x9b,
        0x9b,0xd4,0xfe,0x74,0x6e,0x6f,0xef,0x1f,0xce,0x93,0x73,0x7f,0x78,0xfe,0x74,0xbb,
        0x9b,0xfb,0xc7,0xf3,0xa3,0x73,0x7a,0x9f,0xce,0x8d,0xcd,0xea,0x7f,0x3a,0x5c,0x52,
        0xd2,0x1c,0x51,0x49,0x50,0x5e,0x5e,0xc1,0x65,0x03,0x4d,0x71,0x22,0xa2,0x0e,0xe4,
        0xf5,0xae,0x43,0x53,0xf1,0xb3,0x07,0x2b,0x64,0x17,0x68,0xfe,0x22,0xbc,0xd6,0x63,
        0xf8,0xc2,0x69,0xa1,0x6f,0x38,0xb3,0x48,0x3e,0xee,0x0e,0xd5,0x3f,0x50,0x2b,0x22,
        0x2d,0x4d,0x9a,0xe9,0x66,0x9a,0x67,0xce,0x79,0x24,0x9e,0x05,0x5e,0xff,0x00,0x84,
        0xa2,0xee,0x30,0xf1,0x45,0x71,0x21,0x4c,0xf0,0x5b,0xe6,0xc0,0xfc,0x6a,0xb4,0x7a,
        0xe5,0xdc,0x13,0x89,0xa1,0xb8,0x90,0x3f,0x76,0xdd,0x9c,0xfd,0x6b,0x66,0xc3,0xc6,
        0xf7,0xb1,0x95,0xfb,0x4a,0x24,0xeb,0xf4,0xda,0x7f,0x4a,0xea,0xec,0x7c,0x43,0x65,
        0x79,0x66,0x6e,0x43,0x98,0xd5,0x78,0x60,0xdd,0x45,0x69,0xc7,0x22,0x4a,0x81,0xd1,
        0x83,0x2b,0x0c,0x82,0x3a,0x53,0xbb,0xd2,0xd1,0x45,0x3e,0x90,0xd1,0x4c,0x92,0x44,
        0x89,0x0b,0xc8,0xc1,0x54,0x72,0x49,0x38,0x02,0xb9,0x6d,0x73,0xc6,0x50,0x5a,0x86,
        0x8f,0x4f,0x2b,0x34,0x9f,0xdf,0x3f,0x74,0x7f,0x8d,0x70,0xfa,0x86,0xb3,0x79,0xa8,
        0x49,0xbe,0xe6,0x56,0x90,0xe3,0x8c,0xf1,0x8f,0xa0,0xaa,0x04,0x92,0x73,0xed,0xd6,
        0x98,0x84,0x9c,0x82,0x08,0xfa,0x8a,0x52,0x0e,0xdf,0x9b,0x39,0xc7,0x6a,0x01,0xc1,
        0xc1,0xa5,0xc7,0x39,0xa7,0x27,0xde,0x1c,0xfe,0x35,0x37,0x99,0x22,0x70,0x84,0xf2,
        0x7a,0x7a,0xd7,0x55,0xe1,0xcf,0x13,0xfd,0x8a,0x18,0xed,0xee,0x81,0x68,0x87,0x1b,
        0x81,0xc9,0x1c,0xd7,0x77,0x0c,0xa9,0x34,0x6b,0x24,0x6c,0x19,0x18,0x64,0x11,0xdc,
        0x54,0x94,0xb4,0x53,0xe9,0x0d,0x35,0x98,0x2a,0x92,0x48,0x00,0x57,0x0d,0xe2,0xcf,
        0x11,0x8b,0x82,0xd6,0x76,0x8d,0xfb,0xb5,0xce,0xe7,0xcf,0xde,0xfa,0x57,0x10,0xec,
        0x4b,0x1f,0x9b,0x23,0xb6,0x6a,0x12,0xc7,0xa8,0xe0,0x91,0xf9,0xd3,0xfe,0xf0,0xf6,
        0xef,0x49,0xef,0x9c,0x67,0x81,0x4e,0xed,0x9e,0xde,0xd4,0x80,0xe4,0xe7,0x1f,0x86,
        0x29,0x73,0xf3,0x01,0xc9,0xfa,0x53,0xd4,0xed,0x56,0x1d,0x0d,0x2a,0xc8,0x3a,0xb0,
        0xfd,0x29,0xe0,0xb0,0x60,0x41,0xf9,0x4d,0x77,0x9e,0x0e,0xd7,0x61,0x92,0x04,0xb0,
        0x95,0xb6,0xc8,0xbc,0x26,0x7f,0x88,0x7a,0x57,0x5a,0x29,0x45,0x2d,0x3e,0x83,0xd2,
        0xb9,0xdf,0x17,0xea,0xa2,0xc2,0xc7,0xca,0x5e,0x64,0x94,0x10,0x3d,0x87,0x15,0xe6,
        0x13,0xca,0x64,0x6c,0xf3,0x51,0x06,0xcf,0xe1,0x48,0xab,0xf7,0x48,0xcf,0x4a,0x7e,
        0xd2,0x07,0x20,0xfb,0x71,0x46,0xd3,0xd7,0x69,0xfc,0x05,0x4d,0x15,0xb3,0xbf,0x62,
        0x2a,0xd2,0xe9,0x72,0x75,0xd8,0xde,0xb4,0xf8,0xb4,0x79,0x09,0x04,0xa9,0xab,0xd1,
        0xe8,0x99,0x18,0x7c,0xe3,0xda,0xa9,0x5f,0x68,0xb2,0x43,0x97,0x8c,0x31,0x51,0xc9,
        0xac,0xe4,0xc2,0xfc,0xaf,0x91,0x83,0xc8,0x3d,0x2a,0xdd,0xb4,0xa6,0x0b,0x88,0xe4,
        0x8c,0x72,0x8c,0x18,0x57,0xaa,0x68,0xf7,0xdf,0xda,0x1a,0x7c,0x77,0x18,0x0a,0x5b,
        0xa8,0x07,0x38,0x35,0x7e,0x83,0x4f,0x34,0x86,0xbc,0xe3,0xc7,0x77,0x7e,0x6e,0xaa,
        0x63,0xce,0x44,0x48,0x17,0x19,0xee,0x79,0xff,0x00,0x0a,0xe4,0x58,0x74,0x1e,0xbd,
        0xea,0x6b,0x3b,0x63,0x2b,0xe4,0xfd,0xd1,0x5a,0x49,0x6a,0xbd,0x00,0xab,0x09,0x64,
        0x8f,0x8c,0x8a,0xb3,0x1d,0x8c,0x4b,0xc6,0xd1,0xcd,0x5d,0x86,0xd2,0x15,0x1c,0x20,
        0xab,0xab,0x12,0x6d,0xe1,0x45,0x3b,0xcb,0x52,0x06,0x45,0x28,0x40,0x3a,0x52,0x94,
        0x5c,0x1c,0x8e,0xbe,0xd5,0xcb,0xf8,0x8b,0x4e,0x11,0x11,0x3c,0x6b,0x85,0x6e,0x08,
        0xf4,0x35,0x8e,0x8d,0xb4,0x6d,0x39,0x1c,0xf7,0xae,0xdb,0xc0,0x97,0xa5,0x7c,0xcb,
        0x3c,0x65,0x4b,0x6f,0x07,0xd3,0x80,0x3f,0xa5,0x76,0xa0,0xd2,0xe6,0x9e,0x45,0x43,
        0x77,0x3a,0x5b,0x5b,0x49,0x34,0x87,0x0a,0x8a,0x58,0xd7,0x8f,0xea,0xf7,0x4f,0x7f,
        0x7d,0x2d,0xc3,0x8e,0x59,0x8b,0x7d,0x2a,0x8e,0x32,0x45,0x6d,0xda,0x5b,0x88,0x2d,
        0x97,0xfb,0xc7,0xad,0x4a,0x0f,0x39,0xab,0x90,0x01,0xe9,0x56,0xd1,0x01,0xc7,0x15,
        0x32,0x29,0xcf,0xd6,0xac,0x01,0x81,0x40,0xcd,0x4b,0x1a,0x9c,0x50,0xca,0x73,0xd2,
        0xaa,0xde,0xdb,0x8b,0x8b,0x77,0x8d,0x86,0x43,0x0c,0x57,0x13,0x2c,0x5e,0x59,0x78,
        0xd8,0x1f,0x94,0x91,0x5b,0x7e,0x11,0x9f,0xca,0xd6,0xe1,0xeb,0x87,0xca,0xf1,0xf4,
        0xaf,0x4b,0x5e,0x94,0xb5,0x2d,0x64,0x78,0xa0,0xb8,0xd0,0xae,0x76,0x0c,0x9d,0xbd,
        0xbe,0xb5,0xe4,0x93,0xb9,0x32,0x1e,0xb4,0xfb,0x38,0xfc,0xc9,0xd7,0x3e,0xb5,0xbd,
        0x20,0xc4,0x6b,0x51,0x01,0xf3,0x55,0xc8,0x3a,0x8a,0xbc,0x8c,0x05,0x4e,0x87,0x8e,
        0x95,0x20,0xa9,0x11,0x38,0xe6,0xad,0x46,0xa0,0x20,0xe2,0x99,0x22,0xe4,0xe4,0x54,
        0x12,0x8c,0x57,0x27,0xaf,0x40,0x12,0xe9,0x9c,0x0e,0x1f,0x9a,0xbb,0xe0,0xcb,0x65,
        0x9f,0x54,0x0d,0x92,0x0c,0x5f,0x30,0xc5,0x7a,0x3a,0xf4,0x14,0xa6,0xa4,0x35,0x5e,
        0xf6,0x05,0xb8,0xb3,0x96,0x17,0xfb,0xae,0x85,0x4f,0xe3,0x5e,0x33,0x79,0x16,0xcb,
        0x86,0x5c,0xfd,0xd2,0x47,0x27,0xd2,0xac,0xe9,0x89,0x99,0x46,0x79,0xad,0x67,0xfe,
        0x55,0x08,0x38,0x3c,0x55,0x98,0x4e,0x0e,0x4f,0x5a,0xb6,0x8f,0x93,0xc1,0xab,0x50,
        0xb5,0x4e,0x32,0x79,0xa9,0xd0,0x00,0xa3,0x26,0xa7,0x0c,0x36,0x8e,0x45,0x34,0xbf,
        0x18,0xa8,0x66,0xae,0x6b,0x5e,0x4c,0x9c,0x9f,0xc2,0xac,0xf8,0x11,0x5b,0xfb,0x56,
        0x5e,0x3e,0x51,0x1f,0x27,0xdf,0x35,0xe8,0x42,0x97,0xf0,0xa9,0x31,0x4d,0x71,0x95,
        0x22,0xbc,0x77,0x56,0xb6,0x31,0xea,0x33,0xc4,0xeb,0x82,0x92,0x15,0xc7,0xe3,0x52,
        0x69,0xaa,0x03,0xf4,0xe6,0xb4,0x25,0x1c,0x1c,0x55,0x60,0xd9,0x38,0xc5,0x4f,0x19,
        0x27,0x8e,0x6a,0xe4,0x23,0x91,0x57,0x61,0x4e,0x2a,0xc2,0x8e,0xd5,0x2c,0x63,0x24,
        0x62,0xac,0xf9,0x5c,0x53,0x19,0x48,0x15,0x13,0xf3,0xda,0xb0,0x75,0xe8,0xb3,0x16,
        0xf1,0xd0,0x75,0xab,0x5e,0x03,0x1f,0xe9,0x37,0x27,0x1d,0x94,0x7f,0x3a,0xee,0x96,
        0x9d,0x8a,0x92,0x90,0xf4,0xae,0x07,0xc7,0xb6,0x2b,0x0d,0xec,0x57,0x51,0xae,0x3c,
        0xe0,0x43,0x9f,0x71,0x8f,0xe9,0xfc,0xab,0x03,0x4d,0x19,0x63,0xed,0x57,0x66,0xe1,
        0x32,0x6a,0xbe,0x40,0x1c,0xd2,0xad,0xc2,0x8c,0x62,0xaf,0x5b,0x4c,0xad,0x5a,0x30,
        0x38,0x3f,0x95,0x58,0x89,0xb3,0xd7,0xbd,0x3a,0x39,0x02,0x0c,0x93,0xd2,0x89,0x75,
        0x58,0x61,0xe1,0xe4,0x51,0x55,0x1b,0x5d,0x80,0x92,0x00,0x63,0xee,0x2a,0x44,0xd4,
        0xa1,0x94,0x60,0xe5,0x73,0xdc,0xd5,0x7d,0x4a,0x35,0x96,0xce,0x50,0x39,0x18,0xaa,
        0xfe,0x0f,0x96,0x5b,0x79,0x27,0x75,0x00,0xa1,0x20,0x1c,0xd7,0xa0,0x2f,0x23,0x34,
        0xec,0x54,0x94,0xd6,0x38,0x04,0xfa,0x57,0x9f,0xf8,0x87,0x52,0x9a,0xfd,0x19,0x1b,
        0x63,0x44,0xa4,0x95,0xda,0x39,0x15,0x8b,0xa6,0x8c,0x33,0xd4,0xd7,0x72,0xec,0x4c,
        0x01,0x96,0xac,0xc1,0xe6,0x39,0x07,0x9f,0xc2,0xac,0x08,0x26,0xd9,0xbf,0x63,0x74,
        0xa8,0x16,0xe6,0x68,0x9b,0x90,0x54,0xe7,0xb5,0x69,0x5a,0x6a,0x7c,0x61,0xf8,0x35,
        0xb3,0x63,0x2f,0xda,0x53,0xe5,0xea,0x47,0x14,0xcb,0x85,0x96,0x33,0xc8,0x38,0xf5,
        0xac,0x1b,0xa5,0x8c,0xca,0xde,0x6d,0xc0,0x5e,0x79,0xef,0x53,0xdb,0x43,0x60,0x40,
        0x26,0xe8,0xe0,0xf7,0xce,0x2b,0x5a,0x2b,0x4b,0x79,0x50,0x18,0xa5,0xdc,0x31,0xc7,
        0x39,0xab,0x09,0x01,0x5b,0x73,0x1e,0x73,0xc6,0x39,0xa8,0xf4,0x88,0x19,0x2c,0x94,
        0x01,0x8c,0xcb,0xd2,0xbb,0x78,0xc7,0xca,0x29,0xe6,0xa4,0x34,0xd6,0x19,0x04,0x57,
        0x9d,0x6a,0x16,0x8d,0x65,0x79,0x3c,0x2c,0x38,0x56,0xe3,0x3d,0xc7,0x6a,0xa3,0x6d,
        0x0f,0x96,0xae,0xff,0x00,0xde,0x3c,0x55,0x79,0xce,0x5b,0x9a,0xaa,0xf3,0x49,0xbb,
        0x10,0x8c,0x7b,0xe2,0x89,0x92,0xee,0x52,0x82,0x39,0x1c,0x8e,0xe3,0x9a,0x8b,0x50,
        0xb6,0xf2,0x82,0xb0,0x0d,0x90,0x3e,0x62,0xde,0xb4,0xdb,0x30,0xe4,0x8c,0xf3,0x9a,
        0xeb,0xf4,0x80,0x23,0x55,0xc5,0x68,0xde,0x45,0xbd,0x36,0x8e,0xe2,0xb9,0xd9,0xb4,
        0xa6,0x69,0x18,0x6c,0x1f,0x37,0xb5,0x5b,0xd3,0x74,0x6f,0xb3,0x02,0x40,0x4c,0xbf,
        0x04,0x91,0xc8,0x1e,0xd5,0xa1,0x0e,0x8f,0x0c,0x27,0x74,0x43,0x61,0xf6,0xe2,0xa7,
        0x75,0x0a,0x98,0x1d,0xaa,0x7d,0x38,0x89,0x24,0x54,0xc0,0xe1,0x85,0x74,0x6a,0x38,
        0xa5,0xa9,0x29,0x2b,0x95,0xf1,0xad,0xb1,0x10,0x25,0xd2,0x0e,0x9f,0x2b,0x1f,0xe5,
        0x5c,0xb5,0xa2,0xb0,0xb6,0xc9,0xe7,0x24,0x9a,0x86,0x54,0x25,0xaa,0x5b,0x7b,0x75,
        0x3d,0x45,0x5d,0xd9,0xe5,0xa7,0x1c,0x56,0x56,0xa0,0x9b,0x8e,0xe2,0x6a,0x2b,0x64,
        0x0a,0x33,0xc5,0x6f,0x69,0x6c,0x4e,0x0d,0x6c,0x06,0x27,0x19,0xa7,0xaa,0x2b,0x8e,
        0x45,0x38,0x7c,0x84,0x00,0x72,0x2a,0x6d,0xc0,0xa9,0xe9,0x54,0xe6,0x04,0x66,0xa5,
        0xd2,0x57,0x17,0x41,0xbd,0x5a,0xba,0x31,0xd2,0x96,0xa4,0xa2,0xa8,0x6b,0x36,0xa2,
        0xef,0x4d,0x9a,0x22,0x32,0x4a,0xe4,0x7d,0x47,0x35,0xc2,0x34,0x5e,0x48,0x28,0x01,
        0xf9,0x6a,0x9c,0xa7,0x9a,0x92,0x27,0xc7,0x41,0x56,0x0b,0x65,0x79,0x15,0x99,0xa8,
        0x49,0x8e,0x05,0x45,0x6c,0x0b,0x46,0x0e,0x38,0x35,0xbb,0xa5,0x83,0xc7,0x6a,0xda,
        0xda,0xc0,0x00,0x47,0x38,0xa6,0x24,0x85,0x58,0xa9,0xa9,0x43,0x67,0x1c,0x54,0x84,
        0x9c,0x55,0x79,0x8e,0x41,0xab,0x3a,0x52,0xfe,0xf6,0x3f,0xa9,0xad,0xf1,0xd2,0x96,
        0xa4,0xa2,0x9a,0xe3,0x2b,0x5c,0x1e,0xa7,0x6e,0xf6,0xf7,0xb3,0x46,0xe3,0xa1,0xc8,
        0x3e,0xa2,0xb2,0x26,0xe0,0xe2,0x92,0x16,0x19,0xe4,0x54,0xcf,0x26,0x13,0xde,0xb1,
        0xae,0xdc,0xb4,0x84,0x9e,0xb4,0xf8,0x2e,0x56,0x28,0xb6,0xbf,0x51,0xd3,0x15,0xab,
        0xa6,0x5f,0x8c,0x81,0xd3,0xd8,0xd6,0xc4,0x77,0xce,0xf2,0xaa,0x24,0x4c,0xcb,0x8e,
        0x5b,0x3d,0x2a,0xcc,0x88,0x4e,0x1d,0x7a,0x8e,0xa2,0x9f,0x1b,0x03,0x8c,0xd4,0xdb,
        0xb2,0x3d,0xaa,0x07,0xe8,0x7d,0xeb,0x67,0x4d,0xb2,0x68,0x40,0x79,0x46,0x1b,0xa0,
        0x1e,0x95,0xa3,0x45,0x49,0x45,0x21,0xe9,0x59,0xfa,0xd5,0x94,0x77,0x36,0x32,0x12,
        0x80,0xc8,0x8a,0x4a,0xb6,0x39,0xe3,0x9a,0xf3,0xcb,0xd4,0xfd,0xe1,0xf4,0xcd,0x45,
        0x08,0xc3,0x63,0x35,0x63,0x03,0x93,0xda,0xb3,0xae,0x10,0x34,0x99,0xc5,0x42,0xd0,
        0x16,0xfb,0xa3,0x35,0xa0,0x60,0xf2,0xad,0xad,0x9b,0x67,0xcd,0xbf,0x9a,0xdf,0x80,
        0x1f,0x2c,0x3e,0x31,0x9a,0xb0,0x92,0x76,0xcf,0x34,0xe2,0x0e,0xef,0x6a,0x7a,0xb7,
        0x6a,0x58,0xb0,0xf7,0x31,0x2f,0x62,0xe3,0xf9,0xd7,0x4c,0x29,0x68,0xa9,0x28,0xa2,
        0x91,0x86,0x54,0x83,0x5e,0x71,0xac,0xc1,0xe4,0x5d,0x48,0x98,0xfb,0xac,0x46,0x6b,
        0x35,0x0e,0xd6,0xfa,0x55,0x98,0x81,0x94,0x63,0xa5,0x50,0xbf,0x63,0x0c,0x81,0x23,
        0x5c,0x9c,0x75,0x27,0x8a,0x2d,0x3c,0xd7,0x61,0xf3,0x28,0x1e,0xc3,0x35,0xad,0x14,
        0x72,0x91,0x83,0x20,0x23,0xd0,0x8a,0xbb,0x6f,0x14,0xac,0xbc,0x4d,0x8f,0x6c,0x54,
        0xa6,0xd6,0x70,0xa4,0xf9,0xab,0x9e,0xdc,0x53,0x2d,0xee,0x25,0x2d,0xe5,0xcc,0x9b,
        0x58,0x1c,0x67,0xb5,0x5c,0x1c,0x55,0xad,0x2d,0x0c,0xba,0x82,0x7a,0x20,0xdc,0x6b,
        0xa1,0xc5,0x18,0xa5,0xc5,0x3e,0x8a,0x28,0xae,0x17,0xc4,0x80,0x7f,0x6a,0x4e,0x98,
        0xf4,0x23,0xf2,0xae,0x6e,0x53,0xb5,0xbd,0xe9,0xf0,0xdc,0x79,0x6a,0x79,0xa8,0x1e,
        0x60,0xec,0x4b,0x0a,0xb5,0x14,0x71,0x85,0xdd,0xd2,0x9f,0x1c,0x25,0xe4,0x3e,0x59,
        0x20,0x7a,0xe6,0xb4,0xec,0x2d,0xda,0x2e,0xa4,0x90,0x4d,0x69,0x6f,0x00,0x73,0x50,
        0x4a,0xeb,0xb8,0x71,0x4f,0x57,0x3b,0x79,0xad,0xfd,0x12,0xdc,0xc7,0x6f,0xe6,0xb8,
        0xc3,0x4b,0xc8,0xfa,0x76,0xad,0x2a,0x29,0x4d,0x3a,0x8a,0x28,0xae,0x13,0xc5,0x87,
        0x6e,0xad,0x2f,0xd0,0x7f,0x21,0x5c,0xe4,0xc3,0x77,0x3d,0xea,0xb4,0x84,0x80,0x00,
        0xe2,0xa3,0x1c,0x74,0xab,0x91,0xc8,0x4a,0x81,0xd8,0xd6,0x9d,0x9a,0xf1,0x5a,0xd1,
        0xa9,0x28,0x0f,0xa5,0x2b,0x70,0x2a,0xbc,0xd2,0x63,0xfc,0x6a,0xe6,0x93,0x00,0xbd,
        0xbc,0x58,0xcf,0xdc,0x03,0x73,0x7b,0x8f,0x4a,0xeb,0x40,0x00,0x01,0x4b,0x4b,0x8a,
        0x52,0x29,0x68,0xa2,0xa8,0xdf,0xeb,0x16,0x36,0x1c,0x4f,0x3a,0x87,0xec,0x8b,0xcb,
        0x7e,0x55,0xc3,0xeb,0xf7,0xa9,0x7d,0x7c,0xf3,0xc6,0x0a,0xab,0x63,0x01,0xba,0xf1,
        0x58,0x8e,0xc7,0xad,0x46,0xdf,0x31,0xeb,0x8a,0x61,0x4e,0xc3,0xb5,0x3e,0x16,0x28,
        0x70,0xdd,0xab,0x5e,0xde,0x55,0x2a,0x0a,0xd5,0xd8,0xef,0x55,0x17,0x19,0xc7,0xd6,
        0xa3,0x6b,0xe5,0x3c,0x2b,0x64,0xf6,0x02,0x9d,0x14,0x0f,0x33,0x6e,0x90,0x91,0xed,
        0x5d,0x17,0x87,0xa2,0x0b,0x3c,0x8c,0x06,0x36,0xa8,0x1f,0x9f,0xff,0x00,0xaa,0xb7,
        0xf1,0x46,0x3f,0x9d,0x2d,0x2d,0x14,0xc9,0x65,0x8e,0x18,0xcb,0xca,0xe1,0x54,0x75,
        0x24,0xd7,0x27,0xe2,0x5f,0x14,0x14,0x8c,0xc1,0x60,0xc4,0x6e,0x1c,0xc9,0xd0,0xfe,
        0x15,0xc8,0x09,0x18,0xb6,0xf7,0x25,0x9d,0xba,0x92,0x6a,0x47,0x62,0xc3,0xf0,0xaa,
        0xce,0x0d,0x46,0x43,0x02,0x09,0xa5,0x0d,0x83,0xeb,0x4b,0x8d,0xdd,0x6a,0x68,0x97,
        0x8e,0x37,0x7b,0x55,0x88,0xe0,0x2e,0xc3,0x20,0xe3,0xeb,0x5a,0x56,0xd6,0xea,0x84,
        0x10,0x2a,0xfc,0x49,0xc5,0x58,0xb5,0xd5,0x93,0x4e,0xbd,0x10,0x90,0x09,0x98,0x64,
        0x03,0xed,0x5d,0x05,0xb6,0xa7,0x04,0xf8,0xc9,0xd8,0x7d,0x1a,0xad,0x87,0x56,0xfb,
        0xa4,0x1f,0xa5,0x28,0x34,0xb5,0x85,0x7d,0xe2,0x35,0x50,0x56,0xcd,0x37,0x7f,0xb6,
        0xdd,0x3f,0x01,0x5c,0xe6,0xa1,0x7b,0x3d,0xd7,0x32,0x3b,0x31,0x1e,0xa6,0xb1,0xef,
        0x54,0xc8,0xa1,0xfa,0xe3,0xad,0x54,0x1d,0x45,0x4a,0x32,0x47,0xad,0x28,0x8c,0xb0,
        0xe4,0x54,0x9f,0x66,0x27,0xb5,0x35,0xad,0x18,0x1e,0x99,0xa7,0x25,0xb1,0xc8,0xc8,
        0xab,0x91,0x41,0xc7,0xdd,0xab,0x31,0xc4,0x46,0x30,0x2a,0xe4,0x30,0xb1,0x23,0x3d,
        0x2a,0xd8,0x8f,0x0b,0x59,0x1a,0xcc,0x67,0x02,0x74,0x1f,0x3c,0x3c,0xfd,0x47,0x7a,
        0xd5,0xb7,0x93,0x7c,0x28,0xeb,0xfc,0x40,0x11,0x53,0xa4,0xa5,0x94,0x8c,0x91,0xcf,
        0x23,0x35,0xa1,0x6f,0xaa,0xb2,0x00,0x25,0x5d,0xc0,0x77,0xcf,0x35,0x75,0x75,0x1b,
        0x72,0xb9,0xdc,0x47,0xb1,0x15,0xca,0x3a,0x0e,0x40,0xe4,0x8f,0x4a,0xab,0x02,0x79,
        0x83,0x9e,0xf5,0x11,0xb6,0x01,0xd9,0x18,0x7c,0xad,0x54,0xa7,0xb0,0xdb,0xd0,0x73,
        0x55,0x52,0x22,0x1b,0x04,0x74,0xab,0x70,0xa5,0x5b,0x11,0xf1,0xd2,0x9f,0xe4,0x64,
        0x76,0xa7,0xac,0x38,0xea,0x2a,0xc4,0x51,0xae,0x2a,0xca,0x44,0xbe,0x95,0x3a,0xa7,
        0x1d,0x30,0x28,0x71,0xc1,0xaa,0x57,0x11,0x79,0x8a,0xea,0x47,0xde,0x52,0x29,0x34,
        0xd3,0xbb,0x4d,0x84,0xfa,0x0c,0x7f,0x4a,0xb0,0x4e,0xd9,0x33,0xd9,0xa9,0x09,0x23,
        0xe9,0x4f,0x59,0x06,0x28,0x8e,0xce,0xeb,0x39,0x36,0xd2,0x8c,0xff,0x00,0xb0,0x6a,
        0xbd,0xbd,0x85,0xdc,0x73,0x3a,0xfd,0x96,0x6d,0xb9,0xe0,0xf9,0x67,0x15,0x3c,0xba,
        0x7d,0xcb,0x0c,0x8b,0x69,0x73,0xfe,0xe1,0xa8,0xdf,0x4d,0xb9,0x74,0xff,0x00,0x8f,
        0x69,0x41,0xff,0x00,0xae,0x66,0xa8,0x49,0xa3,0xde,0x6f,0xc8,0xb4,0x9c,0xff,0x00,
        0xdb,0x33,0xfe,0x14,0xab,0xa5,0xde,0x81,0xff,0x00,0x1e,0x93,0xff,0x00,0xdf,0xb3,
        0xfe,0x15,0x3c,0x7a,0x7d,0xe6,0x39,0xb4,0x9c,0x7f,0xdb,0x33,0xfe,0x15,0x38,0xb0,
        0xba,0xc7,0xfc,0x7a,0xcd,0x9f,0xfa,0xe6,0x69,0xe2,0xc6,0xe7,0xbd,0xb4,0xdf,0xf7,
        0xc1,0xa9,0xa3,0xb2,0x9c,0x75,0xb6,0x93,0xfe,0xf8,0x35,0x38,0xb5,0x98,0x63,0xf7,
        0x12,0x7f,0xdf,0x06,0x94,0xdb,0x5c,0x7f,0xcf,0x19,0x3f,0xef,0x93,0x4d,0x6b,0x6b,
        0x83,0xff,0x00,0x2c,0x24,0xff,0x00,0xbe,0x0d,0x31,0xec,0xa7,0x11,0xb1,0x10,0x48,
        0x4e,0x0f,0x1b,0x0d,0x51,0xd2,0xec,0x6f,0x23,0xd3,0x15,0x1e,0xd6,0x65,0x61,0x9e,
        0x0c,0x64,0x1e,0xbf,0x4a,0xb6,0xd6,0x77,0x25,0x07,0xee,0x25,0xcf,0xfb,0x86,0x81,
        0x69,0x72,0xcb,0xcd,0xbc,0xbf,0xf7,0xc1,0xa8,0x8d,0x95,0xd0,0x24,0x7d,0x9a,0x53,
        0xff,0x00,0x00,0x35,0xff,0xd9,
};

static const unsigned char _photo_hashOk[] = {
        0x03,0xcc,0x6c,0x50,0x84,0x85,0x82,0x54,0xcc,0x72,0x3c,0xb4,0xe0,0x8e,0x45,0xa8,
		0x85,0x33,0x68,0x7a,
};

static const unsigned char _photo_hashKo[] = {
        0x03,0xcc,0x6c,0x50,0x84,0x85,0x82,0x54,0xcc,0x72,0x3c,0xb4,0xe0,0x8e,0x45,0xa8,
		0x85,0x33,0x68,0x7b,
};

static const unsigned char _checkSign[] = {
        0x01,0x0c,0x35,0x39,0x30,0x34,0x34,0x35,0x30,0x37,0x34,0x37,0x32,0x35,0x02,0x10,
        0x53,0x4c,0x49,0x4e,0x33,0x66,0x00,0x29,0x6c,0xff,0x26,0x23,0x66,0x0b,0x08,0x26,
        0x03,0x0a,0x32,0x34,0x2e,0x31,0x30,0x2e,0x32,0x30,0x30,0x36,0x04,0x0a,0x32,0x34,
        0x2e,0x31,0x30,0x2e,0x32,0x30,0x31,0x31,0x05,0x08,0x48,0x6f,0x6c,0x73,0x62,0x65,
        0x65,0x6b,0x06,0x0b,0x37,0x33,0x30,0x34,0x30,0x31,0x30,0x32,0x37,0x34,0x39,0x07,
        0x06,0x48,0x6f,0x65,0x62,0x65,0x6e,0x08,0x06,0x53,0x74,0x65,0x66,0x61,0x6e,0x09,
        0x00,0x0a,0x04,0x42,0x65,0x6c,0x67,0x0b,0x04,0x42,0x72,0x65,0x65,0x0c,0x0c,0x30,
        0x31,0x20,0x41,0x50,0x52,0x20,0x20,0x31,0x39,0x37,0x33,0x0d,0x01,0x4d,0x0e,0x00,
        0x0f,0x01,0x31,0x10,0x01,0x30,0x11,0x14,0x03,0xcc,0x6c,0x50,0x84,0x85,0x82,0x54,
        0xcc,0x72,0x3c,0xb4,0xe0,0x8e,0x45,0xa8,0x85,0x33,0x68,0x7a,
};

static const unsigned char _signOk[] = {
        0x3d,0x88,0x5c,0x02,0x01,0x24,0x2e,0xd0,0x6d,0x1a,0xe9,0x0c,0xf1,0xde,0x7e,0x75,
        0xe0,0x1e,0x6b,0x12,0x9c,0xa5,0x35,0x53,0xf4,0x79,0x4f,0xb3,0xea,0xc3,0x58,0x2a,
        0x67,0xc7,0xaa,0xf0,0x9d,0x75,0x68,0x75,0x45,0x0c,0xc1,0x59,0x1b,0x5b,0x20,0x7e,
        0xa2,0x6a,0x55,0x15,0xd5,0x40,0x25,0xf3,0x91,0x98,0x48,0x94,0xf8,0x51,0x4e,0xfb,
        0xdb,0x07,0x69,0xc5,0x86,0xd1,0x92,0x29,0xb9,0xf0,0x46,0x00,0xdc,0xad,0x28,0x1c,
        0x67,0x1a,0xb5,0x5e,0xa0,0xbb,0x0e,0xeb,0x7e,0xce,0x2c,0x57,0xbb,0xcf,0xc8,0x7b,
        0xb3,0xd2,0x19,0x6a,0x36,0x3b,0xb0,0xd7,0xa3,0x3f,0x52,0x46,0xd5,0x9d,0x85,0xda,
        0x9d,0xff,0x11,0x9a,0xa7,0x8e,0x25,0xa2,0x0d,0xa9,0x21,0x5a,0xee,0x96,0x93,0x65,
};

static const unsigned char _signKo[] = {
        0x3d,0x88,0x5c,0x02,0x01,0x24,0x2e,0xd0,0x6d,0x1a,0xe9,0x0c,0xf1,0xde,0x7e,0x75,
        0xe0,0x1e,0x6b,0x12,0x9c,0xa5,0x35,0x53,0xf4,0x79,0x4f,0xb3,0xea,0xc3,0x58,0x2a,
        0x67,0xc7,0xaa,0xf0,0x9d,0x75,0x68,0x75,0x45,0x0c,0xc1,0x59,0x1b,0x5b,0x20,0x7e,
        0xa2,0x6a,0x55,0x15,0xd5,0x40,0x25,0xf3,0x91,0x98,0x48,0x94,0xf8,0x51,0x4e,0xfb,
        0xdb,0x07,0x69,0xc5,0x86,0xd1,0x92,0x29,0xb9,0xf0,0x46,0x00,0xdc,0xad,0x28,0x1c,
        0x67,0x1a,0xb5,0x5e,0xa0,0xbb,0x0e,0xeb,0x7e,0xce,0x2c,0x57,0xbb,0xcf,0xc8,0x7b,
        0xb3,0xd2,0x19,0x6a,0x36,0x3b,0xb0,0xd7,0xa3,0x3f,0x52,0x46,0xd5,0x9d,0x85,0xda,
        0x9d,0xff,0x11,0x9a,0xa7,0x8e,0x25,0xa2,0x0d,0xa9,0x21,0x5a,0xee,0x96,0x93,0x66,
};

TEST(VerifyRoot)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();
	bool retOk, retKo;

	CByteArray rootOk(_rootOk,sizeof(_rootOk));
	retOk = cryptoFwk->VerifyRoot(rootOk); //Must return true
	CHECK(retOk);

	CByteArray rootKo(_rootKo,sizeof(_rootKo)); 
	retKo = cryptoFwk->VerifyRoot(rootKo); //Must return false (last byte is wrong)
	CHECK(!retKo);

}

TEST(VerifyOidRrn)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();
	bool retOk, retKo;

	CByteArray rrnOk(_rrnOk,sizeof(_rrnOk));
	retOk = cryptoFwk->VerifyOidRrn(rrnOk);	//Must return true
	CHECK(retOk);

	CByteArray rrnKo(_rootOk,sizeof(_rootOk));
	retKo = cryptoFwk->VerifyOidRrn(rrnKo);	 //Must return false (_root is not a rrn)
	CHECK(!retKo);

}

TEST(VerifyHashSha1)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();
	bool retOk, retKo;

	CByteArray photo(_photo,sizeof(_photo));

	CByteArray hashOk(_photo_hashOk,sizeof(_photo_hashOk));
	retOk = cryptoFwk->VerifyHashSha1(photo,hashOk);	//Must return true
	CHECK(retOk);

	CByteArray hashKo(_photo_hashKo,sizeof(_photo_hashKo));
	retKo = cryptoFwk->VerifyHashSha1(photo,hashKo); //Must return false (last byte is wrong)
	CHECK(!retKo);

}

TEST(VerifySignatureSha1)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();
	bool retOk,retKo1,retKo2,retKo3;

	CByteArray checkSign(_checkSign,sizeof(_checkSign));
	CByteArray rrnOk(_rrnOk,sizeof(_rrnOk));
	CByteArray rrnKo(_rootOk,sizeof(_rootOk));

	CByteArray signOk(_signOk,sizeof(_signOk));
	retOk = cryptoFwk->VerifySignatureSha1(checkSign,signOk,rrnOk);	//Must return true
	CHECK(retOk);

	CByteArray signKo(_signKo,sizeof(_signKo));
	retKo1 = cryptoFwk->VerifySignatureSha1(checkSign,signKo,rrnOk); //Must return false (last byte is wrong)
	CHECK(!retKo1);

	retKo2 = cryptoFwk->VerifySignatureSha1(checkSign,signOk,rrnKo); //Must return false (root is not rrn)
	CHECK(!retKo2);

	retKo3 = cryptoFwk->VerifySignatureSha1(checkSign,signKo,rrnKo); //Must return false (wrong sign + wrong cert)
	CHECK(!retKo3);

}
TEST(VerifyDateValidity)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();
	bool retOk;

	CByteArray rrnOk(_rrnOk,sizeof(_rrnOk));

	retOk = cryptoFwk->VerifyDateValidity(rrnOk);	//Must return true
	CHECK(retOk);
}

TEST(isSelfIssuer)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();
	bool retOk,retKo;

	CByteArray rrnOk(_rrnOk,sizeof(_rrnOk));
	CByteArray rootOk(_rootOk,sizeof(_rootOk));

	retOk = cryptoFwk->isSelfIssuer(rootOk);		//Must return true
	CHECK(retOk);

	retKo = cryptoFwk->isSelfIssuer(rrnOk);		//Must return false (rrn is not selfissuer)
	CHECK(!retKo);
}

TEST(isIssuer)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();
	bool retOk,retKo;

	CByteArray rrnOk(_rrnOk,sizeof(_rrnOk));
	CByteArray rootOk(_rootOk,sizeof(_rootOk));

	retOk = cryptoFwk->isIssuer(rrnOk,rootOk);		//Must return true
	CHECK(retOk);

	retKo = cryptoFwk->isIssuer(rootOk,rrnOk);		//Must return false (rrn is not the issuer of root)
	CHECK(!retKo);
}

TEST(OCSP)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();

	CByteArray root(_rootOk,sizeof(_rootOk));
	CByteArray ca(_ca,sizeof(_ca));
	CByteArray cert(_cert,sizeof(_cert));

	std::string url;

	cryptoFwk->GetOCSPUrl(cert,url);
	CHECK_EQUAL("http://ocsp.eid.belgium.be",url);

	FWK_CertifStatus status;
	
	status=cryptoFwk->OCSPValidation(cert,ca);
	CHECK_EQUAL(FWK_CERTIF_STATUS_VALID,status);

	status=cryptoFwk->OCSPValidation(root,root);
	CHECK_EQUAL(FWK_CERTIF_STATUS_VALID,status);
}

TEST(CRL)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();

	CByteArray root(_rootOk,sizeof(_rootOk));
	CByteArray ca(_ca,sizeof(_ca));
	CByteArray cert(_cert,sizeof(_cert));

	std::string url;

	cryptoFwk->GetCDPUrl(cert,url);
	CHECK_EQUAL("http://crl.eid.belgium.be/eidc200620.crl",url);
}

TEST(B64)
{
	APL_CryptoFwk *cryptoFwk=AppLayer.getCryptoFwk();

	CByteArray root(_rootOk,sizeof(_rootOk));
	CByteArray b64Encode;
	CByteArray b64Decode;

	CHECK_EQUAL(true,cryptoFwk->b64Encode(root,b64Encode));
	CHECK_EQUAL(true,cryptoFwk->b64Decode(b64Encode,b64Decode));

	CHECK_ARRAY_EQUAL(_rootOk,b64Decode.GetBytes(),sizeof(_rootOk));


	CHECK_EQUAL(true,cryptoFwk->b64Encode(root,b64Encode,false));
	CHECK_EQUAL(true,cryptoFwk->b64Decode(b64Encode,b64Decode));

	CHECK_ARRAY_EQUAL(_rootOk,b64Decode.GetBytes(),sizeof(_rootOk));
}
