# Copyright (C) 2002 Hewlett Packard
# Licensed under the GNU General Public License

# This is to be pulled into the API to define tests
# currently these only work for HP-UX

$GLOBAL_TEST{'AccountSecurity'}{'create_securetty'} = 
    sub { 
	# location of the securetty file
	my $securetty = &getGlobal('FILE',"securetty");
	# if the securetty file exists then
	if(-e $securetty) {
	    # if a console line is found then
	    if(&B_match_line($securetty,"\^\\s\*console\\s\*\$")) {
		# don't ask the question
		return 1;
	    }
	}
	
	# otherwise ask the question.
	return 0;
    };

$GLOBAL_TEST{'AccountSecurity'}{'hidepasswords'} =
    sub {
	# location of shadow password file
	my $shadow = &getGlobal('FILE','shadow');
	# if shadowed password file exists
	if( -e $shadow){
	    # don't ask the question
	    return 1;
	}

        return &isSystemTrusted;
    };

$GLOBAL_TEST{'AccountSecurity'}{'system_auditing'} =
    sub {
        if (&isSystemTrusted) {
           my $current_auditing = &B_get_rc("AUDITING"); 
           my $current_acct = &B_get_rc("START_ACCT");   

           if(($current_auditing =~ /1/) and ($current_acct =~ /1/)){
              return $SKIPQ;
           } else {
              return $ASKQ;
           }
        } else {
            return $ASKQ;
        }
    };

sub isSystemTrusted {
        # This is the same code as  &AccountSecurity::isSystemTrusted
        my $getprdef = &getGlobal('BIN',"getprdef");
        my $definition = `$getprdef -t 2>&1`;
        if($definition =~ "System is not trusted.") {
          return 0;
        } else {
          return 1;
        }
};

$GLOBAL_TEST{'AccountSecurity'}{'single_user_password'} = 
  sub { 
    if (&GetDistro =~ "^HP-UX11.(.*)" and $1<23) {
      my $getprdef = &getGlobal('BIN',"getprdef");
      my $bootpw = `$getprdef -m bootpw 2>&1`;
      if($bootpw !~ "bootpw=YES") {
	  return $ASKQ;
      }
      else {
	  return $SKIPQ;
      }
    } else {
	# location of system default security file.
	my $defaultSecurity = &getGlobal('FILE',"security");
	# if the BOOT_AUTH variable is set to 1 in the default
	# security file then.
	if(&B_match_line($defaultSecurity, '^\s*BOOT_AUTH\s*=\s*1')) {
	    # do not ask the question
	    return $SKIPQ;
	}
	# otherwise ask the question
	return $ASKQ;
    }
  };

foreach my $param ("ABORT_LOGIN_ON_MISSING_HOMEDIR", "NOLOGIN", ) {
  $GLOBAL_TEST{'AccountSecurity'}{$param} = 
     sub { 
	my $defaultSecurity = &getGlobal('FILE',"security");
	if(&B_match_line($defaultSecurity, "^\\s*$param\\s*=\\s*1")) {
	    return $SKIPQ;
	} else {
	    return $ASKQ;
	}
     };
}

1;
