/***************************************************************************
 *   Copyright (C) 2005 by Bjorn Hansen                                    *
 *   holomorph@users.sourceforge.net                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../../include/menu/maplistmodel.h"
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

using namespace Balder;

MapListModel::MapListModel(): numMaps(0)
{
	FindMaps();
}
MapListModel::~MapListModel()
{}

bool find_file( const boost::filesystem::path & dir_path, const std::string & file_name)
{
  if ( !exists( dir_path ) ) return false;
  boost::filesystem::directory_iterator end_itr; // default construction yields past-the-end
  for ( boost::filesystem::directory_iterator itr( dir_path );
        itr != end_itr;
        ++itr )
  {
    if ( is_directory( *itr ) )
    {
      if ( find_file( *itr, file_name ) ) return true;
    }
    else if ( itr->leaf() == file_name ) // see below
    {
      return true;
    }
  }
  return false;
}

void MapListModel::FindMaps()
{
	boost::filesystem::path map_path( "maps/" );
	boost::filesystem::directory_iterator end_iter;
    for ( boost::filesystem::directory_iterator dir_itr( map_path );
          dir_itr != end_iter;
          ++dir_itr )
    {
        if ( boost::filesystem::is_directory( *dir_itr ) ) {
        	// lets try to check that this directory really contains a map
       		if (find_file(*dir_itr, "maptags.xml") 
       			&& find_file(*dir_itr, "geometry.png")
       			&& find_file(*dir_itr, "background.png") ) {
       				mapnames.push_back(dir_itr->leaf());
       				++numMaps;
       			}
        }
    }
}


/*!
    \fn Balder::MapListModel::FindMapIndex(std::string mapname)
 */
int Balder::MapListModel::FindMapIndex(std::string mapname)
{
    for (int i = 0; i < numMaps; ++i) {
    	if (!mapname.compare(mapnames[i])) return i;
    }
    return 0;
}
