# -*- coding: latin-1 -*-
# Balazar
# Copyright (C) 2003-2005 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import tofu, soya, soya.tofu4soya

import balazar, balazar.base as base, balazar.character as character, balazar.vegetation as vegetation, balazar.building as building
from balazar.character  import _P, _V, _P2, _V2
from balazar.npc        import Monster
from balazar.vegetation import Mushroom

class Level(soya.tofu4soya.Level):
  push_down_level = -10.0
  step_level      = -10.0
  nb_max_mushroom = 20
  
  def __init__(self):
    soya.tofu4soya.Level.__init__(self)
    self.random_monsters      = []
    self.random_monster_proba = 0.05
    self.nb_max_monster       = 3
    self.nb_monster           = 0
    self.nb_mushroom          = 0
    self.camera_can_pass_through = []
    
    self.wind                 = 0
    
  def get_country(self):
    for country in COUNTRIES.values():
      if (country.X1 <= self.X <= country.X2) and (country.Z1 <= self.Z <= country.Z2): return country
    return COUNTRIES["landes"]
  
  def __repr__(self): return "<Level %s, %s>" % (self.X, self.Z)
  
  def get_by_pos(clazz, X, Z):
    try: level = tofu.Level.get("level_%s_%s" % (X, Z))
    except ValueError:
      print "* Balazar * Creating level %s, %s..." % (X, Z)
      from balazar.level_gen import UNIVERSE
      level = UNIVERSE.create_level(X, Z)
    return level
  get_by_pos = classmethod(get_by_pos)
  
  def add_mobile(self, mobile):
    if isinstance(mobile, Monster ): self.nb_monster  += 1
    if isinstance(mobile, Mushroom): self.nb_mushroom += 1
    soya.tofu4soya.Level.add_mobile(self, mobile)
    
  def remove_mobile(self, mobile):
    if isinstance(mobile, Monster ): self.nb_monster  -= 1
    if isinstance(mobile, Mushroom): self.nb_mushroom -= 1
    soya.tofu4soya.Level.remove_mobile(self, mobile)
    
  def begin_round(self):
    soya.tofu4soya.Level.begin_round(self)
    
    self.weather_agent.begin_round()
    
  def big_round(self):
    for child in self.children:
      if hasattr(child, "big_round"): child.big_round()
    
    self.weather_agent.big_round()

  def get_by_class(self, Class):
    for i in self:
      if isinstance(i, Class): return i

  def get_all_by_class(self, Class):
    return [i for i in self if isinstance(i, Class)]
      

class Bridge(soya.Volume, base.SensitiveFloor):
  map_color = 255, 255, 255, 255
  
  def __init__(self, parent = None, dX = 0, dZ = 0):
    soya.Volume.__init__(self, parent, soya.Shape.get("pont1"))
    
    self.dX = dX
    self.dZ = dZ
    
  def character_on(self, character):
    if (not character.bot) and (character.life > 0.0):
      _P.clone(character)
      _P.convert_to(self)
      if _P.x < -BRIDGE_DEMI_DIM:
        def plan_change_level():
          old_level = character.level
          new_level = character.level.get_by_pos(old_level.X + self.dX, old_level.Z + self.dZ)
          other_bridge = getattr(new_level, "bridge_%s_%s" % (1 - self.dX, 1 - self.dZ))
          
          old_level.remove_mobile(character)
          new_level.add_mobile   (character)
          
          character.y += -self.y + other_bridge.y
          
          _P.__init__(other_bridge, -BRIDGE_DEMI_DIM + 1.0, 16.0, 0.0)
          _P.convert_to(new_level)
          if self.dX: character.x = _P.x
          if self.dZ: character.z = _P.z
          
          character.last_ground.clone(character)
          character.on_ground = 1 # Disable mobile platform correction
          character.current_deplacement = balazar.character.ACTION_WAIT
          character.zap()
          
          if tofu.GAME_INTERFACE:
            tofu.GAME_INTERFACE.camera.zap()
            if not character.controller.remote: character.advertise_country()
            
          tofu.Player.get(character.player_name).save_pos()
          
        soya.IDLER.next_round_tasks.append(plan_change_level)
  


LAND_SIZE  = 65
LAND_SCALE = 2.5
LAND_DIM   = LAND_SCALE * LAND_SIZE

BRIDGE_DEMI_DIM = 27.5

LEVEL_DIM = LAND_DIM + 2 * BRIDGE_DEMI_DIM





def create_test_level():
  level = Level()
  level_static = soya.World(level)
  
  grass  = soya.Material.get("grass")
  ground = soya.Material.get("ground")
  snow   = soya.Material.get("snow")
  
  land = soya.Land(level_static)
  land.y = -35.0
  land.from_image(soya.Image.get("map.png"))
  
  land.multiply_height(50.0)
  
  land.map_size = 8
  land.scale_factor = 1.5
  land.texture_factor = 1.0
  
  land.set_material_layer(grass,   0.0,  15.0)
  land.set_material_layer(ground, 15.0,  25.0)
  land.set_material_layer(snow,   25.0,  50.0)
  
  house = soya.Shape.get("ferme")

  house1 = soya.Volume(level_static, house)
  house1.set_xyz(250.0, -7.2, 182.0)
  
  house2 = soya.Volume(level_static, house)
  house2.set_xyz(216.0, -11.25, 200.0)
  house2.rotate_lateral(100.0) # degrees
  
  sun = soya.Light(level_static)
  sun.directional = 1
  sun.diffuse = (1.0, 0.8, 0.4, 1.0)
  sun.rotate_vertical(-45.0)
  
  import balazar.weather
  weather = level.weather_agent = balazar.weather.WeatherAgent()
  level.add_mobile(weather)
  
  #from balazar.hero import *
  #bot = Balazar()
  #bot.set_xyz(218.160568237, -3.0, 213.817764282)
  #bot.bot = 1
  #level.add_mobile(bot)
  
  #from balazar.vegetation import *
  #bot = Mushroom()
  #bot.set_xyz(218.160568237, -3.0, 213.817764282)
  #level.add_mobile(bot)
  
  #bot = TreePompon()
  #bot.set_xyz(218.160568237, -0.0, 213.817764282)
  #level.add_mobile(bot)
  
  bot = Fasme(8)
  bot.set_xyz(218.160568237, -7.0, 213.817764282)
  level.add_mobile(bot)
  bot.placed()
  
  level_static.filename = level.name = "level_tofudemo_static"
  level_static.save()
  level.filename = level.name = "level_tofudemo"
  level.save()
  
  return level


COUNTRIES = {}

class Country(object):
  def __init__(self, name, X1, Z1, X2, Z2, music):
    self.name  = name
    self.X1    = X1
    self.Z1    = Z1
    self.X2    = X2
    self.Z2    = Z2
    self.music = music
    COUNTRIES[name] = self

Country("foret_pompon",  1, -1,  4,  1, "oceane.ogg")
Country("village"     ,  0, -1,  0,  1, "oceane.ogg")
Country("montagne"    , -1, -4,  1, -2, "oceane.ogg")

#Country("landes"      , -9,  0,  0,  0, "oceane.ogg")
