<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    axyl-story-viewer.php                                   */
/* Author:      Paul Waite                                              */
/* Date:        June 2004                                               */
/* Description: Story viewer window. Used to display stories in a       */
/*              small popup window.                                     */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// -----------------------------------------------------------------------------------------------
// PAGE PARAMETERS
// $sid       -  Required. Story ID, int4, identifies story to show
// $mode      -  Optional. Page mode, text, determines action

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Viewer", "popup", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("story-defs.php");
include_once("form-defs.php");
include_once("button-defs.php");

//debug_on(DBG_TRACE|DBG_SQL|DBG_DIAGNOSTIC);

// -----------------------------------------------------------------------------------------------
// AUTHORISATION and SANITY CHECKS

if (!isset($story_id)) {
  $RESPONSE->send_errorcode_and_die(403);
}

// SHOW STORY..
$story = new story($story_id);
if (!$story->valid) {
  $RESPONSE->send_errorcode_and_die(404);
}
$RESPONSE->plugin("MAIN_CONTENT", $story->render());

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>