<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    utility-funcs.inc                                       */
/* Author:      Paul Waite                                              */
/* Description: Generic functions to support various Axyl scripts.      */
/*              Logging, datetimes, files..                             */
/*                                                                      */
/* ******************************************************************** */

define("ISO_DATABASE_FORMAT", "Y-m-d H:i:s");

function get_user_input() {
  global $STDIN;
  $ans = "";
  if (isset($STDIN) && $STDIN !== false) {
    $ans = rtrim(fgets($STDIN, 256));
  }
  return $ans;
}

function logit($msg) {
  global $LOG, $ECHO_LOGGING, $DEBUGMODE;
  if (isset($LOG) && $LOG !== false) {
    $msg_stamp = timestamp_to_displaydate(ISO_DATABASE_FORMAT, time());
    if (substr($msg, -1) != "\n") {
      $msg .= "\n";
    }
    $logmsg = "$msg_stamp: $msg";
    fwrite($LOG, $logmsg);
    if ($ECHO_LOGGING || $DEBUGMODE) {
      echo $msg;
    }
  }
}

function debug($msg) {
  global $DEBUGMODE;
  if (isset($DEBUGMODE) && $DEBUGMODE === true) {
    logit($msg);
  }
}

function abort($msg) {
  global $LOG;
  $msg = "ERROR: ABORTING\n\n$msg\n";
  logit($msg);
  if (isset($LOG) && $LOG !== false) {
    fclose($LOG);
  }
  exit;
}

function closelogfile() {
  global $LOG;
  if (isset($LOG) && $LOG !== false) {
    fclose($LOG);
    $LOG = false;
  }
}

function timestamp_to_displaydate($displayformat, $timestamp="") {
  if ($timestamp == "") {
    $timestamp = time();
  }
  return date($displayformat, $timestamp);
}

function timestamp_to_datetime($timestamp=false) {
  $res = false;
  if ($timestamp === false) {
    $timestamp = time();
  }
  $res = date(ISO_DATABASE_FORMAT, $timestamp);
  return $res;
}

function readallsql($path) {
  $content = readallfile($path);
  if ($content != "") {
    $content = preg_replace("/;$/", "^!^", $content);
    $content = preg_replace("/[\s]+/", " ", $content);
    $coresql_lines = explode("^!^", $content);
    $content = "";
    foreach ($coresql_lines as $sql_statement) {
      $sql_statement = trim($sql_statement);
      if ($sql_statement != "") {
        $content .= "$sql_statement;\n";
      }
    }
  }
  return $content;
}

function get_axyl_websites() {
  global $AXYL_DATA;
  $websites = array();
  if (isset($AXYL_DATA) && is_dir($AXYL_DATA)) {
    $dbpath = "$AXYL_DATA/system/axyl_websites.csv";
    if (file_exists($dbpath)) {
      $db = fopen($dbpath, "r");
      if ($db !== false) {
        while (feof($db) === false) {
          $buf = fgets($db, 4096);
          $line = rtrim($buf);
          if (substr($line, 0, 1) != "#" && trim($line) != "") {
            $fields = explode(",", $line);
            if (count($fields) > 0) {
              $appname = array_shift($fields);
              if ($appname != "" && count($fields) > 0) {
                $websites[$appname] = $fields;
              }
            }
          }
        } // while
      }
    }
  }
  return $websites;
}

?>