/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * SocketTest.java
 *
 * Created on 29 October 2002, 16:03
 */

package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 *
 * @author  hamish
 */
public class SocketTest {
    
    /** Creates a new instance of SocketTest */
    public SocketTest() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {

        listAll();
        
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        try {
            echoSocket = new Socket("localhost", 22222);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(
                                        echoSocket.getInputStream()));
        } catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        } catch (IOException e) {
            System.err.println("Couldn't get I/O for "
                               + "the connection to: localhost.");
            System.exit(1);
        }

	String control = "CONTROL\n" +
                         "Sub-Command: APPLICATION\n" +
                         "Application: name\n" +
                         "Field-Name: Id\n" +
                         "Field-Type: Text\n" +
                         "Field-Indexed: Yes\n" +
                         "Field-Stored: Yes\n" +
                         "Field-Name: Name\n" +
                         "Field-Type: Text\n" +
                         "Field-Indexed: Yes\n" +
                         "Field-Stored: Yes\n" +
                         "Domain: name\n" +
                         "Sort:\n" +
                         "Default-Field: Name\n" +
                         "Query: Domain:name\n" +
                         "Return: Id Name\n" +
                         "END\n";
	String control2 = "CONTROL\n" +
                         "Sub-Command: APPLICATION\n" +
                         "Field-Name: Domain\n" +
                         "Field-Type: Text\n" +
                         "Field-Indexed: Yes\n" +
                         "Field-Stored: Yes\n" +
                         "Query:\n" +
                         "END\n";
        String query = "QUERY\n" +
                         "Application: name\n" +
                         "Query: nicola\n" +
                         //"Sort: name\n" +
                         //"Return: Id Name\n" +
                         "END\n";
        String index =  "INDEX\n" +
                        "Application: name\n" +
                        //"Domain: name\n" +
                        "Id: 3\n" +
                        "Name: nicola\n" +
                        "END";

        
        String command = query;
        
	//send command to server.
        out.println(command);
                
        String serverOutput;
        while ((serverOutput = in.readLine()) != null) {
            System.out.println("from server: " + serverOutput);
        }

	out.close();
	in.close();
        
	echoSocket.close();
            

        
        
    }
    

    
    static private void listAll() throws java.lang.Exception {
                System.out.println("============= beginning of listing ============");
        org.apache.lucene.index.IndexReader r = org.apache.lucene.index.IndexReader.open( "c:\\temp\\index");

        int num = r.numDocs();
        for ( int i = 0; i < num; i++)
        {
                if ( ! r.isDeleted( i))
                {
                        org.apache.lucene.document.Document d = r.document( i);
                        System.out.println( "d=" +d);
                }
        }
        r.close();
        System.out.println("============= end of listing ============");
    }
    
        
    
    
}
