/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

public interface Constants
{
  // LuceneServer Daemon Version - update on each release.
  String LSD_VERSION    = "1.0.5 [Nov 2006]";
  
  // Special headers
  String SUB_COMMAND    = "Sub-Command";
  String APPLICATION    = "Application";
  String FIELD_NAME     = "Field-Name";
  String FIELD_TYPE     = "Field-Type";
  String FIELD_INDEXED  = "Field-Indexed";
  String FIELD_STORED   = "Field-Stored";
  String STOP_LIST      = "Stop-List";
  String ID             = "Id";
  String I              = "I";
  String DOMAIN         = "Domain";
  String CONTENT_LENGTH = "Content-Length";
  String DEFAULT_FIELD  = "Default-Field";
  String BODY           = "Body";
  String SORT           = "Sort";
  String SERIAL         = "Serial";
  String RETURN         = "Return";
  String ERROR          = "Error";
  String FIRST          = "First";
  String LIMIT          = "Limit";
  String COUNT          = "Count";
  String QUERY          = "Query";
  String RANGE_FIELD    = "Range-Field";
  String RANGE_FROM     = "Range-From";
  String RANGE_TO       = "Range-To";
  String DOCUMENT_KEY   = "\u0000" + DOMAIN + "\u0000" + ID;  // Composite document key.

  // Special Properties
  String FIELD_DEFS  = "Field-Definitions";

  // Special Values
  String RANK           = "RANK";
  String TEXT           = "Text";
  String YES            = "Yes";
  String NO             = "No";
  String DATE           = "Date";
  String APPLICATION_SUB_COMMAND = "APPLICATION";
  String OPTIMIZE_SUB_COMMAND = "OPTIMIZE";
  String BACKUP_SUB_COMMAND = "BACKUP";
  String HEALTHCHECK_SUB_COMMAND = "HEALTHCHECK";
  String GC_SUB_COMMAND       = "GC"; //added by hamish to aid in debugging.
  String DEFAULT_APPLICATION = "default";

  // End-marker

  String END = "END";

  // Property name defining the location of the index
  String LUCENE_INDEX_DIRECTORY_PROPERTY = "Lucene-Index-Directory";
  String DEFAULT_INDEX_DIRECTORY = "index";
  String REPLACE_DOCS_PROPERTY = "ReplaceDocsWhenIndexing";
  String MAX_SEARCHERS_PROPERTY = "MaxSearcherInstances";
  
  // Transmission.getString() arguments
  EUseApp USE_APP = EUseApp.USE_APP;
  EUseApp NO_APP = EUseApp.NO_APP;
  ESplit SPLIT = ESplit.SPLIT;
  ESplit NO_SPLIT = ESplit.NO_SPLIT;
}
