/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst;

/**
 * Log messages to output stream.
 * 
 * This has since been updated by H Carpenter to
 * utilise Log4J as the underlying logging mechanism.
 * 
 * This is to make custom logging requirements easier 
 * to implement (hopefully).
 * 
 */
import org.apache.log4j.Level;


public class Log implements IPackage
{
  public static final String THRESHOLD_PROPERTY = PACKAGE + "LogThreshold";

  static ELog threshold = ELog.INFO;

  /*
   * The actual logger (Log4J instance)
   */
  static private org.apache.log4j.Category logger;

  static
  {
    init();
  }

  public static void init()
  {
    String thresholdProp = System.getProperty(THRESHOLD_PROPERTY);
    if (thresholdProp != null) {
        thresholdProp = thresholdProp.trim();
        ELog newThreshold = ELog.getByName(thresholdProp);
        if (newThreshold != null)
          threshold = newThreshold;
    }
    else {
        thresholdProp = "INFO";
    }
    
  	String log4jConfigPath = System.getProperty(PACKAGE + "Log4jConfigPath");
  	System.out.println("Log4jConfigPath:" + log4jConfigPath);
    if (log4jConfigPath != null && !log4jConfigPath.equals("") && !log4jConfigPath.equals("null")) {
    	//implement the Log4J stuff
    	logger = org.apache.log4j.Category.getInstance("nz.net.catalyst.lucene");
    	if (logger != null) {
            if (thresholdProp.equalsIgnoreCase("DEBUG")) {
                logger.setLevel((Level) Level.DEBUG);
            }
            else if (thresholdProp.equalsIgnoreCase("INFO")) {
                logger.setLevel((Level) Level.INFO);
            } 
            else if (thresholdProp.equalsIgnoreCase("WARNING")) {
                logger.setLevel((Level) Level.WARN);
            }
            else if (thresholdProp.equalsIgnoreCase("ERROR")) {
                logger.setLevel((Level) Level.ERROR);
            } 
            else if (thresholdProp.equalsIgnoreCase("FATAL")) {
                logger.setLevel((Level) Level.FATAL);
            } 
            else {
                logger.setLevel((Level) Level.OFF);
            }
            
            org.apache.log4j.xml.DOMConfigurator.configure(log4jConfigPath);
            logger.warn("LuceneServer now initialised and Log4J logging started.");
    		System.out.println("Logging now passed to Log4J (threshold " + thresholdProp + ").");
    	}
        else {
    		System.out.println("=================================");
    		System.out.println(new java.util.Date() + "Error while initialising Log4j. Will use std out instead.");
    		System.err.println(new java.util.Date() + "Error while initialising Log4j. Will use std out instead.");
    		System.out.println("=================================");
    		logger = null;
    	}
    }  		
  }

  public static void log(ELog severity, Object message)
  {
    if (severity.lessThan(threshold))
      return;

	if (severity == ELog.DEBUG) {
		debug(message);
	} else if (severity == ELog.INFO || severity == ELog.NOTICE) {
  		info(message);
	} else if (severity == ELog.WARNING) {
		warn(message);
	} else if (severity == ELog.ERROR || severity == ELog.CRITICAL || severity == ELog.ALERT) {
		error(message);
	} else if (severity == ELog.FATAL) {
		fatal(message);
	}
    //System.out.println(message);
  }


  public static boolean willDebug()
  {
    //return threshold.greaterThan(ELog.DEBUG) ? false : true;
    return isDebugEnabled();
  }

  /**
   * Static methods only -- do not allow instances to be created.
   */
  private Log(){}

  public static void debug(Object message) {
	  //old method commented out.
	  //log (ELog.DEBUG, message);
	  if (logger != null) {
	  	logger.debug(message);
	  } else {
	  	System.out.println(message);
	  }
  }
  public static void info(Object message) {
  	if (logger != null) 
  		logger.info(message);
  	else
  		System.out.println(message);
  }
  public static void warn(Object message) {
  	if (logger != null)
		logger.warn(message);
  	else
  		System.out.println(message);
  }
  public static void error(Object message) {
  	if (logger != null)
		logger.error(message);
  	else
  		System.out.println(message);
  }
  public static void fatal(Object message) {
  	if (logger != null)
		logger.fatal(message);
  	else
  		System.out.println(message);
  }
   
  public static boolean isDebugEnabled() {
  	return logger.isDebugEnabled();
  }
	public static boolean isInfoEnabled() {
	  return logger.isInfoEnabled();
	}

}
