/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nz.net.catalyst.Log;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.cache.IndexSearcherCache;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.DateField;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.FieldDef;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.QueryException;
import nz.net.catalyst.lucene.server.RangeDef;
import nz.net.catalyst.lucene.server.Transmission;
import nz.net.catalyst.lucene.server.WriterControl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.TokenMgrError;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;

public class Query
implements IPackage,
Constants {
    private final Transmission input;
    private Application application;

    Query(Transmission transmission) {
        this.input = transmission;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Transmission execute() {
        long beforeOutput;
        long beforeSearch;
        org.apache.lucene.search.Query query;
        long queryStart = System.currentTimeMillis();
        Transmission response = new Transmission(ECommand.QUERY_RESPONSE);
        response.setSerial(this.input.getSerial());
        String appName = this.input.get("Application", NO_APP);
        try {
            this.application = Application.getAppOrDefault(appName);
        }
        catch (ApplicationMissingException e) {
            return this.error(e.getMessage());
        }
        this.input.setApplication(this.application);
        Analyzer analyzer = Application.getAnalyzer(this.input);
        String defaultField = this.input.get("Default-Field");
        if (defaultField == null) {
            defaultField = "UNDEFINED_FIELD";
        }
        Map fieldMap = this.mapFields(this.input.getFields());
        long beforeParse = System.currentTimeMillis();
        try {
            query = this.buildQuery(analyzer, defaultField, fieldMap);
        }
        catch (QueryException e) {
            return this.error(e.getMessage());
        }
        long beforeOpenSearcher = System.currentTimeMillis();
        File luceneStoreDir = Application.getIndexDirectory(this.application);
        int maxSearchers = Application.maxSearcherInstances(this.application);
        Searcher searcher = null;
        List returnFields = this.getReturnFields(fieldMap);
        try {
            try {
                WriterControl.closeIdleWriter(luceneStoreDir);
                try {
                    IndexSearcherCache isc = IndexSearcherCache.getInstance(luceneStoreDir);
                    searcher = isc.getSearcher(maxSearchers);
                }
                catch (IOException e) {
                    Log.error("Query performed on non-existing index!");
                    Log.error("An index needs to have at least one document successfully indexed before Querying.");
                    Log.error(e.getMessage());
                    String message = "Error during query: Index not found. Index documents first or check settings.";
                    Log.error(message);
                    Transmission transmission = this.error(message);
                    if (searcher == null) return transmission;
                    try {
                        searcher.close();
                        return transmission;
                    }
                    catch (Throwable e2) {
                        String message2 = "Error while closing IndexReader: " + e2.toString();
                        Log.error(message2);
                    }
                    return transmission;
                }
                SortField[] sortfields = this.getSortFields();
                beforeSearch = System.currentTimeMillis();
                Hits hits = null;
                int hitCount = 0;
                if (sortfields != null) {
                    hits = searcher.search(query, new Sort(sortfields));
                    hitCount = hits.length();
                } else {
                    hits = searcher.search(query);
                    hitCount = hits.length();
                }
                Log.info("Found " + hitCount + " results in " + (System.currentTimeMillis() - beforeSearch) + "ms");
                int limit = -1;
                try {
                    limit = Integer.parseInt(this.input.get("Limit"));
                    if (limit < 0) {
                        limit = -1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int first = 1;
                try {
                    first = Integer.parseInt(this.input.get("First"));
                    if (first < 1) {
                        first = 1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                beforeOutput = System.currentTimeMillis();
                int last = --first + limit;
                response.add("Count", String.valueOf(hitCount));
                int i = first;
                while (i != last && i < hitCount) {
                    int index = i;
                    Document d = hits.doc(index);
                    float score = hits.score(index);
                    response.add("I", String.valueOf(i + 1));
                    response.add("RANK", String.valueOf(score));
                    for (FieldDef returnField : returnFields) {
                        String value = d.get(returnField.name);
                        if (value == null) {
                            value = "";
                        } else if (returnField.date) {
                            try {
                                long msec = DateField.stringToTime(value);
                                value = String.valueOf(msec / 1000L);
                            }
                            catch (NumberFormatException e) {
                                String errorMsg = "Invalid Timestamp for datefield:" + returnField.name + ". " + e.getMessage();
                                Log.error(errorMsg);
                                Transmission transmission = this.error(errorMsg);
                                if (searcher == null) return transmission;
                                try {
                                    searcher.close();
                                    return transmission;
                                }
                                catch (Throwable e3) {
                                    String string = "Error while closing IndexReader: " + e3.toString();
                                    Log.error(string);
                                }
                                return transmission;
                            }
                        }
                        response.add(returnField.name, value);
                    }
                    ++i;
                }
            }
            finally {
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (Throwable e) {
                        String string = "Error while closing IndexReader: " + e.toString();
                        Log.error(string);
                    }
                }
            }
        }
        catch (IOException e) {
            String message = "Error during query: " + e.toString();
            Log.error(message);
            return this.error(message);
        }
        long end = System.currentTimeMillis();
        if (Log.willDebug()) {
            Log.debug("ReadQuery: " + String.valueOf(beforeParse - queryStart));
            Log.debug("Parse/BuildQuery: " + String.valueOf(beforeOpenSearcher - beforeParse));
            Log.debug("OpenSearcher: " + String.valueOf(beforeSearch - beforeOpenSearcher));
            Log.debug("Search: " + String.valueOf(beforeOutput - beforeSearch));
            Log.debug("Output: " + String.valueOf(end - beforeOutput));
            return response;
        }
        Log.info("Query time: " + String.valueOf(end - queryStart));
        return response;
    }

    private org.apache.lucene.search.Query buildQuery(Analyzer a, String field, Map fieldMap) {
        try {
            int clauseLimitSystem = Integer.parseInt(System.getProperty(String.valueOf(PACKAGE) + "ClauseLimitSystem"));
            BooleanQuery.setMaxClauseCount((int)clauseLimitSystem);
            Log.debug("setting max clause count to:" + clauseLimitSystem);
        }
        catch (NumberFormatException e) {
            Log.error("invalid setting for ClauseLimitSystem:" + System.getProperty(String.valueOf(PACKAGE) + "ClauseLimitSystem"));
        }
        QueryParser qp = new QueryParser(field, a);
        BooleanQuery result = new BooleanQuery();
        boolean anyTerms = false;
        String domain = this.input.get("Domain");
        if (domain != null) {
            Term domainSearch = new Term("Domain", domain);
            result.add((org.apache.lucene.search.Query)new TermQuery(domainSearch), BooleanClause.Occur.MUST);
            anyTerms = true;
        }
        String query = this.input.get("Query");
        Log.debug("Query (Unparsed): " + query);
        if (query != null) {
            try {
                result.add(qp.parse(query), BooleanClause.Occur.MUST);
                anyTerms = true;
            }
            catch (BooleanQuery.TooManyClauses e) {
                Log.error("Too many clauses in query: " + query);
                BooleanClause[] b = result.getClauses();
                Log.error(" - Number of clauses before error: " + b.length);
                Log.error(" - Try increasing ClauseLimitSystem in Server.config.");
                throw new QueryException("Too many clauses in query \"" + query + "\"", e);
            }
            catch (ParseException e) {
                Log.warn("Error parsing query: " + query);
                Log.warn(e.getMessage());
                BooleanClause[] b = result.getClauses();
                Log.error(" Number of clauses before error: " + b.length);
                throw new QueryException("Error parsing query \"" + query + "\": " + e.getMessage(), e);
            }
            catch (TokenMgrError e) {
                Log.warn("Error parsing query: " + query);
                Log.warn(e.getMessage());
                throw new QueryException("Error parsing query \"" + query + "\": " + e.getMessage(), e);
            }
        }
        Iterator it = this.getRangeQueries(fieldMap).iterator();
        while (it.hasNext()) {
            org.apache.lucene.search.Query theRange = null;
            try {
                theRange = (org.apache.lucene.search.Query)it.next();
                result.add(theRange, BooleanClause.Occur.MUST);
                anyTerms = true;
            }
            catch (BooleanQuery.TooManyClauses e) {
                Log.error("Too many clauses in query when adding range: " + theRange);
                BooleanClause[] b = result.getClauses();
                Log.error(" - Number of clauses before error: " + b.length);
                Log.error(" - Try increasing ClauseLimitSystem in Server.config.");
                throw new QueryException("Too many clauses in query when adding range \"" + theRange + "\"", e);
            }
        }
        if (!anyTerms) {
            throw new QueryException("No search expression!");
        }
        Log.info("Query (Parsed):  " + result.toString(""));
        if (Log.willDebug()) {
            BooleanClause[] b = result.getClauses();
            Log.debug(" Number of clauses in query: " + b.length);
        }
        return result;
    }

    private Map mapFields(List fieldList) {
        HashMap<String, FieldDef> result = new HashMap<String, FieldDef>();
        for (FieldDef field : fieldList) {
            result.put(field.name, field);
        }
        return result;
    }

    private List getReturnFields(Map fieldMap) {
        List<String> requestedFields = Arrays.asList(this.input.get("Return", USE_APP, SPLIT));
        LinkedList<String> returnFields = new LinkedList<String>(requestedFields);
        if (!returnFields.contains("Id")) {
            returnFields.add(0, "Id");
        }
        LinkedList<FieldDef> result = new LinkedList<FieldDef>();
        for (String name : returnFields) {
            FieldDef field = (FieldDef)fieldMap.get(name);
            if (field == null) {
                field = new FieldDef(name);
            }
            result.add(field);
        }
        return result;
    }

    private List getRangeQueries(Map fieldMap) {
        LinkedList<RangeQuery> result = new LinkedList<RangeQuery>();
        for (RangeDef range : this.input.getRanges()) {
            if (range.from == null && range.to == null) {
                throw new QueryException("Missing From or To value for Range field." + range.name);
            }
            FieldDef field = (FieldDef)fieldMap.get(range.name);
            boolean date = field != null && field.date;
            try {
                String from = range.from;
                if (date && from != null) {
                    from = DateField.dateToString(Application.makeDate(from));
                }
                String to = range.to;
                if (date && to != null) {
                    to = DateField.dateToString(Application.makeDate(to));
                }
                result.add(new RangeQuery(from == null ? null : new Term(range.name, from), to == null ? null : new Term(range.name, to), true));
            }
            catch (IllegalArgumentException e) {
                throw new QueryException("Error in range field \"" + range.name + "\": " + e.getMessage());
            }
        }
        return result;
    }

    private SortField[] getSortFields() {
        String[] fieldSpecs = this.input.get("Sort", USE_APP, SPLIT);
        if (fieldSpecs.length == 0) {
            return null;
        }
        SortField[] result = new SortField[fieldSpecs.length];
        int i = 0;
        while (i < result.length) {
            String[] subSpec = Util.split(fieldSpecs[i], ":");
            if (subSpec.length < 1 || subSpec.length > 2) {
                throw new QueryException("Invalid sort spec: \"" + this.input.get("Sort") + "\"");
            }
            String field = subSpec[0];
            Log.debug("Sorting by " + field + ".");
            if (field.equals("RANK")) {
                result[i] = new SortField(null, 0);
            } else {
                boolean descending = false;
                if (subSpec.length == 2) {
                    String direction = subSpec[1].toLowerCase();
                    if (direction.startsWith("d")) {
                        Log.debug("Setting sort order for field(" + field + ") to descending.");
                    }
                    descending = true;
                }
                result[i] = new SortField(field, descending);
            }
            ++i;
        }
        if (result.length == 1 && result[0].getType() == 0 && !result[0].getReverse()) {
            Log.debug("Sort term specified was the default ordering.  Skipping sort request.");
            return null;
        }
        return result;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.QUERY_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        return response;
    }
}

