/* applet.c generated by valac, the Vala compiler
 * generated from applet.vala, do not modify */

/*
 * Show/hide desktop applet written in Vala.
 *
 * Copyright (C) 2009 Mark Lee <avant-wn@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <avant-wn@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libawn/libawn.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <libwnck/libwnck.h>
#include <glib/gi18n.h>
#include <gdk/gdk.h>
#include <config.h>
#include <locale.h>


#define TYPE_SHOW_DESKTOP (show_desktop_get_type ())
#define SHOW_DESKTOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOW_DESKTOP, ShowDesktop))
#define SHOW_DESKTOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOW_DESKTOP, ShowDesktopClass))
#define IS_SHOW_DESKTOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOW_DESKTOP))
#define IS_SHOW_DESKTOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOW_DESKTOP))
#define SHOW_DESKTOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOW_DESKTOP, ShowDesktopClass))

typedef struct _ShowDesktop ShowDesktop;
typedef struct _ShowDesktopClass ShowDesktopClass;
typedef struct _ShowDesktopPrivate ShowDesktopPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ShowDesktop {
	AwnAppletSimple parent_instance;
	ShowDesktopPrivate * priv;
};

struct _ShowDesktopClass {
	AwnAppletSimpleClass parent_class;
};

struct _ShowDesktopPrivate {
	GtkMenu* _menu;
};


static gpointer show_desktop_parent_class = NULL;

GType show_desktop_get_type (void);
#define SHOW_DESKTOP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SHOW_DESKTOP, ShowDesktopPrivate))
enum  {
	SHOW_DESKTOP_DUMMY_PROPERTY
};
static void show_desktop_on_clicked (ShowDesktop* self);
static void _show_desktop_on_clicked_awn_applet_simple_clicked (AwnAppletSimple* _sender, gpointer self);
static void show_desktop_on_context_menu_popup (ShowDesktop* self, GdkEventButton* event);
static void _show_desktop_on_context_menu_popup_awn_applet_simple_context_menu_popup (AwnAppletSimple* _sender, GdkEventButton* event, gpointer self);
static void show_desktop_on_show_desktop_changed (ShowDesktop* self, WnckScreen* screen);
static void _show_desktop_on_show_desktop_changed_wnck_screen_showing_desktop_changed (WnckScreen* _sender, gpointer self);
static gboolean show_desktop_on_map_event (ShowDesktop* self, GdkEvent* event);
static gboolean _show_desktop_on_map_event_gtk_widget_map_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
ShowDesktop* show_desktop_new (const char* canonical_name, const char* uid, gint panel_id);
ShowDesktop* show_desktop_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id);
static void show_desktop_finalize (GObject* obj);
AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id);

static const char* SHOW_DESKTOP_authors[1] = {"Mark Lee <avant-wn@lazymalevolence.com>"};


static void _show_desktop_on_clicked_awn_applet_simple_clicked (AwnAppletSimple* _sender, gpointer self) {
	show_desktop_on_clicked (self);
}


static void _show_desktop_on_context_menu_popup_awn_applet_simple_context_menu_popup (AwnAppletSimple* _sender, GdkEventButton* event, gpointer self) {
	show_desktop_on_context_menu_popup (self, event);
}


static void _show_desktop_on_show_desktop_changed_wnck_screen_showing_desktop_changed (WnckScreen* _sender, gpointer self) {
	show_desktop_on_show_desktop_changed (self, _sender);
}


static gboolean _show_desktop_on_map_event_gtk_widget_map_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	return show_desktop_on_map_event (self, event);
}


ShowDesktop* show_desktop_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id) {
	GParameter * __params;
	GParameter * __params_it;
	WnckScreen* screen;
	ShowDesktop * self;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	screen = NULL;
	__params_it->name = "canonical-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, canonical_name);
	__params_it++;
	__params_it->name = "uid";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, uid);
	__params_it++;
	__params_it->name = "panel-id";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, panel_id);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	g_object_set ((AwnApplet*) self, "display-name", _ ("Show Desktop"), NULL);
	g_signal_connect_object ((AwnAppletSimple*) self, "clicked", (GCallback) _show_desktop_on_clicked_awn_applet_simple_clicked, self, 0);
	g_signal_connect_object ((AwnAppletSimple*) self, "context-menu-popup", (GCallback) _show_desktop_on_context_menu_popup_awn_applet_simple_context_menu_popup, self, 0);
	screen = wnck_screen_get_default ();
	g_signal_connect_object (screen, "showing-desktop-changed", (GCallback) _show_desktop_on_show_desktop_changed_wnck_screen_showing_desktop_changed, self, 0);
	show_desktop_on_show_desktop_changed (self, screen);
	g_signal_connect_object ((GtkWidget*) self, "map-event", (GCallback) _show_desktop_on_map_event_gtk_widget_map_event, self, 0);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ShowDesktop* show_desktop_new (const char* canonical_name, const char* uid, gint panel_id) {
	return show_desktop_construct (TYPE_SHOW_DESKTOP, canonical_name, uid, panel_id);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean show_desktop_on_map_event (ShowDesktop* self, GdkEvent* event) {
	gboolean result = FALSE;
	AwnIcon* _tmp0_;
	AwnTooltip* tooltip;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	tooltip = _g_object_ref0 (awn_icon_get_tooltip ((_tmp0_ = awn_applet_simple_get_icon ((AwnAppletSimple*) self), AWN_IS_ICON (_tmp0_) ? ((AwnIcon*) _tmp0_) : NULL)));
	g_object_set (tooltip, "toggle-on-click", FALSE, NULL);
	result = TRUE;
	_g_object_unref0 (tooltip);
	return result;
}


static void show_desktop_on_clicked (ShowDesktop* self) {
	WnckScreen* screen;
	g_return_if_fail (self != NULL);
	screen = NULL;
	screen = wnck_screen_get_default ();
	wnck_screen_toggle_showing_desktop (screen, !wnck_screen_get_showing_desktop (screen));
}


static void show_desktop_on_context_menu_popup (ShowDesktop* self, GdkEventButton* event) {
	g_return_if_fail (self != NULL);
	if (self->priv->_menu == NULL) {
		GtkWidget* about_item;
		GtkMenu* _tmp1_;
		GtkWidget* _tmp0_;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		about_item = NULL;
		self->priv->_menu = (_tmp1_ = _g_object_ref0 ((_tmp0_ = awn_applet_create_default_menu ((AwnApplet*) self), GTK_IS_MENU (_tmp0_) ? ((GtkMenu*) _tmp0_) : NULL)), _g_object_unref0 (self->priv->_menu), _tmp1_);
		about_item = (_tmp2_ = _g_object_ref0 (awn_applet_create_about_item ((AwnApplet*) self, "Copyright © 2009 Mark Lee", AWN_APPLET_LICENSE_GPLV2, VERSION, _ ("Hides your windows and shows your desktop."), NULL, NULL, "user-desktop", NULL, SHOW_DESKTOP_authors, NULL, NULL)), _g_object_unref0 (about_item), _tmp2_);
		gtk_widget_show (about_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->_menu, (GtkWidget*) (_tmp3_ = about_item, GTK_IS_MENU_ITEM (_tmp3_) ? ((GtkMenuItem*) _tmp3_) : NULL));
		_g_object_unref0 (about_item);
	}
	gtk_menu_set_screen (self->priv->_menu, NULL);
	gtk_menu_popup (self->priv->_menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
}


static void show_desktop_on_show_desktop_changed (ShowDesktop* self, WnckScreen* screen) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	if (wnck_screen_get_showing_desktop (screen)) {
		awn_applet_simple_set_tooltip_text ((AwnAppletSimple*) self, _ ("Show hidden windows"));
		awn_applet_simple_set_icon_name ((AwnAppletSimple*) self, "view-restore");
	} else {
		awn_applet_simple_set_tooltip_text ((AwnAppletSimple*) self, _ ("Hide windows and show desktop"));
		awn_applet_simple_set_icon_name ((AwnAppletSimple*) self, "user-desktop");
	}
}


static void show_desktop_class_init (ShowDesktopClass * klass) {
	show_desktop_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ShowDesktopPrivate));
	G_OBJECT_CLASS (klass)->finalize = show_desktop_finalize;
}


static void show_desktop_instance_init (ShowDesktop * self) {
	self->priv = SHOW_DESKTOP_GET_PRIVATE (self);
}


static void show_desktop_finalize (GObject* obj) {
	ShowDesktop * self;
	self = SHOW_DESKTOP (obj);
	_g_object_unref0 (self->priv->_menu);
	G_OBJECT_CLASS (show_desktop_parent_class)->finalize (obj);
}


GType show_desktop_get_type (void) {
	static volatile gsize show_desktop_type_id__volatile = 0;
	if (g_once_init_enter (&show_desktop_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShowDesktopClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) show_desktop_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShowDesktop), 0, (GInstanceInitFunc) show_desktop_instance_init, NULL };
		GType show_desktop_type_id;
		show_desktop_type_id = g_type_register_static (AWN_TYPE_APPLET_SIMPLE, "ShowDesktop", &g_define_type_info, 0);
		g_once_init_leave (&show_desktop_type_id__volatile, show_desktop_type_id);
	}
	return show_desktop_type_id__volatile;
}


AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id) {
	AwnApplet* result = NULL;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	textdomain (GETTEXT_PACKAGE);
	result = (AwnApplet*) g_object_ref_sink (show_desktop_new (canonical_name, uid, panel_id));
	return result;
}




