dnl Usage:
dnl AM_PATH_MAD([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for MAD audio library, and defines
dnl prerequisites:

AC_DEFUN([AM_PATH_MAD],
[
    AC_REQUIRE([AC_CANONICAL_HOST])
    AC_REQUIRE([AC_CANONICAL_TARGET])

    MAD_CFLAGS=
    MAD_LIBS=
    ac_enable_libmad=yes
    AC_ARG_WITH(mad_prefix, [  --with-mad-prefix=PFX	  where MAD library is installed. [[internal]]],
                [], with_mad_prefix=internal)
    if test "$with_mad_prefix" != internal; then
        ac_save_LDFLAGS=$LDFLAGS
        ac_save_LIBS=$LIBS
	if test -n "$with_mad_prefix"; then
            MAD_CFLAGS="-I$with_mad_prefix/include"
	    LDFLAGS="-L$with_mad_prefix/lib"
        fi
        AC_CHECK_LIB(mad, mad_stream_init,
        	     MAD_LIBS="$LDFLAGS -lmad", ac_enable_libmad=no)
        LDFLAGS=$ac_save_LDFLAGS
        LIBS=$ac_save_LIBS
        AC_SUBST(MAD_CFLAGS)
        AC_SUBST(MAD_LIBS)
    else
        AC_MSG_RESULT(checking for mad library... using internal version)
    fi

    AC_ARG_ENABLE(mad_speed, [  --disable-mad-speed     build internal MAD for speed. [[enabled]]],
		  [], enable_mad_speed=yes)
    if test "$enable_mad_speed" = yes; then
	AC_DEFINE(OPT_SPEED, 1, [MAD Define to optimize for speed over accuracy.])
    fi
    AC_ARG_ENABLE(mad, [  --enable-mad-accuracy   build internal MAD for accuracy. [[disabled]]],
		  [], enable_mad=no)
    if test "$enable_mad_speed" = yes -a "$enable_mad_speed" = no; then
	AC_DEFINE(OPT_ACCURACY, 1, [MAD Define to optimize for accuracy over speed.])
    fi

    case "$target" in
	i?86*) AC_DEFINE(FPM_INTEL, 1, [MAD Define intel fixed-point math routines.]) ;;
	arm*) AC_DEFINE(FPM_ARM, 1, [MAD Define arm fixed-point math routines.]) ;;
	mips*) AC_DEFINE(FPM_MIPS, 1, [MAD Define mips fixed-point math routines.]) ;;
	sparc*) AC_DEFINE(FPM_SPARC, 1, [MAD Define sparc fixed-point math routines.]) ;;
	powerpc*) AC_DEFINE(FPM_PPC, 1, [MAD Define powerpc fixed-point math routines.]) ;;
	*) AC_DEFINE(FPM_DEFAULT, 1, [MAD Define default fixed-point math routines.]) ;;
    esac

    AC_ARG_ENABLE(madsso, [  --disable-mad-sso       use subband synthesis optimization. [[enabled]]],
		  [], enable_madsso=yes)
    if test "$enable_madsso" = yes; then
	AC_DEFINE(OPT_SSO, 1, [MAD Define to enable a fast subband synthesis approximation optimization.])
    fi
    AC_ARG_ENABLE(madaso, [  --disable-mad-aso       disable architecture-specific optimizations. [[enabled]]],
		  [], enable_madaso=yes)
    if test "$enable_madaso" = yes; then
    	case "$target" in
	    i?86*) 
                AC_DEFINE(ASO_ZEROCHECK, 1, [MAD Define for fast subband synthesis approximation.])
		;;
	esac
    fi

    if test "$ac_enable_libmad" = yes; then
	ifelse([$1], , :, [$1])
    else
	ifelse([$2], , :, [$2])
    fi
])

