#!/usr/bin/perl -T

# ndc.cron.pl
# cron job to determine if DNS has been updated and, if so, force a
# dump of the databases to disk.
# Uses ndc to do the dirty work

use strict;

# edit these for your own system.
require '/etc/autodns-dhcp.conf' ;
exit 0 if ($main::DOMAIN eq "__DOMAIN__") ;

my $NDC="/usr/sbin/ndc restart";

my $DHCPD_TEMP="$main::DDNSHOME/dhcpd.leases.last";
my $DNS_TEMP="$main::DDNSHOME/dns.last";
my $LOCKFILE="$main::DDNSHOME/lock";

# sleep for this long between tries
my $SNOOZE=10;
# only back off five times if locked out 
my $MAXTRIES=5;

my($ref,$data,$snooze);
my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks);

# get timestamp on leases backup file
($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
 $blksize,$blocks)=stat($DHCPD_TEMP);
$data=$mtime;

# get timestamp on dns ref file
($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
 $blksize,$blocks)=stat($DNS_TEMP);
$ref=$mtime;

if($ref >= $data) {
  exit 0;
}

# make sure no DNS updates are in process
$snooze=0;
while (-e "$LOCKFILE") {
  sleep $SNOOZE;
  $snooze++;
  if ($snooze > $MAXTRIES) {
    print STDERR "dns.cron.pl -- too many timeouts!\n";
    exit 0;
  }
}

# if we get this far then run the update command
$ENV{'PATH'} = '/usr/sbin';
`$NDC`;

# touch the time stamp file
`/bin/touch $DNS_TEMP`
