#include <stdlib.h>
#include <curses.h>
#include <audacious/audctrl.h>
#include <libgen.h>
#define __USE_GNU // to get strcasestr
#include <string.h>
#include <glib.h>
#include "curses_printf.h"
#include "kbd_constants.h"
#include "main.h"
#include "playlist.h"
#include "dbus.h"

#include <time.h>

/*
    This file is part of xmms-curses, copyright 2003-2005 Knut Auvor Grythe.

    xmms-curses is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    xmms-curses is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with xmms-curses; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

extern struct timespec interval;
extern playlist list;
extern windows wins;

static void jumpwin_repaint(void)
{
	mvwtitledhline(wins.title, 0, "Search results");
	wnoutrefresh(wins.title);
}

static int match(char *title, char *string)
{
	if(strlen(string) == 0) return 1;
	char *token, *cp; 
	cp = strdup(string);
	token = strtok(cp, " ");
	while(token){
		if(!strcasestr(title, token)) {
			free(cp);
			return 0;
		}
		token = strtok(NULL, " ");
	}
	free(cp);
	return 1;
}

static int playlist_search(char *search, int *results, int prev_hits) 
{
	int i;
	int hits = 0;
	
	if (prev_hits == -1) {
		for (i=0; i<(list.length); i++) {
			if (match(list.song[i].file, search)) {
				results[hits++] = i;
			}
		}
	} else {
		int * old_results = (int*)malloc(prev_hits * sizeof(int));
		for (i=0; i<prev_hits; i++) {
			old_results[i] = results[i];
		}
		for (i=0; i<prev_hits; i++) {
			if (match(list.song[old_results[i]].file, search)) {
				results[hits++] = old_results[i];
			}
		}
		free(old_results);
	}
	return hits;
}

void playlist_jump(void) 
{
	int len = 0;
	char buffer[128];
	playlist plist;
	int repaint = true;
	int old_cursor = curs_set(1); // enable cursor
	
	plist.song_mask = (int*)malloc(list.length * sizeof(int));
	plist.pos = -1;
	plist.prev_pos = -1;
	plist.length = playlist_search("", plist.song_mask, -1);
	plist.selector = 0;
	plist.scrolledto = 0;
	plist.song = list.song;
	
	buffer[0] = '\0';
	
	while (true) {
		int c;
		int finished = false;
		int search = false;
		int pl_height, pl_width;
		
		if (wins.term_resized == true) {
			wins.term_resized = false; // Unset trigger
			resize_windows();
			repaint = true;
		}

		getmaxyx(wins.list, pl_height, pl_width);

		while((c = getch()) != ERR) {
			switch (c) {
				case KEY_UP:
					if ( plist.selector > 0 )
						--plist.selector;
					break;
				case KEY_DOWN:
					if ( plist.selector < plist.length-1 ) 
						++plist.selector;
					break;
				case KEY_PPAGE:
					if (plist.selector >= pl_height)
						plist.selector -= pl_height;
					else
						plist.selector = 0;
					break;
				case KEY_NPAGE:
					if (plist.selector < plist.length-pl_height)
						plist.selector += pl_height;
					else 
						plist.selector = plist.length-1;
					break;
				case ESCAPE:
					free(plist.song_mask);
					finished = true;
					break;
				case ENTER:
					if (plist.length > 0) {
						audacious_remote_set_playlist_pos(dbus_proxy, (gint) plist.song_mask[plist.selector]);
						audacious_remote_play(dbus_proxy);
						free(plist.song_mask);
						finished = true;
					}
					break;
				case KEY_BACKSPACE:
					if (len == 0) break;
					buffer[--len] = '\0';
					search = true;
					//plist.selector = 0;
					plist.length = -1; //make playlist_search start from scratch
					break;
				default: //where we handle the characters
					if (len == 127) break; //we don't like overflows
					if (c < 32) break; //no control characters
					buffer[len] = c;
					buffer[++len] = '\0';
					search = true;
					//plist.selector = 0;
					break;
			}
		}

		if (finished) {
			if (old_cursor != ERR) 
				curs_set(old_cursor); // restore cursor
			return;
		} 
		
		if (search) {
			int old_hits = plist.length;
			plist.length = playlist_search(buffer, plist.song_mask, plist.length);
			if (plist.length != old_hits) {
				plist.scrolledto = 0;
			}
		}

		playlist_paint(&plist);
		
		int x, y;
		mvwaddnstrf(wins.status, 0, 0, "Searching for: %s", -1, buffer);
		getyx(wins.status, y, x);
		wclrtoeol(wins.status);
		mvwchgat(wins.status, 0, 0, -1, A_BOLD, 1, NULL);

		mvwaddnstrf(wins.status, 1, 0, "Results found: %i", -1, plist.length);
		wclrtoeol(wins.status);
		wchgat(wins.status, -1, A_NORMAL, 1, NULL);
		wmove(wins.status, y, x);
		
		wnoutrefresh(wins.status);
		
		if (repaint) {
			repaint = false;
			jumpwin_repaint();
		}
	        	
		doupdate();
		nanosleep(&interval, NULL);
	}
}
