/*
 *
 * This C code is generated by ATS/Geizella
 * The compilation time is: 2013-1-14: 16:1
 *
 */

#define _ATS_GEIZELLA 1

#include "ats_config.h"
#include "ats_basics.h"
#include "ats_types.h"
#include "ats_exception.h"
#include "ats_memory.h"

/* include some .cats files */

#include "prelude/CATS/array.cats"
#include "prelude/CATS/basics.cats"
#include "prelude/CATS/bool.cats"
#include "prelude/CATS/byte.cats"
#include "prelude/CATS/char.cats"
#include "prelude/CATS/float.cats"
#include "prelude/CATS/integer.cats"
#include "prelude/CATS/pointer.cats"
#include "prelude/CATS/printf.cats"
#include "prelude/CATS/reference.cats"
#include "prelude/CATS/sizetype.cats"
#include "prelude/CATS/string.cats"

/* external codes at top */



ats_void_type atspre_exit_prerrf
  (const ats_int_type n, const ats_ptr_type fmt, ...)
{
  va_list ap ;
  va_start(ap, fmt) ; vfprintf(stderr, (char*)fmt, ap) ; va_end(ap) ;
  exit(n) ;
}

ats_void_type atspre_assert_prerrf
  (ats_bool_type assertion, ats_ptr_type fmt, ...) {
  int n ;
  va_list ap ;

  if (!assertion) {
    va_start(ap, fmt) ;
    n = vfprintf(stderr, (char*)fmt, ap) ;
    va_end(ap) ;
    if (n < 0) {
      ats_exit_errmsg (
        n, "[atspre_assert_prerrf: prerrf] failed\n"
      ) ;
    } else {
      ats_exit_errmsg (
        1, "[atspre_assert_prerrf: assert] failed\n"
      ) ;
    }
  }
  return ;
} /* end of [atspre_assert_prerrf] */




// functions for sprintf

static
ats_ptr_type __tostringf_size
  (const ats_int_type guess, const ats_ptr_type fmt, va_list ap0)
{
  int n, sz ; char *res ; va_list ap ;

  sz = guess ;
  res = ATS_MALLOC (sz) ;
  while (1) {
    va_copy (ap, ap0) ; // [vsnprintf] may modify [ap]
    n = vsnprintf (res, sz, (char*)fmt, ap) ;
    if (n >= 0) {
      if (n < sz) return res ;
      sz = n+1 ; /* exact size */
      ATS_FREE (res) ; res = ATS_MALLOC (sz) ;
      continue ;
    } // end of [if]
    return ((ats_ptr_type)0) ;
  }
} // end of [__tostringf_size]

ats_ptr_type atspre_tostringf_size
  (const ats_int_type guess, const ats_ptr_type fmt, ...)
{
  char *res ;
  va_list ap ;

  va_start(ap, fmt);
  res = (char*)__tostringf_size (guess, fmt, ap);
  va_end(ap);
  if (!res) {
    ats_exit_errmsg (1, "Exit: [ats_tostringf_size] failed.\n") ;
  }
  return res ;
}

#define __TOSTRINGF_GUESS 16
ats_ptr_type
atspre_tostringf (ats_ptr_type fmt, ...) {
  char *res ;
  va_list ap ;

  va_start(ap, fmt);
  res = (char*)__tostringf_size (__TOSTRINGF_GUESS, fmt, ap);
  va_end(ap);
  if (!res) {
    ats_exit_errmsg (1, "Exit: [ats_tostringf] failed.\n") ;
  }
  return res ;
} /* end of [atspre_tostringf] */


/* type definitions */

/* external dynamic constructor declarations */

/* external dynamic constant declarations */

/* internal function declarations */

/* sum constructor declarations */

/* exception constructor declarations */

/* global dynamic constant declarations */

/* static temporary variable declarations */

/* function implementations */

/* static load function */

static int _2fhome_2ffac2_2fhwxi_2fresearch_2fATS_2fIMPLEMENT_2fGeizella_2fAnairiats_2fsvn_2fats_2dlang_2fsrc_2fprelude_dats_printf_2edats__staload_flag = 0 ;
ats_void_type _2fhome_2ffac2_2fhwxi_2fresearch_2fATS_2fIMPLEMENT_2fGeizella_2fAnairiats_2fsvn_2fats_2dlang_2fsrc_2fprelude_dats_printf_2edats__staload () {
if (_2fhome_2ffac2_2fhwxi_2fresearch_2fATS_2fIMPLEMENT_2fGeizella_2fAnairiats_2fsvn_2fats_2dlang_2fsrc_2fprelude_dats_printf_2edats__staload_flag) return ;
_2fhome_2ffac2_2fhwxi_2fresearch_2fATS_2fIMPLEMENT_2fGeizella_2fAnairiats_2fsvn_2fats_2dlang_2fsrc_2fprelude_dats_printf_2edats__staload_flag = 1 ;
}

/* dynamic load function */

ats_void_type _2fhome_2ffac2_2fhwxi_2fresearch_2fATS_2fIMPLEMENT_2fGeizella_2fAnairiats_2fsvn_2fats_2dlang_2fsrc_2fprelude_dats_printf_2edats__dynload () {
_2fhome_2ffac2_2fhwxi_2fresearch_2fATS_2fIMPLEMENT_2fGeizella_2fAnairiats_2fsvn_2fats_2dlang_2fsrc_2fprelude_dats_printf_2edats__staload () ;
}

/* external types */

/* external codes at mid */

/* external codes at bot */

