# -*- mode:python; coding:utf-8 -*-

import time

import atheist

class TimeLessThan(atheist.Condition, atheist.Plugin):
    """ Check the execution time is less than the specified (in seconds) """

    def __init__(self, t):
        atheist.check_type(t, int)
        self.max = t
        atheist.Condition.__init__(self)
        self.tini = None
        self.tend = None

    def before(self, task, condlist, pos):
        self.tini = time.time()
        atheist.Condition.before(self, task, condlist, pos)

    def after(self):
        self.tend = time.time()

    def run(self):
        assert self.tini is not None, "Internal error"
        assert self.tend is not None, "Internal error"

        return self.tend - self.tini <= self.max

    def __eq__(self, other):
        return atheist.Condition.__eq__(self, other) and \
            self.max == other.max
