/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "physobj.h"
#include "globaldata.h"
#include "environment.h"

int PHYSICAL_OBJECT::applyPhysics ()
{
	// Normal physics

	//motion - wind affected
	if (x + xv < 1 || x + xv > (_global->screenWidth-1)) {
             // bounce on rubber
             if ( _env->current_wallType == WALL_RUBBER )
		xv = -xv;	//bounce on the border
             else if (_env->current_wallType == WALL_SPRING)
                xv = -xv * SPRING_CHANGE;
             else if (_env->current_wallType == WALL_WRAP)
             {
                if (xv < 0)
                    x = _global->screenWidth - 1;
                else 
                    x = 1;
             }
             else if (_env->current_wallType == WALL_STEEL) // blow up on steel
             {
                 hitSomething = 1;
             }
	} else {
		double accel = (_env->wind - xv) / mass * drag * _env->viscosity;
		xv += accel;
		x += xv;
	}

        // hit floor
	if (y + yv >= _global->screenHeight)
	{
              // rubber floor
              if ( _env->current_wallType == WALL_RUBBER )
              {
		yv = -yv * 0.5;
		xv *= 0.95;
		if (fabs(xv) + fabs(yv) < 0.8)
			hitSomething = 1;
              }
              else if ( _env->current_wallType == WALL_SPRING )
              {
                  yv = -yv * SPRING_CHANGE;
                  xv *= 1.05;
                  if (fabs(xv) + fabs(yv) < 0.8)
                       hitSomething = 1;
              }
              // steel or wrap floor
              else
                  hitSomething = 1;
	}
	y += yv;
	yv += _env->gravity * (100.0 / _global->frames_per_second);

	return (hitSomething);
}

int PHYSICAL_OBJECT::checkPixelsBetweenPrevAndNow ()
{
	double startX = x - xv;
	double startY = y - yv;

	if (checkPixelsBetweenTwoPoints (_global, _env, &startX, &startY, x, y)) {
		x = startX;
		y = startY;
		return (1);
	}

	return (0);
}

int checkPixelsBetweenTwoPoints (GLOBALDATA *global, ENVIRONMENT *env, double *startX, double *startY, double endX, double endY)
{
	int landFound = 0;

	// only check if on screen
	double xDist = endX - *startX;
	double yDist = endY - *startY;
	double length;
	double xInc;
	double yInc;

	if (xDist < 2 && yDist < 2) {
		if (endX > 0 && endX < global->screenWidth &&
			endY < global->screenHeight && endY > 0 &&
			(getpixel (env->terrain, (int)endX, (int)endY) != PINK))
			return (1);
		else
			return (0);
	}

       	length = sqrt ((xDist * xDist) + (yDist * yDist));
	yInc = yDist / length;
	xInc = xDist / length;

	// sanity check
	if (length > global->screenWidth + global->screenHeight)
		length = global->screenWidth + global->screenHeight;

	//check all pixels along line for land
	for (int lengthPos = 0; lengthPos < length; lengthPos++) {
		//found land
		if (*startX > 0 && *startX < global->screenWidth && *startY < global->screenHeight && *startY > 0 && (getpixel (env->terrain, (int)*startX, (int)*startY) != PINK)) {
			// Leaves startX and Y at current point
			landFound = 1;
			break;
		}
		*startX += xInc;
		*startY += yInc;
	}

	return (landFound);
}

void PHYSICAL_OBJECT::initialise ()
{
	VIRTUAL_OBJECT::initialise ();
	hitSomething = 0;
}

/*int PHYSICAL_OBJECT::isSubClass (int classNum)
{
	if (classNum != PHYSICAL_OBJECT_CLASS)
		return (VIRTUAL_OBJECT::isSubClass (classNum));
	else
		return (TRUE);
}*/
