# -*- coding: utf-8 -*-

import os.path

from asrun.common.utils import get_absolute_dirname


# Code_Aster installation prefix (prefering ASTER_ROOT is at least necessary for asrun's developer!)
if os.environ.get('ASTER_ROOT'):
    aster_root = os.environ['ASTER_ROOT']
else:
    #               asrun           site-packages pythonX.Y      lib     prefix
    aster_root = os.path.normpath(os.path.join(
        get_absolute_dirname(__file__), os.pardir, os.pardir, os.pardir, os.pardir))
os.environ['ASTER_ROOT'] = aster_root

# directory for configuration files (profile.sh, config)
# alternative to /etc/code_aster for non-root install
prefix = aster_root
if aster_root == '/usr':
    prefix = '/'
confdir = os.path.join(prefix, 'etc', 'codeaster')

# directory containing data files
datadir = os.path.join(aster_root, 'share', 'codeaster', 'asrun', 'data')

# directory for internationalization
localedir = os.path.join(aster_root, 'share', 'locale')
