Historique des modifications
============================


Version 1.10.9 :

   * Nouveauts / corrections
   
     - Correction du support du gestionnaire de batch Sun Grid Engine en parallle.
       Un plugin fourni peut tre activ pour choisir le 'parallel environment'
       appropri (voir ``etc/codeaster/plugins/sge_pe.py``).
   
     - On ne pouvait pas dnoter un catalogue python (.capy).
     
     - L'onglet AGLA est toujours activ. Certaines fonctionnalits sont rserves
       aux dveloppeurs dment enregistrs.
   
Version 1.10.8 :

   * Nouveauts / corrections
   
     - Ajout du paramtre ADDMEM dans le fichier config.txt pour ajouter
       un forfait  la limite mmoire du job (correspondant  l'excutable,
       les bibliothques...). Essentiellement utile quand le gestionnaire de
       batch limite strictement la mmoire.

     - La procdure de mise  jour sauvegarde la version prcdente en la
       renommant (au lieu de la copier) pour acclrer le processus sur des
       systmes de fichier peu rapides.

Version 1.10.7 :

   * Nouveauts / corrections

     - Les erreurs de copie des rsultats taient mal dtectes. Le rpertoire
       intermdiaire sur le serveur pouvait donc tre effac sans que les rsultats
       aient t rcuprs (cf. issue19237).

     - En cas de code retour non nul de l'excutable le diagnostic devient <F>
       au lieu de <S> (cf. issue17122).

     - On interdit de lancer une excution parallle avec une version squentielle
       (cf. issue18962).

     - Lors d'une mise  jour, si un champ devient optionnel, il est quand mme
       dfini dans le nouveau fichier de configuration et un avertissement est
       affich dans la console (cf. issue19258).

Version 1.10.6 :

   * Nouveauts / corrections

     - astk ne sauvegardait pas correctement plus d'une version utilisateur
       (dans ``~/.astkrc/prefs``).
       S'il y avait plus d'une version, la dernire tait crite plusieurs fois.

     - Les versions n'taient pas listes dans le mme ordre dans astk que
       dans les fichiers de configuration.

     - Nouveau paramtre 'after_job' dans le menu Options pour soumettre un
       calcul qui ne sera pas dmarr avant qu'un autre ne soit termin.
       Ne fonctionne que pour les excutions en batch.

   * ct serveur (as_run)
   
     - La compilation des catalogues d'lments chouait par manque de mmoire
       (issue19094). Se produit lors de la mise  jour vers la version 11.2.7.

     - --quick ne fonctionnait pas dans un rpertoire contenant des accents.
     
     - Les excutions multiples chouaient avec des fichiers de donnes contenant
       des accents dans leur chemin (issue19288).

     - Excutions multiples : les rsultats n'taient pas recopis si le nom
       d'utilisateur est diffrent de la machine locale.
   
     - Correction d'une erreur lors de l'archivage quand beaucoup de fichiers
       taient mis  jour (issue19150).

     - La dtection de machine distante chouait sur Fedora
       (voir http://www.code-aster.org/forum2/viewtopic.php?id=17273)


Version 1.10.5 :

   * ct serveur (as_run)

     - on peut donner une tiquette aux versions, pour viter les conflits sur le
       nom de base, dans les fichiers de configuration (``etc/codeaster/aster`` ou 
       ``~/.astkrc/prefs``). C'est cette tiquette qui est affiche dans astk.
       Par exemple : ``DEV:$HOME/dev/codeaster/install/share/aster``

     - les fichiers 'config.txt' supporte une nouvelle variable $ASTER_VERSION_DIR.
       Ceci permet de changer trs peu de lignes quand un fichier config.txt est
       copi ou dplac. Les lignes o le nom de la version apparaissait n'ont
       plus besoin d'tre modifies.

     - tude paramtrique : les calculs non lancs sont considrs comme en erreur.

Version 1.10.4 :

   * Nouveauts / corrections

     - le lancement de tests prend en compte les suppressions de fichiers de donnes
       de cas-tests.

Version 1.10.3 :

   * Nouveauts / corrections

     - nouvelle fonction agla ASDENOT pour dnoter tous les sources d'un utilisateur.

     - les options distrib/multiple sont maintenant simplement coches ou dcoches.

     - nouvelle option --getversion_path qui retourne le chemin d'installation.

     - nouvel argument 'version cible' pour '--auto_update' pour ne faire les
       mises  jour que jusqu' une version donne.

     - support des gestionnaires de batch revu, ajout du support de Slurm.

     - 'copy_result_alarm' peut tre mis  'no' dans les profils afin de ne pas
       mettre d'alarme si un rsultat n'existe pas.

     - nouvelle option --copy_all_results ( utiliser avec --quick) pour copier
       les rsultats connus dans le rpertoire courant.

     - mise  jour du vrificateur --messages pour chercher les messages dans les
       fichiers .capy et pour supporter le nouveau format de message (pour la
       version de dveloppement de Code_Aster).

     - les lignes PYSUPPR n'taient pas prises en compte dans make_cmde & make_etude.

     - plusieurs petites corrections dans l'interface avec le REX (mysql_date_fmt, nosy-list).

Version 1.10.2 :

   * Nouveauts / corrections

     - la construction d'une version MPI chouait (depuis 1.10.1) si elle est
       excute avec mpirun.

     - le calcul n'tait pas lanc si un fichier/rpertoire contenait des
       caractres accentus.

     - corrige l'import de cas-test sur un serveur distant (les fichiers taient
       marqus comme tant locaux).

Version 1.10.1 :

   * Nouveauts / corrections

     - tude paramtrique : interception des exceptions en cas d'erreur dans le
       fichier utilisateur.

     - astout/tude paramtrique : le rpertoire des rsultats doit tre sur la
       machine d'excution.

     - modification des rpertoires d'excution en parallle. Un rpertoire "global"
       est prpar dans ``[shared_tmp]/job_number/global`` et est dupliqu pour chaque
       processeur dans ``[rep_trav]/job_number/proc.#procid`` o
       ``rep_trav/shared_tmp`` sont dfinis dans le fichier de configuration
       ``etc/codeaster/asrun``.

     - modification de la position initiale de la fentre des jobs (pas exactement
       respecte).

Version 1.10.0 :

   * Nouveauts / corrections

     - excution multi-machines : un profil (tude, cas-tests...) peut tre lanc
       simultanment et trs simplement sur plusieurs machines. Il suffit d'indiquer
       ``multiple = oui`` dans le menu Options/Options de lancement.

     - problme corrig lors de la recopie d'un rpertoire de rsultats (un niveau
       de rpertoire supplmentaire tait cr).

     - lancement en batch : correction du passage du nombre de processeurs et noeuds
       en MPI, on conserve maintenant dans le flasheur de script tel qu'il est soumis.

     - exectool fonctionne maintenant quand on lance sur une machine distante.

     - lors du lancement d'astout ou d'tude paramtrique, deux fichiers NOOK et
       RESULTAT sont crits dans le rpertoire de rsultat pour permettre de
       suivre l'avancement du processus.
       Le paramtre ``flashdir`` n'existe plus (menu Options), il est remplac par
       un rpertoire de type ``flash`` dans les onglets **ETUDE** et **TESTS**.

     - correction d'erreurs sur les chemins contenant des caractres accentus.

     - correction d'une initialisation de variable (``choix_listul``) dans
       **Configuration/Prfrences/Rseau**.

     - lors de l'importation d'un cas-test, le nombre de processeurs et de noeuds
       tait mis par dfaut  0. Ils sont maintenant initialiss  1 s'ils ne sont pas
       dans le fichier .para.

     - la limitation sur l'enchainement de plusieurs fichiers de commandes en MPI
       est leve ; fonctionne galement en mode prparation de l'environnement.

     - fusion des fichiers des prfrences de l'utilisateur (``.astkrc/prefs`` et
       ``.astkrc/config``) dans un seul fichier ``.astkrc/prefs``. La fusion est
       faite automatiquement au premier dmarrage d'``as_run``.

     - lors de l'mission de fiche avec fichiers attachs, les paramtres mmoire
       et temps de l'tude n'taient pas conservs.

     - ouverture de cette note de version dans le navigateur s'il est configur
       dans **Configuration/Prfrnces/Gnrales**.

     - on peut maintenant utiliser des variables d'environnement dans les
       fichiers de configuration (``~/.astkrc/prefs``, ``~/.astkrc/outils`` et
       ``~/.astkrc/config_serveurs``). Les variables supportes sont seulement
       ``ASTER_ROOT``, ``ASTER_ETC`` et ``HOME``.

   * ct serveur

     - dans le fichier de configuration (``etc/codeaster/asrun``), les limites
       mmoire et temps taient ignores si un des deux paramtres ``memmax/tpsmax``
       tait absent. Elles taient alors dtermines automatiquement.

     - on peut maintenant utiliser des variables d'environnement dans les
       fichiers .export (objets ``AsterProfil``) et les fichiers de configuration
       (``etc/codeaster/asrun`` et ``etc/codeaster/aster``).

     - il y a eu des changements dans l'API de ``asrun``, voir les DeprecationWarnings
       pour mettre  jour votre code et la documentation dans
       ``share/codeaster/asrun/doc/dev_guide.*``.

Version 1.9.1 :

   * Nouveauts / corrections

     - possibilit de restreindre les types de fichiers dans les onglets, choix dans
       **Configuration/Prfrences/Gnrales** : tous les types, les plus courants, choix
       utilisateur (renseigner les types spars par des espaces dans le fichier
       ``~/.astkrc/prefs``, champ ``listul_perso``).

     - quand plusieurs entres d'un profil avaient le mme nom de base, ils taient
       copis sous le mme nom dans le rpertoire intermdiaire.

     - si un excutable tait en donne et rsultat, on essayait de le copier au dpart
       alors qu'il faut d'abord le construire.

     - on interdit de lancer une excution s'il y a une base/bhdf en donne ET un
       catalogue d'lments en donne.

   * ct serveur

     - dtermine automatiquement les limites mmoire, temps, nombre de processeurs
       si elles ne sont pas dfinies dans le fichier de configuration
       ``etc/codeaster/asrun``.

     - (sur la machine de dveloppement) l'mission de fiche REX ne fonctionnait pas
       sans fichier joint et le serveur n'tait pas automatiquement slectionn.

     - considre aussi les fichiers include (en plus du fichier objet) pour savoir si
       un fichier source doit tre recompil.

Version 1.9.0 :

   * Changement profond du mode de fonctionnement : les communications sont maintenant
     unidirectionnelles, du client vers le serveur (il n'y a plus les retours du serveur
     pour copier des fichiers ou afficher des fentres).

     - Lors du lancement d'un calcul :

        1. les fichiers sont copis sur le serveur (dans un rpertoire intermdiaire,
           "proxy", dfini par celui-ci et partag par tous ses noeuds de calcul)

        2. le calcul est lanc sur le serveur, les rsultats restent sur le serveur.

        3. les rsultats sont rappatris automatiquement quand le calcul en ``ENDED`` dans
           le suivi des jobs (donc aprs actualisation manuel ou automatique de son tat).

       Ces modifications simplifient la configuration des connexions entre les machines
       (seule la connexion entre la machine locale o est lanc astk et le serveur de
       calcul est ncessaire).

       Elles permettent de s'adapter aux serveurs o les noeuds de calcul n'ont pas accs
       au reste du rseau.

       Si les fichiers de donnes/rsultats sont sur la machine locale ou le serveur de
       calcul, il y a peu d'impacts sur les temps de copie.

       En revanche, si des serveurs tiers sont utiliss, un transfert supplmentaire
       serait ncessaire. Il a t choisi dans ce cas, pour le moment au moins, de laisser
       le serveur de calcul aller chercher les fichiers... s'il le peut.

     - Autoriser les affichages sur la machine locale depuis le serveur distant n'est plus
       ncessaire. En revanche, le lancement avec suivi interactif sur un serveur distant
       monopolise l'interface pendant ce temps.

     - Lors de l'dition des fichiers ``output/error/export`` depuis asjob, ceux-ci sont
       d'abord tlchargs depuis le serveur de calcul puis diter localement.

     - L'avancement des requtes aux serveurs est affich dans la partie basse du suivi
       des jobs. On peut vider la fentre par clic-droit, puis **Clear**.

     - Des modules additionnels peuvent tre ajouts dans ``etc/codeaster/plugins`` pour
       adapter le comportement d'asrun en fonction d'un serveur particulier
       (voir ``plugins/actions.py``).

     - Changement de l'action "consbtc" : le script est laiss sur le serveur o il
       est gnr.

   * Nouvelles fonctionnalits / corrections :

     - si un fichier rsultat n'a pas t produit, l'excution se termine en
       ``<A>_COPYFILE`` (avant il s'agissait d'une erreur ``<F>_COPY_ERROR``).

     - traduction anglaise complte (pour le suivi des jobs).

     - as_run : dans un fichier export, les noms de fichiers/rpertoires peuvent tre
       des chemins relatifs par rapport au rpertoire contenant le fichier export.

Version 1.8.4 :

   * Nouvelles fonctionnalits / corrections :

      - retour en arrire sur les permissions sur les fichiers : seul le rpertoire de
        travail est protg en lecture pendant l'excution. Il est de la responsabilit
        de l'utilisateur de protger le rpertoire de ses rsultats s'il le souhaite.

      - les boutons pour dplacer un fichier dans la liste sont disponibles pour les
        onglets de **SURCHARGE**.

      - quand **AGLA** est coch, on pouvait tre arrt si l'excutable/catalogue
        n'existait pas alors qu'il n'est pas utilis.

      - le bouton dans le suivi des jobs permettant d'arrter un calcul tout en
        conservant les bases (envoi du signal ``USR1``) est renomm **Arrter proprement**
        (anciennement **Interrompre USR1**)

      - le type "nom" est rptable.

      - un nouveau thme est disponible : **Lucid Ambiance** (ncessite l'extension
        ``tkpng`` pour afficher les icnes en pleine couleur, dfinir la variable
        ``TKPNG_ROOT`` dans ``profile_local.sh`` par exemple, cf. ``init.tcl``).

      - l'action **pre** (uniquement prparation de l'environnement) fonctionne pour les
        calculs en  MPI.

      - support du nombre de processeurs lors du lancement en batch (LSF, PBS, SunGE).

      - prise en compte du nombre de processeurs/noeuds lors de l'importation d'un cas-test.

      - commandes ``mpi_ini/mpi_end`` (fichier de configuration asrun) pour lancer
        des commandes avant/aprs le lancement en MPI.

      - argument supplmentaire pour la configuration du debugger (usage de nemiver
        possible, cf. fichier de configuration asrun).

   * fonctionnalits dveloppeur :

      - nouvelle option ``as_run --free_sub`` qui retourne un numro de routine libre.

      - correction dans la recherche des messages.

      - prparation de l'environnement pour une excution MPI oprationnelle
        (action **pre**).

Version 1.8.3 :

   * ct serveur (asrun) :

      - la version 1.8.2 ne fonctionnait pas sur les machines mono-processeurs mono-coeurs.

Version 1.8.2 :

   * Nouvelles fonctionnalits / corrections :

      - un clic-droit sur le bouton Supprimer (croix rouge) supprime toutes les
        lignes de la liste de fichiers courante.

      - le bouton Interrompre est intgr  la fentre principale (en bas  droite)

      - le type 'nom' est utilisable en donne.

      - l'argument dbgjeveux n'tait plus export depuis 1.7.2.

      - durant l'excution, les fichiers sont uniquement accessibles par le
        propritaire de l'tude. De mme pour les fichiers rsultats recopis en
        fin de calcul.

   * ct serveur (asrun) :

      - nouvelle option '--make_shared' pour produire une bibliothque dynamique
         partir de fichiers source fortran/C pour faciliter l'utilisation de
        comportement de type UMAT.

      - show/get traite les jokers (exemple : show ssnp125*.comm)


Version 1.8.1 :

   * Nouvelles fonctionnalits / corrections :

      - la fonction "Valeur par dfaut" retourne maintenant un chemin relatif
        au chemin de base (et non plus par rapport au nom du profil).

      - lors du rappatriement des rsultats, le rpertoire de destination est
        automatiquement cr s'il n'existe pas (fiche 14665).

      - si la copie des rsultats choue, les fichiers sont recopis dans un
        rpertoire temporaire indiqu par l'alarme <A>_COPY_RESULTS.

      - parfois "Rechercher" dans asjob n'affichait aucune ligne : cela se produisait
        quand l'encodage des caractres par dfaut n'tait pas iso-8859-1.

      - "importer un cas-test" n'utilisait pas la version slectionne.

      - initialisation incorrecte d'as_run (fichier $HOME/.astkrc/config vide).
        Dans ce cas, il faut supprimer le fichier, puis relancer.

      - astout/tude paramtrique : arrt au plus tt s'il n'y a pas de machine
        disponible, amlioration des informations affiches en cas d'erreur d'excution.

      - tude paramtrique : tous les fichiers en rsultat sont copis dans le
        rpertoire propre  chaque calcul.

      - utilisation possible des versions dfinies dans ~/.astkrc/config (fiche 14811).

      - SSH/SCP est maintenant le protocole par dfaut (au lieu de RSH/RCP).

   * ct serveur (asrun) :

      - Les fichiers fortran90 n'taient pas pris en compte lors de la gnration des ctags.

      - as_run --make clean ne fonctionnait que dans le rpertoire des sources et
        n'utilisait pas l'option --vers, et pouvait effacer la version entire !

      - le gestionnaire de travaux Sun Grid Engine n'tait plus utilisable.

      - l'option --rcdir de as_run ne prend plus un suffixe mais un nom de rpertoire
        complet (par dfaut en relatif par rapport  $HOME).

      - correction de quelques problmes d'encodage.

      - ajout de la mention DEJA RESTITUE DANS dans les histors.

      - excution de commandes avec suivi : le code retour tait toujours nul, l'option
        separated_stderr ne fonctionnait pas.

      - "as_run --info" retourne maintenant la version par dfaut (default_vers du fichier
        de configuration).

      - "as_run --get_infos" supporte l'option "--output" pour rcuprer le fichier de
        ressources.

      - la limite  10 fichiers de commandes dans un profil est leve (plus de limite,
        fiche 14814)

      - support mpi : lancement de plusieurs fichiers de commandes interdit, positionnement
        de l'environnement dans le script lanc par mpirun.

      - (sur la machine de rfrence) suppression systmatique des fichiers attachs
        aux fiches soldes.


Version 1.8.0 :

   * Nouvelles fonctionnalits / corrections

      - en cas d'arrt par manque de temps cpu, meilleure remonte du diagnostic

      - tude paramtrique (calcul distribu) :
         Dans le fichier distr, on dfinit les valeurs des paramtres avec ``VALE=...``
         (voir ci-dessous).

         On peut maintenant inclure un ensemble de commandes juste aprs DEBUT (resp.
         juste avant FIN) en utilisant les mots-cls PRE_CALCUL (resp. POST_CALCUL)
         qui acceptent une chaine de caractres contenant le morceau de jeu de
         commandes  insrer.

         On peut aussi utiliser UNITE_PRE_CALCUL (resp. UNITE_POST_CALCUL) qui accepte
         un entier correspondant  l'unit logique qui sera insre par INCLUDE.

         On peut maintenant sauvegarder les bases (base ou bhdf) dans le rpertoire de
         chaque calcul. Pour cela, il faut ajouter une entre de type 'base' ou 'bhdf'
         qui doit pointer vers le rpertoire des rsultats (attention  l'espace disque utilis !).

         On peut ensuite faire une poursuite distribue en basculant cette entre en "Donne".


      - astout : le facteur multiplicatif du temps n'tait plus pris en compte depuis
        la version 1.7.0.

      - timeout : ce paramtre introduit pour les astout et tudes paramtriques est
        dtermin automatiquement  partir des donnes du profil. Il est supprim de
        l'interface.

      - le mode interactif est rpar (-interact dans la ligne d'arguments, fiche 12874).

      - les problmes de dfilement des impressions devraient avoir disparus.

      - "astk --import fichier.export" permet d'importer un profil au dmarrage.

      - dans le suivi des jobs, "Rechercher" ne fonctionnait plus depuis 1.7.8.

   * ct serveur :

      - Correction lors de la suppression des fichiers fortran90.

      - as_run --messages : amlioration de la recherche des messages inutiliss ou
        inexistants dans le source.

      - ``as_run --astk_update`` / ``as_run --auto_update`` : on tlcharge d'abord un fichier
        contenant les versions disponibles, puis on rcupre les versions plus rcentes
        s'il y en a.

      - L'option ``--version_dev=...`` est dprcie, utilisez ``--vers=...``

      - En mpi, le fort.6 n'tait pas rempli.

      - Ajout de deux paramtres dans ``etc/codeaster/asrun`` : ``mpi_ini`` et ``mpi_end``
        pour initialiser et terminer la session MPI. Ncessaire pour des implmentations
        MPI comme Mpich2 (mpdboot / mpdallexit).

      - ``as_run --auto_update --keep_increment`` : gre correctement les paquets "-2".

   Le changement de version s'explique par le rarrangement des fichiers sources de
   l'interface (astk), de la partie serveur (as_run) et du script d'installation.

   * interface :

      - l'application est installe dans lib/astk, les fichiers de configuration dans
        ``etc/codeaster/astkrc``.

   * ct serveur :

      - dplacement des fichiers sources : ``ASTK/ASTK_SERV/bin`` devient ``bin``,
        ``ASTK/ASTK_SERV/conf`` devient ``etc/codeaster``, ``ASTK/ASTK_SERV/lib`` devient
        ``lib/pythonX.Y/site-packages/asrun``.

      - le fichier de configuration est spar en deux parties principales : config
        devient asrun (majeure partie du fichier config) + aster (versions de *Code_Aster*
        disponibles) + fichier agla sur le serveur de rfrence.

      - lors des mises  jour, l'installation prcdente est sauvegarde dans
        ``share/codeaster/backup_`indice de la version prcdente`/...``


version 1.7.12 :

   * version intermdiaire pour permettre la migration en version 1.8.0.


version 1.7.8 :

   * interface :

      - choix automatique du type lors de la slection d'un fichier (fiches 13541 et
        13596) : permet par exemple que le type 'mmed' soit choisi sur slection d'un
        fichier ".med", type "hist" sur un fichier "histor"...

   * ct serveur :

      - as_run --list : 'liste_test' est un critre autoris.
         Par exemple pour extraire les tests de la liste restreint ::

            as_run --list --all --filter='liste_test == "R"'


      - astout/tude paramtrique :
         . en cas d'chec lors de la soumission d'un cas, la liste tait interrompue.
         . des conflits sur les rpertoires temporaires pouvaient survenir.

      - lancement en batch : correction en cas de soumission dans une liste de classes,
        et en cas de lancement d'tude paramtrique sur la machine de rfrence.


Version 1.7.6 :

   * lancement de cas-test : l'excution n'tait pas interrompue mme quand le nombre
     maximum d'erreurs tait atteint (anomalie 13544).

   * problme d'import du module utils.py (anomalie 13529).

   * la compilation tait lance en squentielle, mme sur une machine comportant
     plusieurs processeurs.

   * correction de la suppression d'un fichier particulier d'un cas-test (tout le
     test tait supprim).


Version 1.7.4 :

   * corrections pour le lancement d'tude paramtrique en batch sur la machine
     de rfrence


Version 1.7.3 :

   * ct serveur :

      - correction des problmes de dfilement saccad des excutions.

      - Etude paramtrique, lancement de cas-tests :
         - nouveau paramtre flashdir pour indiquer o copier les fichiers
           output/error des excutions ou de ne pas les conserver. Exemples :
           "P flashdir /path/to/flash/directory" ou "P flashdir None". Si
           flashdir est absent (cas du lancement via l'interface), "flash" est
           cr dans le rpertoire des rsultats (repe ou resu_test selon le cas).

      - unigest : possibilit de ne supprimer qu'un seul fichier d'un cas-test.
        Exemple : TESSUPPR rccm02a.com2

      - suivi de l'excution : il faut fournir dans le fichier export soit le
        paramtre xterm (qui est utilis tel quel, ce que fait l'interface astk),
        soit les paramtres follow_output et display (et dans ce cas, c'est terminal
        dfini dans le fichier ASTK_SERV/conf/config qui est utilis).

      - lancement de cas-tests :

         - paramtre facultatif pour crire le diagnostic dans un fichier.
           Ex. "P diag_pickled /path/to_diag_pick"

         - l'argument --only_nook permet de ne lancer que les tests non ok
           (en ligne de commande uniquement)


Version 1.7.1 :


   * Diagnostic erron si l'output contient des caractres binaires : le diagnostic
     est alors <F>_ERROR alors que le calcul est correct.

   * correction pour l'enregistrement dans la base de donnes d'tudes (on n'est plus
     oblig d'enregistrer le profil avant)

   * as_run --show/--get : fonctionne si on ne donne pas d'extension. Par exemple :
     "show AbcdE" cherche 'abcde.f' dans bibfor, bibf90 et 'AbcdE.py' dans bibpyt.
     Il n'y a pas d'erreur si aucun n'est trouv.
     Permet d'associer un raccourci clavier dans son diteur favori pour faire un
     "show" sur la slection courante (comme on peut le faire avec les ctags si
     l'diteur le supporte).

Version 1.7.0 :

   * Nouvelle fonctionnalit : tude paramtrique, calcul distribu

     Lancement d'une tude paramtrique en fournissant un fichier de type 'distr' en
     donne, un rpertoire en rsultat (type 'repe') et en choisissant "distrib = oui"
     dans le menu Options. La syntaxe du fichier de paramtre est la suivante ::

          VALE = (
              _F(P1=val11, P2=val12, ..., Pn=val1n),  # calcul 1
              _F(P1=val21, P2=val22, ..., Pn=val2n),  # calcul 2
              ...
              _F(P1=val31, P2=val32, ..., Pn=valpn),  # calcul p
          )


     L'tude est quelconque. Les paramtres fournis sont remplacs dans tous les
     fichiers de commandes de l'tude (type 'comm', pas les includes) sous rserve
     qu'ils respectent l'expression rgulire : ``^ *Pi *=.*$`` o Pi est le nom du
     paramtre (Pi est prcd de 0 ou N espaces, un signe '=', puis la valeur).
     Les rsultats de l'tude doivent tre crits dans REPE_OUT.
     Exemple ::

          DEFI_FICHIER(UNITE=50, FICHIER='./REPE_OUT/xxxx.med')
          IMPR_RESU(FORMAT='MED', UNITE=50, ...)

     Dans le rpertoire de rsultat (type 'repe'), on trouvera un rpertoire flash
     qui contient les traces des excutions (fichiers output, error, export) et un
     rpertoire par calcul (calc_01  calc_0p) qui contiennent les fichiers de
     commandes modifis et les rsultats (copie du "REPE_OUT" de chaque calcul).

     Le calcul distribu est pris en charge par le serveur slectionn (Machine exc) puis
     rparti sur les ressources disponibles selon :


        - un fichier de type 'hostfile' fourni

        - ou le fichier dfini dans la configuration du serveur (ASTK_SERV/conf/config,
          cl batch_distrib_hostfile ou interactif_distrib_hostfile)

        - ou les caractristiques de la machine slectionne (nombre de cpu, mmoire).

     Le paramtre 'timeout' (menu Options) dfini le temps d'attente maximum d'un calcul
     avant d'tre soumis (dlai maximum entre deux soumissions). Pass ce dlai,
     l'excution de ce calcul est annule (diagnostic <F>_NOT_RUN). Ce paramtre est
     rclam par l'interface.
     La valeur du timeout doit tre suprieure au plus long des calculs (2-3 fois
     cette dure semble une bonne valeur).

     Attention : il est trs facile d'effondrer une machine en mettant des paramtres
     inadapts dans le 'hostfile'. Il est recommand de laisser le choix automatique
     ('hostfile' du fichier config). Consulter l'administrateur du serveur au pralable !


   * Nouvelle fonctionnalit : astout distribu

      - le lancement d'une liste de cas-test est galement distribu selon la mme
        mthode que pour les tudes paramtriques. Voir ci-dessous pour la rpartition
        des cas-tests selon les ressources disponibles (fichier 'hostfile').
        Le paramtre timeout est galement obligatoire (cf. ci-dessus).


   * Nouvelle fonctionnalit dveloppeur : excuter *Code_Aster* via un outil tiers sur
     un profil d'tude

      - on peut lancer directement un outil comme valgrind sur une tude. Il suffit
        de choisir "exectool = nom_outil" dans le menu Options.

        La commande utilise est prise dans le fichier ASTK_SERV/conf/config. Si
        'nom_outil' n'est dfini dans le fichier config, 'nom_outil' est considr
        comme une ligne de commande. Ceci est compatible avec une surcharge.
        Exemple : exectool=valgrind --tool=memcheck
        ou 'memcheck : valgrind --tool=memcheck' dans ASTK_SERV/conf/config et exectool=memcheck


   * Nouvelle fonctionnalit dveloppeur : importer un cas-test

      - ajout d'une option dans le menu Fichier/Importer... : possibilit d'importer
        un cas-test (ncessite de slectionner un serveur avec astk 1.7.0 ou +). Lit
        galement les paramtres du calcul (temps/mmoire).


   * Nouvelle fonctionnalit dveloppeur : surcharge python

     Quand on met un rpertoire de fichier python en surcharge, on cherche dornavant
     les fichiers `*.py` dans les sous-rpertoires rcursivement.


   * ct serveur :

      - as_run --get_export nom_cas_test : affiche un fichier .export (utilis par
        Fichier/Importer.../cas-test). On suppose que tous les fichiers du test sont
        utiliss en donne.

      - le code retour de l'excution est rcupr pour diagnostiquer d'ventuels
        problmes aprs la commande FIN.

      - utilisation de threads pour la lecture des sorties stdout/stderr des commandes

      - protection contre des crations concurrentes des rpertoires temporaires
   * la version 1.6.5 ne pouvait plus se mettre  jour toute seule !

Version 1.6.5 :

   * interface :

      - sparation des prfrences en deux dans Configuration/Prfrences puis Gnrales
        et Rseau.

      - possibilit de fixer la variable DISPLAY pour l'affichage des applications
        externes : menu Configuration/Prfrences/Rseau. Attention : utiliser cette
        option en connaissance de cause et uniquement si la valeur par dfaut ne convient
        pas. Laisser le champ vide pour laisser astk dterminer seul le DISPLAY
        (en fonction de sa valeur au lancement d'astk, du nom de domaine...).

      - improvements in english translations (thanks to JMB).

   * ct serveur :

      - correction de plusieurs anomalies lors du lancement en batch (hors serveur
        de rfrence).

      - amlioration du lancement MPI (reste exprimental = en phase de test)

      - correction de l'affichage de la plate-forme dans le fichier output (.o du flasheur)

      - amlioration du diagnostic lors du lancement des cas-tests

      - lors de la mise  jour de *Code_Aster* (--auto_update) les mises  jour d'astk
        sont automatiquement cherches (quivalent de -astk_update).

      - la fonction "as_run --messages check" accepte des rpertoires en surcharge et
        un fichier unigest.


Version 1.6.3 :

   * correction de la compilation des catalogues d'lments en mmoire dynamique


Version 1.6.2 :

   * ajout du lancement en MPI en interactif (exprimental = en phase de test) :

      - interface :
         on dfinit mpi_nbnoeud (nombre de noeuds) et mpi_nbcpu (nombre de processeurs)
         dans le menu Options.

      - ct serveur :
         Il est ncessaire d'ajouter les paramtres MPI dans le fichier de configuration
         (ASTK/ASTK_SERV/conf/config) : mpirun_cmd, mpi_hostfile, mpi_get_procid_cmd,
         mpi_nbnoeudmax, mpi_nbcpumax et shared_tmp. Voir l'exemple dans le rpertoire
         conf.new cr au moment de la mise  jour.
         Dans le fichier config.txt, il faut dplacer les flags de pr-compilation sur
         une ligne DEFS (sans les "-D", au lieu des lignes OPTC_x, OPTF_x et OPTF90_x).
         Par exemple ::

           DEFS | defined | - | LINUX _USE_MPI _HAVE_MUMPS _USE_MPI_MUMPS _USE_MPI_FETI

         La prparation de l'environnement est  amliorer (problmes attendus si
         beaucoup de processeurs), l'excution est faite dans un rpertoire partage
         par tous les processeurs ds qu'il y a plus d'un noeud.

         as_run peut lancer la compilation (surcharge ou construction complte d'aster)
         en parallle. Pour cela, il faut ajouter un paramtre dans
         ASTK_SERV/bin/as_run : para = {..., 'multi_threading' : True }.
         NB : il existe une anomalie dans certaines versions de python. En cas
         de problme, dsactiver cette possibilit.


Version 1.6.1 :

   * l'outil de conversion de maillage (accessible par clic droit sur un maillage)
     ne fonctionnait pas.


Version 1.6.0 :
   Ce changement de numro de version s'explique par des modifications significatives
   dans ASTK_SERV, la partie qui lance les calculs. Il y a peu d'volutions dans la partie
   interface.
   La compatibilit ascendante est assure : une interface en version 1.5 peut appeler des
   services 1.6 (mais l'interface 1.6 ne peut pas utiliser un serveur 1.5).

   - interface :

      * meilleure rcupration en cas d'erreur des services


      * meilleure dtection du mode local/distant pour viter de tenter des
        commandes "rsh/ssh" alors que l'interface et le serveur sont sur la mme machine.

   - ct serveur :

      * as_serv est remplac par as_run qui devient l'unique point d'entre.
            astk 1.5 : as_serv as_exec [options] fichier.export
            astk 1.6 : as_run --serv [options] fichier.export


      * --diag : possibilit d'crire le bilan dans un fichier pickled.


      * support de l'extension .F pour le fortran 90 (compilation, mise  jour).

   - utilisation depuis Salom :

      * gestion cohrente du rpertoire de ressources ($HOME/.astkrc_'suffixe') pour bien
        sparer les configurations "dans Salom" / "hors Salom".


Version 1.5.5 :

   - corrections mineures

Version 1.5.4 :

   - ct serveur (as_run) :

      * utilisation de l'option --messages :
         as_run --messages check       : vrification des catalogues et impression de statistiques
         as_run --messages move        : dplace un message d'un catalogue dans un autre et modifie les fichiers sources concerns
         as_run --messages CONTACT_12  : imprime la liste des fichiers sources utilisant ce message
         as_run --messages op0001.f    : imprime les messages appels par ce fichier source

      * outil dveloppeur : option --keep_increment de auto_update pour construire et conserver tous les incrments de mise  jour

Version 1.5.3 :

   - conversion en base HDF : la base hdf produit l'est sur la meme machine que la base initiale.

   - ajout de l'option --rcdir pour modifier le rpertoire des ressources (.astkrc par dfaut)

   - ct serveur (as_run) :

      * outil dveloppeur pour extraire des informations des catalogues de messages :
        as_run --messages

      * outil dveloppeur pour construire des listes de cas-test : as_run --list

      * correction du diagnostic de l'excution en cas d'arret par manque de temps CPU

      * fichier .code recopi dans un astout

Version 1.5.2 :

   - quantit de mmoire utilise pour un calcul : l'option mem_aster disparait du menu
     Options. Dans la fentre principale, on saisit la mmoire totale ncessaire au
     calcul (demande au gestionnaire de batch) et, en cochant la case prvue, la partie
     qui sera prise par le premier calcul Aster (le reste tant disponible pour des
     outils externes appels par Aster ou des calculs Aster esclaves...). Le paramtre
     mem_aster est toujours disponible dans le fichier '.export'.

   - disponible sur le serveur de rfrence seulement : menu "Fichier/Enregistrer
     dans la base d'tude..." permet d'ajouter le calcul courant dans la base de donnes
     d'tude en tant qu'excution d'une tude existante.

   - menu Fichier/Importer/.export astk (mode ajout) : contrairement  l'import classique
     qui part d'un profil vierge, les fichiers et rpertoires prsents dans le
     fichier .export sont ajouts au profil actuel. Les paramtres et arguments
     sont ignors. Cela permet par exemple d'importer une tude dans un profil de surcharge.

   - menu Option/Option de lancement : ajout des paramtres mpi_nbcpu et mpi_nbnoeud
     pour les calculs utilisant MPI. NB : ncpus est utilis pour les excutions en OpenMP.

   - mise  jour d'astk (option --astk_update d'as_run) : correction d'un problme sur
     la commande wish.

   - possibilit de spcifier un rpertoire des "ressources" autre que $HOME/.astkrc
     avec l'option --rcdir (voir astk --help).

   - volution du mode de lancement d'Eficas quand on est dans l'environnement Salom.

   - correction de la conversion de base au format HDF.

   - les caractres accentus taient mal transmis lors de l'mission d'une fiche depuis astk.

   - ct serveur :

      * traitement du type mmed dans les astout.

      * ajout de l'option --diff pour voir le fichier de diffrence d'un fichier
        source (il faut videmment que les fichiers de diff soient disponibles dans
        les rpertoires convenus comme sur la machine de rfrence).

      * lors de l'enchainement des fichiers de commandes multiples, on exploite
        les informations produites par *Code_Aster* (fichier 'info_cpu') sur le temps
        cpu restant pour adapter le paramtre 'tpmax' de l'excution suivante.

      * ajout de l'option --list pour gnrer une liste de cas-tests  partir de
        nom de commandes et mots-cls utiliss, de critre sur les paramtres du
        test ou de filtre utilisateur.

Version 1.5.1 :

   - dans SURCHARGE :

      * volution pour la compilation de fichiers C avec surcharge des fichiers includes

      * possibilit de surcharger le code avec des packages Python inconnu de
        bibpyt (nouveau package)

   - ct serveur (as_run) :

      * affichage du temps "elapsed" de chaque test lors d'un astout

   - intgration des fichiers d'aide en ligne (menu Aide) traduits en anglais par JMB.

Version 1.5.0 :

   - fentre d'informations au lancement (motd 'message of the day')

   - interface avec le rex et fichiers histor :

      * traitement correct des chaines accentues.

   - mise  jour en ligne (version bta) avec : as_run --astk_update

Version 1.4.8 :

   - dans SURCHARGE :

      * types c/f/f90 : s'il y a des fichiers "include", il faut que le source qui
        les importe soit dans le mme rpertoire lors de la surcharge ; il ne peut pas
        y avoir uniquement des fichiers "include".

   - corrections ct serveur :

      * --show/--get : mission incorrecte d'une alarme concernant la connexion au
        serveur de rfrence.

      * diagnostic enrichi pour remonter les erreurs de syntaxe dans les fichiers de commandes.

      * remonte d'erreur pour faciliter le diagnostic lors de la compilation du
        catalogue d'lments.

      * arguments rservs dans le fichier .export : prep_env, copy_data,
        copy_result et detr_rep_trav (existait dj).

      * auto_update : risque d'incohrence en cas de mise  jour de deux versions
        diffrentes simultanment (par exemple NEW7 et NEW8).

Version 1.4.5 :

   - menu contextuel des listes de fichiers : ouverture de l'explorateur de fichiers
     dans le rpertoire du fichier slectionn.

   - recopie des fichiers .resu et .erre dans le fichier .o (output) lors de
     l'excution d'un cas-test.

   - ajout de flches dans le profil d'tude pour dplacer des entres dans la
     liste (utile pour l'ordre d'excution des .comm).

   - dans ETUDE :

      * nouveau type 'nom' permettant de rcuprer n'importe quel fichier  la
        racine du rpertoire de travail. Exemple : /home/etude/gmon.out contiendra
        le fichier gmon.out du rpertoire de travail... s'il a t produit par l'excution !

      * le type 'para' permet de rcuprer un fichier .para type pour un cas-test
         partir des paramtres de l'tude courante.

   - une nouvelle slection de couleurs et icnes (inspires du thme Crystal de KDE).

   - prise en charge des fichiers include (``*.h``) dans la mise  jour des versions
     locales (``as_run --auto_update``).

   - menu Options : nouvelle option 'corefilesize' pour limiter la taille du fichier
     core cr (0 : pas de core file, unlimited : taille non limite).

   - recopie de l'histor lors des mises  jour.

   - suppression des import/export asterix.

   - as_run :

      * --ctags : nouvelle option permettant de gnrer les ctags  partir des
        sources fortran, C et Python.

      * --auto_update : l'option --ctags est appele  la fin de la mise  jour
        (si la commande ctags est trouv bien sr !).

      * --show : En local, l'dition est faite en place directement dans le
        rpertoire des sources sans recopie dans un rpertoire temporaire (permet
        d'exploiter plus facilement les ctags gnrs lors des mises  jour des
        versions locales).

Version 1.4.4 :

   - verrou sur l'mission de fiche avec surcharge.

   - correction dans la recopie du catalogue de commandes compil.

Version 1.4.3 :

   - correction d'une erreur lors de la surcharge des catalogues de commandes
     (il fallait lancer l'tude et la surcharge en mme temps).

   - sur la machine de rfrence : en batch un message avertit qu'il faut faire
     la surcharge et lancer l'tude en deux temps.

Version 1.4.2 :

   - corrections ct serveur (astout diagnostic des cas-tests).

Version 1.4.1 :

   - corrections/volutions ct serveur uniquement

Version 1.4.0 :

   - Menu "Ouvrir avec..." revisit :

      * Post-traitement avec *Code_Aster* (Stanley)

      * Convertisseur de maillage : convertit des maillages de type .mail, .msh,
        .mgib, .msup, .med

      * Convertir au format HDF : convertit une base *Code_Aster* (glob.1) au
        format HDF (bhdf.1)

      * Editeur de fichiers de commandes (Eficas)

     La conversion de maillage et de base ne fonctionne que sur un serveur en
     version 1.4 ou mieux.

Version 1.3.4 :

   - compilation des catalogues d'lments avec un unigest : corrig.

   - dans ETUDE : type datg (donnes gomtriques) associ  l'unit 16.

   - option --no-initial-warnings pour supprimer les fentres d'alarme au lancement
     de l'interface ( n'utiliser que pour contourner un bug Qt quand astk est lanc
     depuis Salom).

   - option --no-splash pour supprimer la fentre de dmarrage (mais on perd la
     possibilit d'interrompre la rcupration des informations des serveurs).

   - ajout de l'entre Fermer dans le menu Fichier.

   - configuration par dfaut lors de l'installation : islocal=oui pour le
     serveur o on fait l'installation.

   - ct serveur :

         * gnration des histors en html : retour chariot manquant.

         * alarme inopine sur le fichier .para lors d'un astout.

Version 1.3.3 :

   - dans Configuration/Serveurs, on peut cocher une case pour indiquer que le
     serveur est sur la mme machine que l'interface. Dans ce cas, avant mme de
     faire des tests sur les noms de machines, les communications client/serveur
     se feront en direct sans passer par le rseau.

   - intgration d'astk dans Salom : l'options ORBInitRef permet  l'excution
     *Code_Aster* d'appeler les services fournis par Salom.

   - quand on prpare l'environnement d'une excution (Lancer + "pre"), on trouve
     dans l'output les commandes pour lancer *Code_Aster*  la main, on trouve aussi les
     commandes pour lancer le calcul dans le debugger Python (pdb).

   - dans certains cas, les jobs n'taient pas arrts quand on cliquait sur "Supprimer".

   - mme anomalie avec "Interrompre USR1".

   - ct serveur : as_run : possibilit de dfinir le rpertoire de travail
     (rep_trav) et de ne pas le dtruire en fin d'excution (detr_rep_trav non).
     Attention  l'encombrement du disque dur !

Version 1.3.0 :

   - nouveau menu dans la fentre des jobs : "Purge flasheur" permet de supprimer
     les fichiers inutiles de vos rpertoires flasheur sur les diffrents serveurs.

   - la prselection du type utilise aussi le nom du rpertoire.

   - machine de rfrence :

      * rex : uniquement l'mission de fiche est possible depuis astk, pour consulter
        les fiches REX et y rpondre il faut utiliser un navigateur pour se connecter
        au serveur roundup.

      * Fichier/Importer.../.export d'une fiche : importe le profil associ  une
        fiche du rex  partir de son numro d'index.

Version 1.2.5 :

   - suite  la modification des prfrences dans Configuration/Interface, le nom
     de serveur "Local" pouvait tre incomplet (sans le nom de domaine) et donc
     conduire  problmes de connexion avec les serveurs distants.

   - possibilit d'arrter un job avec rcupration de la base (envoi du signal
     USR1) : bouton droit+Interrompre sur un job de la liste.

   - asjob n'est plus mis systmatiquement en avant-plan.

   - possibilit d'activer/dsactiver le bip dans asjob via le menu Configuration/Interface.

   - ct serveur :

         * valeurs par dfaut pour rep_mat et rep_dex : respectivement materiau
           et datg sous le rpertoire de la version utilise (possibilit de les
           surcharger dans le menu Options, ou le fichier config.txt de la version).

         * la compilation du catalogue d'lments s'arrtait systmatiquement en
           erreur si l'excutable tait surcharg.

         * on ne pouvait pas lancer une surcharge avec uniquement du fortran 90.

   - exprimental : passerelles Salom-astk concernant la liste de fichiers du profil.

Version 1.2.4 :

   - si une unit logique diffrente de 1 est associ  un fichier de type comm,
     on bascule au type libr au moment de l'export du profil.

   - surcharge du fortran 90 pas prise en compte.

   - sur la machine de rfrence : dnotation impossible depuis l'introduction
     du fortran 90 (1.2.2).

Version 1.2.3 (2005/04/06) :

   - f90 est coch/dcoch automatiquement comme les types f et c.

   - anomalie corrige dans la gestion des arguments passs sur la ligne de
     commande de *Code_Aster*.

   - mise  jour des versions de dveloppement : gestion de la mise  jour de fermetur.

Version 1.2.2 (2005/03/10) :

   - ajout du type f90 (Fortran 90) pour des modules optionnels (toutes les
     particularits du Fortran 90 ne sont pas gres).

   - erreur corrige en cas de surcharge par des fichiers Python.

   - bsf : avertissement quand on rencontre un nom de fichier contenant des espaces.

   - ct serveur :

         * lors du lancement d'une liste de test, le paramtre mmoire fourni 
           *Code_Aster* tait incorrect (facteur 1.e6 dans ce cas, *Code_Aster* prenait 64 Mo par
           dfaut) d'o des <S>_ERREUR non justifies.

         * ajout d'un contrle des limites temps, mmoire au moment de l'excution
           (ce n'tait vrifi qu'au moment de la soumission).

         * possibilit de dfinir rep_outils, rep_mat, rep_mat dans le fichier config.txt.

         * prise en compte des sources f90 (compilation, mise  jour) et de
           modules optionnels.

Version 1.2.1 (2005/01/20) :

   - prise en compte de la surcharge au lancement de Stanley.

   - lancement du service as_run " la main", il n'est plus ncessaire de faire
     le source du fichier ``aster_profile.sh`` (``as_run`` le fait).

   - anomalie corrige : la variable DISPLAY crire dans le fichier .export tait incorrecte.

   - anomalie corrige : en cas d'erreur <S>, le diagnostic tait quand mme OK.

   - anomalie corrige : l'option --check ne fonctionnait plus.

   - anomalie corrige : la liste des tests peut tre locale ou distante.

Version 1.2.0 (2005/01/07) :

   - nouveaut : asjob : en cliquant avec le bouton droit sur un ou plusieurs jobs
     slectionns, on peut en particulier actualiser uniquement les jobs slectionns.

   - volution : Stanley : transmission de la variable DISPLAY utilise par le client ;
     si plusieurs bases sont disponibles dans le profil, on prend en priorit la base
     slectionne (en cliquant dessus avec le bouton gauche ou droit).

   - si on slectionne un fichier nomfic.56, le type est fix  'libr' et l'unit  56.

   - anomalie corrige : le nom de la base ne contenait pas user@machine quand la base
     n'est pas sur la machine de calcul.

   - volution mineure : on dsactive automatiquement un serveur qui dsigne la mme
     machine (avec le mme login) qu'un serveur prcdent.

   - types de fichier dans Etude : nouveau 'digr' (unit 26), 'gnu' supprim.

   - support du squenceur de travaux Sun Grid Engine.

   - fichier de configuration ct serveur plus complet, ajout de fonctionnalits de
     mises  jour via as_run.

   - en cas de .comm multiples, sauvegarde et restauraion de la dernire base correcte
     (dans BASE_PREC) en cas d'erreur dans les fichiers suivants.

Version 1.1.4 (2004/09/24) :

   - ajout/suppression de l'extension .gz quand on change le type d'une entre de la
     liste des fichiers (avant on ne le faisait que quand on cochait/dcochait le
     bouton Compress).

   - ajout du type 'dat' (unit par dfaut 29).

   - le nom du chemin de base s'ajuste en fonction de la largeur disponible.

   - anomalie corrige : une instruction ne fonctionnait pas avec python2.1 lors du
     lancement de Stanley.

   - anomalie corrige : en cas d'chec de l'enregistrement d'un profil, le message
     est plus clair (de plus, lorsqu'on lanait un calcul, l'erreur passait inaperue
     et on tait arrt plus loin).

   - anomalie corrige : erreur lors de la suppression du dernier serveur de la liste.

   - bsf : anomalie corrige : avec les slections multiples (touches CTRL et SHIFT),
     il se produisait parfois des erreurs TCL et la slection graphique tait incohrente
     avec le nom des fichiers slectionns.

   - asjob : anomalies corriges : des erreurs TCL se produisaient si on demandait 
     actualiser la fentre des jobs alors qu'une actualisation tait dj en cours ou
     bien quand le fichier contenant les infos des jobs tait endommag.

   - ct serveur :

         * la copie du fort.6 (pour rcuprer les infos en cas de problme) est place
           dans le rpertoire de travail (rep_trav de config, rep_tmpsrv est supprim).

         * on peut ajouter un fichier d'environnement (pour positionner des variables
           comme LD_LIBRARY_PATH...) dans ASTK_SERV/conf.

Version 1.1.3 (2004/08/24) :

   - ajout d'un mode DHCP : si le nom de la machine cliente n'a pas pu tre rcupr,
     on essaie de rcuprer l'adresse IP de la machine (Linux ou Solaris), sinon on
     peut spcifier cette adresse via le menu Configuration/Interface. Pour basculer
     du mode DHCP au mode normal, il suffit de cocher/dcocher la case 'mode DHCP'
     dans Configuration/Interface.

Version 1.1.2 (2004/06/10) :

   - changement des valeurs par dfaut (clic droit sur un nom de fichier), notamment
     pour le type 'libr' o l'on reprend le numro de l'unit logique.

   - Stanley sur des bases HDF fonctionne  partir de *Code_Aster* 7.3.8.

   - ajout d'un test de connexion vers le noeud de calcul avant soumission d'un calcul.

   - ajout d'un traitement des codes retour de la soumission (plus de cas
     particuliers traits).

   - anomalie corrige : quand on supprimait un serveur, la configuration des
     serveurs suivant dans la liste tait dcale.

   - anomalie corrige : ceci ne fonctionnait plus depuis 1.1.0 : surcharge : quand
     on dcoche la case 'Rsultat' d'un excutable, on dcoche automatiquement les
     sources C et Fortran (comportement analogue pour les cmde/capy et ele/cata).

Version 1.1.1 (2004/05/19) :

   - prise en compte du fichier pickle associ aux bases de calcul.

   - ajout du type bhdf (base au format HDF gres comme les bases *Code_Aster* standards).

   - traitement des bases HDF par Stanley (appel automatiquement depuis astk).

   - ncessite run_aster 2.33.

Version 1.1.0 (2004/05/06) :

   - construction de l'ihm revue :

      - la fenetre principale est redimensionnable.

      - on utilise quelques objets du package BWidget (voir A propos...) qui est
        fourni avec astk.

      - la librairie TkTable n'est plus utilise.

   - le lancement du debugger en interactif ("dbg") implique "suivi interactif".

   - choix des polices de caractres utilises (Configuration/Polices...).

   - on peut conserver la gomtrie de la fentre principale d'une session  l'autre.

   - lancement de Stanley directement  partir d'une base transparent quelque soit
     la version de *Code_Aster*.

Version 1.0.27 (2004/03/29) :

   - 'ETUDE' est coche par dfaut pour chaque nouveau profil.

   - ajout de raccourcis clavier dans le menu Fichier (par ex: Ctr+Q pour quitter).

   - surcharge : quand on dcoche la case 'Rsultat' d'un excutable, on dcoche
     automatiquement les sources C et Fortran (comportement analogue pour les
     cmde/capy et ele/cata).

   - asjob : ignore les jobs tournant sur des machines dont l'tat a t mis  "off".

   - bsf : la liste des rpertoires rmanents est configurable (clic-droit sur la
     liste, puis Configuration) : possibilit de "fixer" des rpertoires, d'en ajouter,
     supprimer...

   - anomalie corrige : l'interface ne dmarrait pas si aucune version n'est disponible.

   - sur la machine de rfrence : lancement de tests : interdit en interactif, en batch
     un message avertit qu'il faut faire la surcharge et lancer les tests en deux temps.

   - anomalie connue : quand on supprime un serveur, la configuration des serveurs
     suivant dans la liste n'est pas correctement dcale. Solution de contournement :
     raffraichir la configuration de chaque serveur.

Version 1.0.26 (2004/03/02) :

   - anomalie corrige : on obtenait '<F>_ERREUR_SYSTEME' en interactif quand le suivi
     n'tait pas activ.

   - Stanley appelable d'un simple clic droit sur une base. Pour le moment les bases
     au format HDF ne sont pas traites automatiquement, il faut donc que la base ait
     t cre sur la mme machine que celle qui va lancer Stanley.

Version 1.0.25 (2004/01/21) :

   - quand un nom de fichier ou rpertoire contient un caractre interdit (comme un
     espace), on avertit plus clairement l'utilisateur.

   - l'extension ".gz" est automatiquement ajoute/retire quand on coche la case de
     compression.

   - lancement de tests : en cas de surcharge, on vrifie que l'excutable et les
     catalogues sont sur la machine d'excution.

   - le suivi interactif maintenant disponible pendant la surcharge, et le lancement
     des tests (ncessite run_aster 2.28).

   - anomalie corrige : type de plate-forme non reconnu quand le fichier de
     configuration n'a pas t renseign.

   - anomalie corrige : blocage quand on demandait les proprits d'un
     fichier/rpertoire depuis la bsf.

   - anomalie corrige sur la machine de rfrence : cration/suppression d'une forlib.

Version 1.0.24 (2003/12/15) :

   - options de lancement supplmentaires (menu Options) : possibilit de spcifier
     une classe batch particulire, une heure de dpart, le nombre de processeurs.

   - en batch, on peut forcer le temps et la mmoire au del des limites imposes
     par le serveur (sauf  spcifier une classe particulire, le calcul risque de
     ne pas tre soumis).

   - pour une tude, on retrouve le fichier .export dans le rpertoire de travail
     (ncessite run_aster 2.27).

   - prcision dans l'aide au sujet des commandes d'impression.

   - pour les fichiers/rpertoires en donnes, on vrifie que l'on fournit bien un
     fichier l o on attend un fichier et un rpertoire l o on attend un rpertoire.

   - les couleurs et la taille de police sont modifiables, menu Configuration/Couleurs
     et Configuration/Taille de police.

   - import d'un fichier .export : suppression des <INFO> si le type est libre.

   - sur la machine de rfrence : on peut maintenant prciser le nom de la 'forlib'
      crer ou  supprimer.

Version 1.0.23 (2003/11/28) :

   - BSF, Eficas, Gibi, Gmsh, Grace sont configurs par dfaut,  l'administrateur de
     les retirer de la config s'ils ne sont installs.

Version 1.0.22 (2003/11/19) :

   - "Valeur par dfaut" tient compte du nom du serveur o est enregistr le profil.

   - on pouvait avoir un excutable en rsultat sans fournir de sources C ou fortran :
     risque d'erreur, on vrouille ce comportement.

   - asjob : en cas de suppression de jobs PEND ou RUN, si on ne confirme pas la
     suppression, le job n'tait pas arrt mais il disparaissait de la liste.

   - bsf : erreur corrige lors du lancement d'un outil (diteur, Eficas...).

   - prise en compte de facmtps, nbmaxnook, cpresok lors du lancement de test en
     interactif (ncessite run_aster 2.26).

Version 1.0.21 (2003/11/04) :

   - la modification du nom de domaine est prise en compte immdiatement, il n'est
     plus ncessaire de relancer ASTK.

   - asjob : limitation des communications avec les serveurs en regroupant les
     oprations pour la suppression des jobs.

   - ajout du nom de la machine cliente et de l'utilisateur dans l'output des jobs.

   - affichage de la fentre des messages au lancement si le niveau de message non nul.

Version 1.0.20 (2003/10/10) :

   - anomalie introduite en 1.0.19 corrige : problme d'affichage, le DISPLAY tait
     mal dfini avec le nom de domaine.

   - le choix "debug" est slectionn par dfaut si l'on choisit le mode de lancement
     "debugage" ou "prparer l'environnement".

Version 1.0.19 (2003/10/07) :

   - le nom de domaine de la machine locale est paramtrable par le menu
     Configuration/Interface (car le nom complet de la machine est ncessaire pour
     que les machines distantes puissent contacter la machine locale).

   - "Copier sous" (copie d'un profil) ne copie que les fichiers ou rpertoires en
     (D)onne ou (R)sultat.

   - le fichier .export est copi dans le rpertoire d'excution.

   - avertissement si une commande retourne un warning sur le quota.

   - bsf : possibilit de masquer les rpertoires en passant par le menu
     "Affichage/Masquer les rpertoires".

Version 1.0.18 (2003/09/09) :

   - possibilit d'importer un fichier .export et construire le profil associ
     (menu Fichier/Importer/astk_serv).

   - sur la machine de rfrence : lors de l'mission d'une fiche avec fichiers
     joints, un fichier .export est cr (directement importable par astk) + correction
     d'une anomalie.

   - sur la machine de rfrence : REX : bouton "Etude associe" pour importer
     directement le fichier .export li  la fiche slectionne.

Version 1.0.17 (2003/09/08) :

   - possibilit de copier tout un environnement (profil et fichiers associs) par le
     menu Fichier/Copier sous.

   - on conserve dans le flasheur (sur la machine d'excution) le profil export
     sous "nom_profil.pNUMERO".

   - les fichiers/rpertoires taient exports comme distants (avec user@mach:/...)
     alors qu'ils se trouvaient sur le serveur de calcul.

   - nouveau bouton d'options  ct de "Lancer" pour choisir le mode de lancement
     de l'tude : voir Aide/Paramtres du calcul.

   - ajout de nombreuses "bulles" d'aide (message dans la barre d'tat) quand le
     pointeur survole les lments de l'interface.

   - ATTENTION : run_aster 2.22 est ncessaire pour lancer le debugger en interactif.

   - ATTENTION : ajout dans le fichier de configuration de la partie serveur
     ASTK_SERV : "cmd_post" commande pour l'analyse d'un corefile aprs une excution,
     "cmd_dbg" commande pour excuter une tude avec le debugger en interactif.

   - sur la machine de rfrence : asdeno/asquit plus souples (pas d'enregistrement
     du profil), partie "produits" de la surcharge inactive si l'on choisit une
     action de l'AGLA.

   - sur la machine de rfrence : correction du titre de la fentre quand on passe
     d'une fiche REX  une autre.

Version 1.0.16 (2003/09/03) :

   - bug introduit en 1.0.15 : en cas de surcharge, on lanait l'tude avant de
     crer l'excutable !

   - lors de l'impression d'un fichier, la dernire imprimante slectionne
     apparaissait alors qu'on imprimait sur la premire de la liste.

   - sur la machine de rfrence :

      - possibilit de supprimer une fiche qui est encore dans l'tat
        EMIS_UA/EMIS_CUA par celui qui l'a mise.

      - le correcteur d'une fiche peut complter sa rponse tant que la fiche
        est dans l'tat A_VALIDER.

Version 1.0.15 (2003/09/01) :

   - asdeno : anomalie corrige, le nom du module tait mal export.

   - correction de l'affichage du message d'entte sous Linux.

   - correction du bug apparu en 1.0.6 quand on avait beaucoup (>40) de fichiers
     en donnes.

   - vrification : on applique les mmes rgles pour TESTS que pour ETUDE.

   - sur la machine de rfrence :

      - l'unit des dveloppeurs pouvait tre surcharge par une valeur anciennement
        renseigne : unit incorrecte lors de l'mission de fiches.

      - recherche dans les fiches REX : le filtre texte n'tait pas rinitialis pour
        "Fiches  corriger"

      - possibilit d'envoyer un message  l'assistance technique Aster.

Version 1.0.14 (2003/06/26) :

   - lancement d'une liste de tests (bouton TESTS) : le type 'test' est remplac par
     'rep_test' (c'est un rpertoire)
     En interactif (lanc avec run_aster), 'resu_test' est obligatoire pour dire o
     seront recopis les fichiers rsultats des tests.

   - anomalie connue non corrige : sous Linux, le message d'entte apparait avec des
     '\n' au lieu des sauts de ligne.

Version 1.0.13 (2003/06/17) :

   - anomalie corrige : problme pour rpondre  une fiche (stade d'avancement mal
     interprt).

   - sur la machine de rfrence : traitement pour les bases distantes.

   - correction pour le passage des paramtres optionnels pour les tests.

Version 1.0.12 (2003/06/12) :

   - bsf : raccourcis clavier pour le copier/couper/coller (CRTL+C, CRTL+X, CRTL+V).

   - bsf : anomalie corrige dans le couper/coller (seul le dernier fichier tait effac).

   - sur la machine de rfrence : impression des fiches REX et de la liste.

Version 1.0.11 (2003/06/05) :

   - configuration des commandes d'impression depuis le menu Fichier/Impression...

   - 'Imprimer' ajout dans le menu contextuel de la bsf et des listes de
     fichiers dans astk.

   - bsf : pour atteindre directement un rpertoire sans "browser", on peut
     choisir "---Direct---" pour aller directement dans le rpertoire de son choix.

   - bsf : correction de l'affichage avec des formats inhabituels de ls.

   - des arguments optionnels passs  l'excutable *Code_Aster* sont dfinis via le
     menu Options.

   - les paramtres optionnels pour le lancement d'une liste de tests peuvent tre
     modifis via le menu Options.

   - asjob : en batch, les jobs PEND ou SUSPENDED n'taient pas arrter quand on
     cliquait sur 'Supprimer'.

Version 1.0.10 (2003/06/03) :

   - anomalies corriges :

      - on exportait un fichier avec le nom de la machine mme quand celui-ci se
        trouvait sur la machine de calcul (faisait donc un rsh superflu).

      - prparer l'environnement tait incompatible avec la prsence d'un btc

      - sparation des catalogues d'lment et de commande dans run_aster.

      - problme lors de la recopie des rpertoires (comme une base) s'ils sont
        vus comme distants.

      - les fichiers points par des liens taient mal copis (les versions
        autres que NEW7 n'taient pas utilisables sur la machine de rfrence).

   - les rpertoires (base, repe, ensi) peuvent tre prsent au maximum une fois
     en donne et une fois en rsultat.

   - le script de soumission est recopi dans le flasheur (.u).

   - agla : demande confirmation si un asrest existe dj pour la version demande.

   - run_aster : arrt en cas de problme lors de la compilation des catalogues.

Version 1.0.9 (2003/05/27) :

   - problme corrig lors de la suppression d'une ligne dans TESTS.

   - sur la machine de rfrence : possibilit de rpondre aux fiches REX

   - la fentre des logs (Aide/Fenetre des messages) est indpendante, ouverte
     seulement sur demande.

   - ajout du type "repe" (rpertoire) dans ETUDE pour une volution future du
     traitement des fichiers et units logiques dans *Code_Aster*.

   - possibilit de configurer des commandes d'impression dans le fichier
     $HOME/astkrc/printers. La configuration "graphique" de ce fichier viendra plus tard !

Version 1.0.8 (2003/05/19) :

   - les boutons ETUDE et TESTS sont spars.

   - le numro d'unit logique est modifiable pour tous les types (aux risques
     de l'utilisateur).

   - ajout des types 'agraf' dans ETUDE, 'para' dans ETUDE et TESTS, 'datg' dans
     SURCHARGE.

   - sur la machine de rfrence : ajout des boutons 'prcdente' et 'suivante'
     pour consulter les fiches.

Version 1.0.7 (2003/05/15) :

   - asjob : demande de confirmation que pour les jobs non termins

   - asjob : correction d'un bug introduit en 1.0.6 lors du 'Rechercher'.

   - message plus sympatique quand on ne soumet pas le calcul (soumbtc=non).

   - import des profils au format asterix (.pret et .prex)

Version 1.0.6 (2003/05/14) :

   - l'extension '.astk' est impose pour le nom du profil, on peut ainsi les ouvrir
     automatiquement avec la bsf.

   - suppression des fentres de confirmation au lancement d'un calcul.

   - "Valeur par dfaut" dans le menu contextuel : reprend le nom du profil et ajoute
     l'extension correspondant au type (par ex.: nom_profil.mess).

   - "Editer" sur un rpertoire s'applique  tous les fichiers de ce rpertoire.

   - demande de confirmation avant de supprimer un job.

   - les situations dangereuses (comme avoir un excutable en rsultat, et une tude
     qui se ferait avec l'excutable de rfrence) sont interdites au moment de la
     soumission.

   - utilisation du btc : s'il est prsent : en Rsultat, on le construit,
     en Donne, on le soumet.

   - on limite les rcp/rsh aux machines distantes. ATTENTION : le test sur
     les machines est fait sur la racine du nom, on considre donc que les
     machines "machine1.domain.org" et "machine1" sont les mmes (de mme que
     "machine1.ailleurs.org"...).

   - bug connu : avec beaucoup de fichiers sources (environ 40 et +), la commande
     de vrification d'existence est trop longue. Solution : mettre les fichiers
     dans un rpertoire.

   - option 'astk --check' pour vrifier la connexion avec les serveurs.

Version 1.0.5 (2003/05/07) :

   - sur la machine de rfrence : consultation des fiches REX avec les filtres.

   - agla : correction lors de la recopie des tests, et des sources.

   - agla : ajout asdeno.

   - bsf : ajout de l'option '--inidir' pour choisir le rpertoire initial,
     '--inisrv' pour le serveur.

   - on ne pouvait pas avoir plusieurs bases.

   - surcharge : problme avec un catalogue de commande compil en donne ET
     rsultat si le rpertoire destination n'est pas encore cr.

   - si un fichier en donne est absent, on ne lance pas l'excution (avant ce
     n'tait qu'un avertissement).

Version 1.0.4 (2003/04/30) :

   - correction d'un bug introduit en 1.0.3 ( l'initialisation).

Version 1.0.3 (2003/04/30) :

   - lors de l'export du profil, on vrifie que les fichiers en donnes existent.
     Ceci permet aussi de vrifier que l'on a bien un fichier l o l'on attend
     un fichier, et un rpertoire l o l'on attend un rpertoire.

   - bsf : excution d'une commande shell

   - l'output des commandes n'tait pas rcupr dans l'interface, si on appelait
     /usr/ucb/ps sous Solaris.

   - vrifications complmentaires sur le profil avant de lancer une tude ou une
     surcharge.

   - nombre de lignes dans le tail de asjob : chelle de 30  150 lignes

Version 1.0.2 (2003/04/29) :

   - warning intempestif  l'excution car la version du client tait errone.

   - fenetre des messages disparait quand on change de langue (stdout I/O problems).

   - message  la premire utilisation d'une nouvelle version pour lire cet
     historique de mise  jour.

   - bsf : liste des rpertoires rordonnes pour que le dernier rpertoire "utilis"
     soit bien le dernier  tre supprim de la liste.

   - bsf : certains fichiers/rpertoires n'taient pas visibles avec des login ou
     group trop longs.

   - batch sur la machine de rfrence : DEFAUT_FICHIER sur des fichiers en rsultat.

Version 1.0.1 (2003/04/28) :

   - anomalie corrige : un rpertoire ne contenant qu'un caractre tait ignor.

   - ajout de l'historique des modifications accessible depuis le menu Aide.

Version 1.0 :

   - stabilise le 25 avril 2003

