# -*- coding: utf-8 -*-

# ==============================================================================
# COPYRIGHT (C) 1991 - 2003  EDF R&D                  WWW.CODE-ASTER.ORG
# THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
# IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
# THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
# (AT YOUR OPTION) ANY LATER VERSION.
#
# THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
# WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
# GENERAL PUBLIC LICENSE FOR MORE DETAILS.
#
# YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
# ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
#    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
# ==============================================================================

"""
Tools for developpers :
    - search available routines numbers (te, op, lc...)
"""


import os.path as osp
from glob import glob

from asrun.installation import aster_root
from asrun.common.i18n import _
from asrun.mystring import print3
from asrun.config import AsterConfig



def _get_available_routine(templ, max, format):
    """Return the list of available routines numbers."""
    lpos = set([format % i for i in range(max + 1)])
    lexis = [osp.basename(f) for f in glob(templ)]
    lavail = list(lpos.difference(lexis))
    lavail.sort()
    return lavail


def get_available_te(bibfor):
    """Return the list of available te routines numbers."""
    templ = osp.join(bibfor, '*', 'te[0-9]*.f')
    return _get_available_routine(templ, 600, "te%04d.f")


def get_available_op(bibfor):
    """Return the list of available te routines numbers."""
    templ = osp.join(bibfor, '*', 'op[0-9]*.f')
    return _get_available_routine(templ, 200, "op%04d.f")


def get_available_lc(bibfor):
    """Return the list of available te routines numbers."""
    templ = osp.join(bibfor, '*', 'lc[0-9]*.f')
    return _get_available_routine(templ, 200, "lc%04d.f")


def FreeSubroutines(run, *args):
    """Return available subroutines numbers.
    """
    MAX = 8
    if not run.get('aster_vers'):
        run.parser.error(_(u"You must define 'default_vers' in 'aster' configuration file or use '--vers' option."))
    REPREF = osp.join(aster_root, run['aster_vers'])
    if not run.get('config'):
        fconf = osp.join(REPREF, 'config.txt')
    else:
        fconf = osp.abspath(run['config'])
    conf = AsterConfig(fconf, run)

    if run['nolocal']:
        run.Mess(_(u'This operation only works on local source files. "--nolocal" option ignored'))

    bibfor = osp.join(REPREF, conf['SRCFOR'][0])

    lte = get_available_te(bibfor)
    lop = get_available_op(bibfor)
    llc = get_available_lc(bibfor)
    if not run.get('all_test'):
        lte = lte[:MAX]
        lop = lop[:MAX]
        llc = llc[:MAX]
    print3(_(u'List of the available TE subroutines :'))
    print ' '.join(lte)
    print
    print3(_(u'List of the available OP subroutines :'))
    print ' '.join(lop)
    print
    print3(_(u'List of the available LC subroutines :'))
    print ' '.join(llc)

