// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/DeducedArgument.h"
#include "Puma/CTemplateParamInfo.h"

namespace Puma {


DeducedArgument::DeducedArgument (CTemplateParamInfo *p, CTypeInfo *t, CTree *a, bool da, bool dia) {
  del = false;
  type = t->Duplicate ();
  value = 0;
  param = p;
  arg = a;
  default_arg = da;
  direct_arg = dia;
}

DeducedArgument::DeducedArgument (CTemplateParamInfo *p, CConstant *v, CTree *a, bool da, bool dia) {
  del = false;
  type = 0;
  value = p->ValueType () ? v->cast_to (p->ValueType ()) : v->duplicate ();
  param = p;
  arg = a;
  default_arg = da;
  direct_arg = dia;
}

DeducedArgument::DeducedArgument (CTemplateParamInfo *p, long val) {
  type = 0;
  param = p;
  value = new CConstant ((LONG_LONG)val, &CTYPE_LONG);
}

DeducedArgument::~DeducedArgument () {
  if (type)
    CTypeInfo::Destroy (type);
  if (value)
    delete value;
}

bool DeducedArgument::operator ==(const DeducedArgument &a) {
//  if ((Type () && ! a.Type ()) ||
//      (Value () && ! a.Value ()))
//    return false;
  if ((((bool)Type ()) != ((bool)a.Type ())) ||
      (((bool)Value ()) != ((bool)a.Value ())))
    return false;
  if (Type () && *Type () != *a.Type ())
    return false;
  if (Value () && *Value () != *a.Value ())
    return false;
  return true;
}

void DeducedArgument::print(std::ostream &os) const {
  if (Type()) {
    Type()->TypeText(os);
  }
  else if (Value()) {
    os << *Value();
  }
}


} // namespace Puma
