#-------------------------------------------------
# variables 
#-------------------------------------------------

ifeq ($(filter %-release,$(TARGET)),)

RELEASE := debug

else

RELEASE := release
endif

_TARGET := $(patsubst %-release,%,$(TARGET))

ifeq ($(_TARGET),win32)

CXX := mingw32-g++
CC  := mingw32-gcc
AR  := mingw32-ar
CPPFLAGS += -I $(ROOT)/src/win32/regex

else

CXX := g++
CC  := gcc
AR  := ar

endif


# if this is a release build, set the appropriate (specific) flags
ifeq ($(RELEASE),debug)

CFLAGS += -g

else

CFLAGS   += -O6
CPPFLAGS += -DNDEBUG

endif

# standard settings
ACFLAGS += $(AC_OPTFLAGS)
CFLAGS   += -Wall -pipe
CXXFLAGS += $(CFLAGS) -fno-rtti -fno-exceptions
CPPFLAGS += $(CPP_OPTFLAGS)
