// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CLanguage_h__
#define __CLanguage_h__

#include "Puma/DString.h"

// Entity name encoding language; language linkage

namespace Puma {


class CLanguage {
public:
  enum LangType {
    LANG_C,
    LANG_CPLUSPLUS,
    LANG_OTHER,
    LANG_UNDEFINED
  };
    
private:
  LangType m_Type;
  DString m_Text;

public:
  CLanguage () : m_Type (LANG_UNDEFINED), m_Text ("") {}
  
  void Type (LangType lt) { 
    m_Type = lt; m_Text = (lt==LANG_C)?"C":(lt==LANG_CPLUSPLUS)?"C++":""; 
  }
  void Type (LangType lt, const char *txt) { 
    m_Type = lt; m_Text = (lt==LANG_C)?"C":(lt==LANG_CPLUSPLUS)?"C++":(lt==LANG_OTHER)?txt:""; 
  }

  LangType Type () const { return m_Type; }
  const DString &Text () const { return m_Text; }

  bool operator== (const CLanguage &lang) { return (m_Type == lang.Type ()) && (m_Text == lang.Text ()); }
  bool operator== (LangType lt) { return (m_Type == lt); }
};


} // namespace Puma

#endif /* __CLanguage_h__ */
