// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ACTree_h__
#define __ACTree_h__

#include "Puma/CTree.h"

namespace Puma {


class CT_AdviceDecl : public CT_Decl {
  CTree *_advice;    // CT_Token
  CTree *_pointcut;
  CTree *_colon;     // CT_Token
  CTree *_decl;

public:
  CT_AdviceDecl (CTree *a, CTree *p, CTree *c, CTree *d) : 
    _advice (a), _pointcut (p), _colon (c), _decl (d) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 4; }
  CTree *Son (int n) const { 
    switch (n) { 
      case 0: return _advice;
      case 1: return _pointcut;
      case 2: return _colon;
      case 3: return _decl;
      default: return (CTree*)0;
    }
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    if (old_son == _decl) _decl = new_son; 
    else if (old_son == _pointcut) _pointcut = new_son; 
    else if (old_son == _advice) _advice = new_son; 
    else if (old_son == _colon) _colon = new_son; 
  }
  CTree *Pointcut () const { return _pointcut; }
  CTree *Decl () const { return _decl; }
};

class CT_OrderList : public CT_List {
public:
  CT_OrderList () { AddProperties (SEPARATORS | OPEN_CLOSE); }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
};

class CT_OrderDecl : public CTree {
  CTree *_order;
  CTree *_order_list;
  CTree *_semi_colon;
public:
  CT_OrderDecl (CTree *o, CTree *ol, CTree *s) :
    _order (o), _order_list (ol), _semi_colon (s) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { 
    switch (n) { 
      case 0: return _order;
      case 1: return _order_list;
      case 2: return _semi_colon;
      default: return (CTree*)0;
    }
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    if (old_son == _order) _order = new_son; 
    else if (old_son == _order_list) _order_list = new_son; 
    else if (old_son == _semi_colon) _semi_colon = new_son; 
  }
  CT_OrderList *OrderList () const { return (CT_OrderList*)_order_list; }
};

class CT_PointcutDecl : public CT_Decl {
  CTree *_pointcut;    // CT_Token
  CTree *_decl;

public:
  CT_PointcutDecl (CTree *p, CTree *d) : _pointcut (p), _decl (d) {}
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 2; }
  CTree *Son (int n) const { 
    switch (n) { 
      case 0: return _pointcut;
      case 1: return _decl;
      default: return (CTree*)0;
    }
  }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    if (old_son == _decl) _decl = new_son; 
    else if (old_son == _pointcut) _pointcut = new_son; 
  }
  CTree *Decl () const { return _decl; }
};

class CT_Intro : public CT_List, public CSemScope {
  // indices of aspect or slice names in introduction
  Array<int> _name_indices;    // start index
  Array<int> _name_to_indices; // end index
  Array<bool> _name_qual;      // true if the token should be replaced by a
                               // qualified name
public:
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  void AddNameIndex (int index) {
    _name_indices.append (index);
    _name_to_indices.append (index);
    _name_qual.append (false);
  }
  void AddNameIndex (int index_from, int index_to) {
    _name_indices.append (index_from);
    _name_to_indices.append (index_to);
    _name_qual.append (true);
  }
  void RollbackNameIndex (int pos) {
    for (int i = NameIndices () - 1; i >= 0; i--) {
      if (NameIndex (i) >= pos) {
        _name_indices.remove (i);
        _name_to_indices.remove (i);
        _name_qual.remove (i);
      }
      else
        break;
    }
  }
  int NameIndices () const { return _name_indices.length (); }
  int NameIndex (int i) const { return _name_indices.lookup (i); }
  int NameToIndex (int i) const { return _name_to_indices.lookup (i); }
  bool NameQual (int i) const { return _name_qual.lookup (i); }
};

class CT_ClassSliceDecl : public CTree, public CSemObject {
  CTree *sons[6]; // SLICE? <key>? <name>? <baseclasses>? <members> ;
public:
  CT_ClassSliceDecl (CTree *sl, CTree *k, CTree *n, CTree *b, CTree *m, CTree *se) {
    sons[0] = sl; sons[1] = k; sons[2] = n; sons[3] = b; sons[4] = m; sons[5] = se;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return CTree::Sons (sons, 6); }
  CTree *Son (int n) const { return CTree::Son (sons, 6, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 6, old_son, new_son);
  }
  CT_Token *key () const { return (CT_Token*)sons[1]; }
  CT_SimpleName *name () const { return (CT_SimpleName*)sons[2]; }
  CT_Intro *base_clause () const { return (CT_Intro*)sons[3]; }
  CT_Intro *members () const { return (CT_Intro*)sons[4]; }
};

class CT_SliceRef : public CTree {
  CTree *sons[3];
public:
  CT_SliceRef (CTree *sl, CTree *n, CTree *se) {
    sons[0] = sl; sons[1] = n; sons[2] = se;
  }
  static const char *NodeId ();
  const char *NodeName () const { return NodeId (); }
  int Sons () const { return 3; }
  CTree *Son (int n) const { return CTree::Son (sons, 3, n); }
  void ReplaceSon (CTree *old_son, CTree *new_son) { 
    CTree::ReplaceSon (sons, 3, old_son, new_son);
  }
  CT_SimpleName *name () const { return (CT_SimpleName*)sons[1]; }
};


} // namespace Puma

#endif /* __ACTree_h__ */
