// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTemplateParamInfo_h__
#define __CTemplateParamInfo_h__

// template parameter info
// knows whether it is a type, non-type, or template 
// template parameter

#include "Puma/CObjectInfo.h"

namespace Puma {


class CT_TemplateParamDecl;
class CTypeTemplateParam;
class CTemplateInfo;
class CT_ExprList;

class CTemplateParamInfo : public CObjectInfo {
  CTemplateInfo *_TemplateInfo;
  CTemplateInfo *_TemplateTemplate;
  CTypeInfo *_ValueType;
  bool _TypeParam;

public: 
  CTemplateParamInfo ();
  ~CTemplateParamInfo ();
  
  // Get ...
  bool isTemplate () const;                  // is template template parameter?
  bool isTypeParam () const;                 // is type parameter?
  CTemplateInfo *TemplateInfo () const;      // the template parameters of the
  CTemplateInfo *TemplateTemplate () const;  // the template parameters of
  CT_TemplateParamDecl *Tree () const;       // the template template parameter
  CT_ExprList *DefaultArgument () const;     // default template argument
  CTypeTemplateParam *TypeInfo () const; 
  CTypeInfo *ValueType () const;
  int getPosition () const;                  // position in template parameter list

  // Set ...
  void isTypeParam (bool);
  void ValueType (CTypeInfo *);
  void TemplateInfo (CTemplateInfo *);
  void TemplateTemplate (CTemplateInfo *);
};

inline CTemplateParamInfo::CTemplateParamInfo () :
  CObjectInfo (CObjectInfo::TEMPLATE_PARAM_INFO),
  _TemplateInfo ((CTemplateInfo*)0),
  _TemplateTemplate ((CTemplateInfo*)0),
  _ValueType ((CTypeInfo*)0),
  _TypeParam (false)
 {}

inline void CTemplateParamInfo::isTypeParam (bool tp)
 { _TypeParam = tp; }
inline bool CTemplateParamInfo::isTypeParam () const 
 { return _TypeParam; }

inline bool CTemplateParamInfo::isTemplate () const 
 { return (_TemplateTemplate); }
 
inline void CTemplateParamInfo::ValueType (CTypeInfo *vt) 
 { _ValueType = vt; }
inline CTypeInfo *CTemplateParamInfo::ValueType () const 
 { return _ValueType; }

inline CTemplateInfo *CTemplateParamInfo::TemplateInfo () const
 { return _TemplateInfo; }
inline CTemplateInfo *CTemplateParamInfo::TemplateTemplate () const
 { return _TemplateTemplate; }
inline void CTemplateParamInfo::TemplateInfo (CTemplateInfo *info) 
 { _TemplateInfo = info; }
inline void CTemplateParamInfo::TemplateTemplate (CTemplateInfo *info) 
 { _TemplateTemplate = info; }

inline CT_TemplateParamDecl *CTemplateParamInfo::Tree () const 
 { return (CT_TemplateParamDecl*)CObjectInfo::Tree (); }

inline CTypeTemplateParam *CTemplateParamInfo::TypeInfo () const
 { return (CTypeTemplateParam*)CObjectInfo::TypeInfo (); }


} // namespace Puma

#endif /* __CTemplateParamInfo_h__ */
