// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CBaseClassInfo_h__
#define __CBaseClassInfo_h__

// base class info (used by CClassInfo)

#include "Puma/CScopeRequest.h"
#include "Puma/CProtection.h"

namespace Puma {

class CClassInfo;
class CT_BaseSpec;

/** \file 
 *  Representation of a base class of a class. 
 *  \see Puma::CBaseClassInfo */

/** \class CBaseClassInfo CBaseClassInfo.h Puma/infos/CBaseClassInfo.h
 *  A CBaseClassInfo object represents a base class of a class. */
class CBaseClassInfo : public CScopeRequest {
  /** the info object of the base class */
  CClassInfo        *_Class;
  /** the info object of the pseudo instance if the base class is a pseudo i. */
  CClassInfo        *_ClassPseudoInstance;
  
public: 
  /** Construct a new base class info. */
  CBaseClassInfo ();
  /** Destruct the base class info. If the object id is 
   *  \c BASECLASS_INFO, Puma::CObjectInfo::CleanUp() is called. */
  ~CBaseClassInfo ();
  
  /** Get the class info of the base class. */
  CClassInfo *Class () const;
  /** Get the class info if the base class is a template pseudo instance */
  CClassInfo *ClassPseudoInstance () const;
  /** Set the class info of the base class. */
  void Class (CClassInfo *);

  /** Get the syntax tree node of the base class specifier. */
  CT_BaseSpec *Tree () const;
};

inline CBaseClassInfo::CBaseClassInfo () :
  CScopeRequest (CObjectInfo::BASECLASS_INFO),
  _Class ((CClassInfo*)0)
 {}


inline CClassInfo *CBaseClassInfo::Class () const {
  return _Class;
}

inline CClassInfo *CBaseClassInfo::ClassPseudoInstance () const {
  return _ClassPseudoInstance;
}

} // namespace Puma

#endif /* __CBaseClassInfo_h__ */
